/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.search.HighlightingCaches;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.HashSetQueue;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ForkJoinPool;
import org.jetbrains.annotations.NotNull;

public class JavaClassInheritorsSearcher
extends QueryExecutorBase<PsiClass, ClassInheritorsSearch.SearchParameters> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processQuery(@NotNull ClassInheritorsSearch.SearchParameters parameters, @NotNull Processor<PsiClass> consumer) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processQuery"));
        }
        PsiClass baseClass = parameters.getClassToProcess();
        assert (parameters.isCheckDeep());
        assert (parameters.isCheckInheritance());
        ProgressIndicator progress = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progress != null) {
            progress.pushState();
            String className = ApplicationManager.getApplication().runReadAction(baseClass::getName);
            progress.setText(className != null ? PsiBundle.message("psi.search.inheritors.of.class.progress", className) : PsiBundle.message("psi.search.inheritors.progress", new Object[0]));
        }
        try {
            JavaClassInheritorsSearcher.processInheritors(parameters, consumer);
        }
        finally {
            if (progress != null) {
                progress.popState();
            }
        }
    }

    private static boolean processInheritors(@NotNull ClassInheritorsSearch.SearchParameters parameters, @NotNull Processor<PsiClass> consumer) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processInheritors"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processInheritors"));
        }
        PsiClass baseClass = parameters.getClassToProcess();
        if (baseClass instanceof PsiAnonymousClass || JavaClassInheritorsSearcher.isFinal(baseClass)) {
            return true;
        }
        SearchScope searchScope = parameters.getScope();
        Project project = PsiUtilCore.getProjectInReadAction(baseClass);
        if (JavaClassInheritorsSearcher.isJavaLangObject(baseClass)) {
            return AllClassesSearch.search(searchScope, project, parameters.getNameCondition()).forEach(aClass -> {
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "lambda$processInheritors$0"));
                }
                ProgressManager.checkCanceled();
                return JavaClassInheritorsSearcher.isJavaLangObject(aClass) || consumer.process((PsiClass)aClass);
            });
        }
        if (searchScope instanceof LocalSearchScope) {
            return JavaClassInheritorsSearcher.processLocalScope(project, parameters, (LocalSearchScope)searchScope, baseClass, consumer);
        }
        Iterable<PsiClass> cached = JavaClassInheritorsSearcher.getOrComputeSubClasses(project, baseClass);
        for (PsiClass subClass : cached) {
            ProgressManager.checkCanceled();
            if (subClass instanceof PsiAnonymousClass && !parameters.isIncludeAnonymous() || !ApplicationManager.getApplication().runReadAction(() -> {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "lambda$processInheritors$1"));
                }
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "lambda$processInheritors$1"));
                }
                return JavaClassInheritorsSearcher.checkCandidate(subClass, parameters) && !consumer.process(subClass);
            }).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Iterable<PsiClass> getOrComputeSubClasses(@NotNull Project project, @NotNull PsiClass baseClass) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "getOrComputeSubClasses"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "getOrComputeSubClasses"));
        }
        ConcurrentMap<PsiClass, Iterable<PsiClass>> map = HighlightingCaches.getInstance((Project)project).ALL_SUB_CLASSES;
        Iterable cached = (Iterable)map.get(baseClass);
        if (cached == null) {
            AllSubClassesLazyCollection computed = new AllSubClassesLazyCollection(project, baseClass);
            boolean isPhysical = ApplicationManager.getApplication().runReadAction(baseClass::isPhysical);
            cached = isPhysical ? (Iterable)ConcurrencyUtil.cacheOrGet(map, baseClass, computed) : computed;
        }
        Iterable iterable = cached;
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "getOrComputeSubClasses"));
        }
        return iterable;
    }

    private static boolean processLocalScope(final @NotNull Project project, final @NotNull ClassInheritorsSearch.SearchParameters parameters, @NotNull LocalSearchScope searchScope, final @NotNull PsiClass baseClass, final @NotNull Processor<PsiClass> consumer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processLocalScope"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processLocalScope"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processLocalScope"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processLocalScope"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processLocalScope"));
        }
        VirtualFile[] virtualFiles = searchScope.getVirtualFiles();
        final boolean[] success = new boolean[]{true};
        for (final VirtualFile virtualFile : virtualFiles) {
            ProgressManager.checkCanceled();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    PsiFile psiFile = PsiManager.getInstance(project).findFile(virtualFile);
                    if (psiFile != null) {
                        psiFile.accept(new JavaRecursiveElementVisitor(){

                            @Override
                            public void visitClass(PsiClass candidate) {
                                ProgressManager.checkCanceled();
                                if (!success[0]) {
                                    return;
                                }
                                if (candidate.isInheritor(baseClass, true) && JavaClassInheritorsSearcher.checkCandidate(candidate, parameters) && !consumer.process(candidate)) {
                                    success[0] = false;
                                    return;
                                }
                                super.visitClass(candidate);
                            }

                            @Override
                            public void visitCodeBlock(PsiCodeBlock block) {
                                ProgressManager.checkCanceled();
                                if (!parameters.isIncludeAnonymous()) {
                                    return;
                                }
                                super.visitCodeBlock(block);
                            }
                        });
                    }
                }
            });
        }
        return success[0];
    }

    private static boolean checkCandidate(@NotNull PsiClass candidate, @NotNull ClassInheritorsSearch.SearchParameters parameters) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "checkCandidate"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "checkCandidate"));
        }
        SearchScope searchScope = parameters.getScope();
        ProgressManager.checkCanceled();
        if (!PsiSearchScopeUtil.isInScope(searchScope, (PsiElement)candidate)) {
            return false;
        }
        if (candidate instanceof PsiAnonymousClass) {
            return true;
        }
        String name = candidate.getName();
        return name != null && parameters.getNameCondition().value(name);
    }

    static boolean isJavaLangObject(@NotNull PsiClass baseClass) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "isJavaLangObject"));
        }
        return ApplicationManager.getApplication().runReadAction(() -> {
            if (baseClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "lambda$isJavaLangObject$2"));
            }
            return baseClass.isValid() && "java.lang.Object".equals(baseClass.getQualifiedName());
        });
    }

    private static boolean isFinal(@NotNull PsiClass baseClass) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "isFinal"));
        }
        return ApplicationManager.getApplication().runReadAction(() -> {
            if (baseClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "lambda$isFinal$3"));
            }
            return baseClass.hasModifierProperty("final");
        });
    }

    private static class AllSubClassesLazyCollection
    implements Iterable<PsiClass> {
        private final HashSetQueue<PsiAnchor> subClasses;
        private final Object lock;
        private final GlobalSearchScope projectScope;
        private final Semaphore currentlyProcessingClasses;
        private final HashSetQueue.PositionalIterator<PsiAnchor> candidatesToFindSubclassesIterator;
        private static final Key<ClassProcessingStatus> PROCESSING_SUBCLASSES_STATUS = Key.create("PROCESSING_SUBCLASSES_STATUS");

        AllSubClassesLazyCollection(@NotNull Project project, @NotNull PsiClass baseClass) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher$AllSubClassesLazyCollection", "<init>"));
            }
            if (baseClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher$AllSubClassesLazyCollection", "<init>"));
            }
            this.subClasses = new HashSetQueue();
            this.lock = new Object();
            this.currentlyProcessingClasses = new Semaphore();
            this.candidatesToFindSubclassesIterator = this.subClasses.iterator();
            this.projectScope = GlobalSearchScope.allScope(project);
            this.subClasses.add(ApplicationManager.getApplication().runReadAction(() -> {
                if (baseClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher$AllSubClassesLazyCollection", "lambda$new$0"));
                }
                return PsiAnchor.create(baseClass);
            }));
        }

        @Override
        @NotNull
        public Iterator<PsiClass> iterator() {
            Iterator<PsiClass> iterator = new Iterator<PsiClass>(){
                private final Iterator<PsiAnchor> subClassIterator;
                {
                    this.subClassIterator = subClasses.iterator();
                    Object object = lock;
                    synchronized (object) {
                        this.subClassIterator.next();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean hasNext() {
                    Object object = lock;
                    synchronized (object) {
                        if (this.subClassIterator.hasNext()) {
                            return true;
                        }
                    }
                    this.processMoreSubclasses(this.subClassIterator);
                    object = lock;
                    synchronized (object) {
                        return this.subClassIterator.hasNext();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public PsiClass next() {
                    PsiAnchor next;
                    Object object = lock;
                    synchronized (object) {
                        next = this.subClassIterator.next();
                    }
                    return ApplicationManager.getApplication().runReadAction(() -> (PsiClass)next.retrieve());
                }
            };
            if (iterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher$AllSubClassesLazyCollection", "iterator"));
            }
            return iterator;
        }

        private PsiClass findNextClassInQueue(@NotNull HashSetQueue.PositionalIterator.IteratorPosition<PsiAnchor> position) {
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher$AllSubClassesLazyCollection", "findNextClassInQueue"));
            }
            PsiClass candidate = null;
            boolean foundClassBeingProcessed = false;
            while (position != null) {
                ProgressManager.checkCanceled();
                PsiAnchor anchor = position.peek();
                candidate = (PsiClass)anchor.retrieve();
                if (candidate instanceof PsiAnonymousClass || candidate != null && candidate.hasModifierProperty("final")) {
                    candidate = null;
                }
                if (candidate != null) {
                    ClassProcessingStatus status = candidate.getUserData(PROCESSING_SUBCLASSES_STATUS);
                    if (status == null) {
                        candidate.putUserData(PROCESSING_SUBCLASSES_STATUS, ClassProcessingStatus.PROCESSING_SUBCLASSES);
                        break;
                    }
                    foundClassBeingProcessed |= status == ClassProcessingStatus.PROCESSING_SUBCLASSES;
                }
                if (!foundClassBeingProcessed) {
                    this.candidatesToFindSubclassesIterator.next();
                    if (candidate != null) {
                        candidate.putUserData(PROCESSING_SUBCLASSES_STATUS, null);
                    }
                }
                candidate = null;
                position = position.next();
            }
            return candidate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processMoreSubclasses(final @NotNull Iterator<PsiAnchor> subClassIterator) {
            if (subClassIterator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subClassIterator", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher$AllSubClassesLazyCollection", "processMoreSubclasses"));
            }
            while (true) {
                ProgressManager.checkCanceled();
                PsiClass candidate = ApplicationManager.getApplication().runReadAction(new Computable<PsiClass>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public PsiClass compute() {
                        Object object = lock;
                        synchronized (object) {
                            PsiClass candidate;
                            HashSetQueue.PositionalIterator.IteratorPosition startPosition = candidatesToFindSubclassesIterator.position().next();
                            PsiClass psiClass = candidate = startPosition == null ? null : this.findNextClassInQueue(startPosition);
                            if (candidate != null) {
                                currentlyProcessingClasses.down();
                            }
                            return candidate;
                        }
                    }
                });
                if (candidate == null) break;
                try {
                    DirectClassInheritorsSearch.search(candidate, this.projectScope).forEach((Result subClass) -> {
                        ProgressManager.checkCanceled();
                        PsiAnchor pointer = PsiAnchor.create(subClass);
                        Object object = this.lock;
                        synchronized (object) {
                            this.subClasses.add(pointer);
                        }
                        return true;
                    });
                }
                finally {
                    candidate.putUserData(PROCESSING_SUBCLASSES_STATUS, ClassProcessingStatus.PROCESSING_FINISHED);
                    this.currentlyProcessingClasses.up();
                }
                Object object = this.lock;
                synchronized (object) {
                    if (subClassIterator.hasNext()) {
                        return;
                    }
                }
            }
            try {
                ForkJoinPool.managedBlock(new ForkJoinPool.ManagedBlocker(){

                    @Override
                    public boolean block() throws InterruptedException {
                        currentlyProcessingClasses.waitFor();
                        return this.isReleasable();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean isReleasable() {
                        Object object = lock;
                        synchronized (object) {
                            return !currentlyProcessingClasses.isDown() || subClassIterator.hasNext();
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        static enum ClassProcessingStatus {
            PROCESSING_SUBCLASSES,
            PROCESSING_FINISHED;

        }
    }
}

