/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class ConstantDeclaredInAbstractClassInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("constant.declared.in.abstract.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ConstantDeclaredInAbstractClassInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("constant.declared.in.abstract.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ConstantDeclaredInAbstractClassInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantDeclaredInAbstractClassVisitor();
    }

    private static class ConstantDeclaredInAbstractClassVisitor
    extends BaseInspectionVisitor {
        private ConstantDeclaredInAbstractClassVisitor() {
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/classlayout/ConstantDeclaredInAbstractClassInspection$ConstantDeclaredInAbstractClassVisitor", "visitField"));
            }
            if (!(field.hasModifierProperty("static") && field.hasModifierProperty("public") && field.hasModifierProperty("final"))) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.isInterface() || containingClass.isAnnotationType() || containingClass.isEnum()) {
                return;
            }
            if (!containingClass.hasModifierProperty("abstract")) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }
    }
}

