/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodInheritanceUtils;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MethodReturnAlwaysConstantInspection
extends BaseGlobalInspection {
    private static final Key<Boolean> ALWAYS_CONSTANT = Key.create("ALWAYS_CONSTANT");

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.return.always.constant.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/MethodReturnAlwaysConstantInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/siyeh/ig/classlayout/MethodReturnAlwaysConstantInspection", "checkElement"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/siyeh/ig/classlayout/MethodReturnAlwaysConstantInspection", "checkElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/siyeh/ig/classlayout/MethodReturnAlwaysConstantInspection", "checkElement"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/siyeh/ig/classlayout/MethodReturnAlwaysConstantInspection", "checkElement"));
        }
        if (!(refEntity instanceof RefMethod)) {
            return null;
        }
        RefMethod refMethod = (RefMethod)refEntity;
        Boolean alreadyProcessed = refMethod.getUserData(ALWAYS_CONSTANT);
        if (alreadyProcessed != null && alreadyProcessed.booleanValue()) {
            return null;
        }
        if (!(refMethod.getElement() instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method = (PsiMethod)refMethod.getElement();
        if (method.getBody() == null) {
            return null;
        }
        if (!MethodReturnAlwaysConstantInspection.alwaysReturnsConstant(method)) {
            return null;
        }
        Set<RefMethod> siblingMethods = MethodInheritanceUtils.calculateSiblingMethods(refMethod);
        for (RefMethod siblingMethod : siblingMethods) {
            PsiMethod siblingPsiMethod = (PsiMethod)siblingMethod.getElement();
            if (method.getBody() == null || MethodReturnAlwaysConstantInspection.alwaysReturnsConstant(siblingPsiMethod)) continue;
            return null;
        }
        ArrayList<ProblemDescriptor> out = new ArrayList<ProblemDescriptor>();
        for (RefMethod siblingRefMethod : siblingMethods) {
            PsiMethod siblingMethod = (PsiMethod)siblingRefMethod.getElement();
            PsiIdentifier identifier = siblingMethod.getNameIdentifier();
            if (identifier == null) continue;
            out.add(manager.createProblemDescriptor((PsiElement)identifier, InspectionGadgetsBundle.message("method.return.always.constant.problem.descriptor", new Object[0]), false, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
            siblingRefMethod.putUserData(ALWAYS_CONSTANT, true);
        }
        return out.toArray(new ProblemDescriptor[out.size()]);
    }

    private static boolean alwaysReturnsConstant(PsiMethod method) {
        PsiCodeBlock body = method.getBody();
        PsiStatement statement = ControlFlowUtils.getOnlyStatementInBlock(body);
        if (!(statement instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
        PsiExpression value = returnStatement.getReturnValue();
        return value != null && PsiUtil.isConstantExpression(value);
    }
}

