/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Getter;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import java.awt.Window;
import java.util.Arrays;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;

public class ComponentTreeEventDispatcher<T extends EventListener> {
    private final Class<T> myListenerClass;
    private final T myMulticaster;

    public static <T extends EventListener> ComponentTreeEventDispatcher<T> create(@NotNull Class<T> listenerClass) {
        if (listenerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listenerClass", "com/intellij/util/ComponentTreeEventDispatcher", "create"));
        }
        return new ComponentTreeEventDispatcher<T>(listenerClass);
    }

    private ComponentTreeEventDispatcher(@NotNull Class<T> listenerClass) {
        if (listenerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listenerClass", "com/intellij/util/ComponentTreeEventDispatcher", "<init>"));
        }
        this.myListenerClass = listenerClass;
        this.myMulticaster = (EventListener)EventDispatcher.createMulticaster(listenerClass, new Getter<Iterable<T>>(){

            @Override
            public Iterable<T> get() {
                return ((JBTreeTraverser)UIUtil.uiTraverser(null).withRoots(Arrays.asList(Window.getWindows()))).postOrderDfsTraversal().filter(ComponentTreeEventDispatcher.this.myListenerClass);
            }
        });
    }

    @NotNull
    public T getMulticaster() {
        T t = this.myMulticaster;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ComponentTreeEventDispatcher", "getMulticaster"));
        }
        return t;
    }
}

