/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class LambdaUnfriendlyMethodOverloadInspectionBase
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("lambda.unfriendly.method.overload.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/LambdaUnfriendlyMethodOverloadInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiMethod method = (PsiMethod)infos[0];
        String string = InspectionGadgetsBundle.message(method.isConstructor() ? "lambda.unfriendly.constructor.overload.problem.descriptor" : "lambda.unfriendly.method.overload.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/LambdaUnfriendlyMethodOverloadInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LambdaUnfriendlyMethodOverloadVisitor();
    }

    private static class LambdaUnfriendlyMethodOverloadVisitor
    extends BaseInspectionVisitor {
        private LambdaUnfriendlyMethodOverloadVisitor() {
        }

        @Override
        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            PsiParameterList parameterList = method.getParameterList();
            int parametersCount = parameterList.getParametersCount();
            if (parametersCount == 0) {
                return;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            int functionalIndex = -1;
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter = parameters[i];
                if (!LambdaUtil.isFunctionalType(parameter.getType())) continue;
                functionalIndex = i;
                break;
            }
            if (functionalIndex < 0) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String name = method.getName();
            for (PsiMethod sameNameMethod : containingClass.findMethodsByName(name, true)) {
                PsiType functionalType;
                PsiParameterList otherParameterList;
                if (method.equals(sameNameMethod) || PsiSuperMethodUtil.isSuperMethod(method, sameNameMethod) || parametersCount != (otherParameterList = sameNameMethod.getParameterList()).getParametersCount()) continue;
                PsiParameter[] otherParameters = otherParameterList.getParameters();
                PsiType otherFunctionalType = otherParameters[functionalIndex].getType();
                if (!LambdaUnfriendlyMethodOverloadVisitor.areOtherParameterTypesConvertible(parameters, otherParameters, functionalIndex) || !LambdaUtil.isFunctionalType(otherFunctionalType) || !LambdaUnfriendlyMethodOverloadVisitor.areSameShapeFunctionalTypes(functionalType = parameters[functionalIndex].getType(), otherFunctionalType)) continue;
                this.registerMethodError(method, method);
                return;
            }
        }

        private static boolean areSameShapeFunctionalTypes(PsiType one, PsiType two) {
            PsiMethod method1 = LambdaUtil.getFunctionalInterfaceMethod(one);
            PsiMethod method2 = LambdaUtil.getFunctionalInterfaceMethod(two);
            if (method1 == null || method2 == null) {
                return false;
            }
            PsiType returnType1 = method1.getReturnType();
            PsiType returnType2 = method2.getReturnType();
            if (PsiType.VOID.equals(returnType1) ^ PsiType.VOID.equals(returnType2)) {
                return false;
            }
            return method1.getParameterList().getParametersCount() == method2.getParameterList().getParametersCount();
        }

        private static boolean areOtherParameterTypesConvertible(PsiParameter[] parameters, PsiParameter[] otherParameters, int notThisOne) {
            for (int i = 0; i < parameters.length; ++i) {
                PsiType otherType;
                PsiType type;
                if (i == notThisOne || (type = parameters[i].getType()).isAssignableFrom(otherType = otherParameters[i].getType()) || otherType.isAssignableFrom(type)) continue;
                return false;
            }
            return true;
        }
    }
}

