/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.SerializationUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SerializableClassInSecureContextInspection
extends BaseInspection {
    public boolean ignoreThrowable = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("serializable.class.in.secure.context.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/security/SerializableClassInSecureContextInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("serializable.class.in.secure.context.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/security/SerializableClassInSecureContextInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("ignore.classes.extending.throwable.option", new Object[0]), this, "ignoreThrowable");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SerializableClassInSecureContextVisitor();
    }

    @Override
    public String getAlternativeID() {
        return "serial";
    }

    private class SerializableClassInSecureContextVisitor
    extends BaseInspectionVisitor {
        private SerializableClassInSecureContextVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass) {
            PsiMethod[] methods;
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/security/SerializableClassInSecureContextInspection$SerializableClassInSecureContextVisitor", "visitClass"));
            }
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter || !SerializationUtils.isSerializable(aClass)) {
                return;
            }
            for (PsiMethod method : methods = aClass.findMethodsByName("writeObject", true)) {
                if (!SerializationUtils.isWriteObject(method)) continue;
                if (!ControlFlowUtils.methodAlwaysThrowsException((PsiMethod)method.getNavigationElement())) break;
                return;
            }
            if (SerializableClassInSecureContextInspection.this.ignoreThrowable && InheritanceUtil.isInheritor(aClass, false, "java.lang.Throwable")) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

