/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import org.jetbrains.annotations.NotNull;

public class GlobalInspectionContextUtil {
    public static RefElement retrieveRefElement(@NotNull PsiElement element, @NotNull GlobalInspectionContext globalContext) {
        PsiLanguageInjectionHost context;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/GlobalInspectionContextUtil", "retrieveRefElement"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/ex/GlobalInspectionContextUtil", "retrieveRefElement"));
        }
        PsiFile elementFile = element.getContainingFile();
        RefElement refElement = globalContext.getRefManager().getReference(elementFile);
        if (refElement == null && (context = InjectedLanguageManager.getInstance(elementFile.getProject()).getInjectionHost(elementFile)) != null) {
            refElement = globalContext.getRefManager().getReference(context.getContainingFile());
        }
        return refElement;
    }

    public static boolean canRunInspections(@NotNull Project project, boolean online) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/GlobalInspectionContextUtil", "canRunInspections"));
        }
        for (InspectionExtensionsFactory factory : Extensions.getExtensions(InspectionExtensionsFactory.EP_NAME)) {
            if (factory.isProjectConfiguredToRunInspections(project, online)) continue;
            return false;
        }
        return true;
    }
}

