/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indentation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractIndentParser
implements PsiParser {
    protected PsiBuilder myBuilder;
    protected int myCurrentIndent;
    protected HashMap<PsiBuilder.Marker, Integer> myIndents;
    protected HashMap<PsiBuilder.Marker, Boolean> myNewLines;
    protected boolean myNewLine = true;

    @Override
    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        this.myNewLines = new HashMap();
        this.myIndents = new HashMap();
        this.myBuilder = builder;
        this.parseRoot(root);
        ASTNode aSTNode = this.myBuilder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/indentation/AbstractIndentParser", "parse"));
        }
        return aSTNode;
    }

    protected abstract void parseRoot(IElementType var1);

    public PsiBuilder.Marker mark(boolean couldBeRolledBack) {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (couldBeRolledBack) {
            this.myIndents.put(marker, this.myCurrentIndent);
            this.myNewLines.put(marker, this.myNewLine);
        }
        return marker;
    }

    public PsiBuilder.Marker mark() {
        return this.mark(false);
    }

    public void done(@NotNull PsiBuilder.Marker marker, @NotNull IElementType elementType) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/indentation/AbstractIndentParser", "done"));
        }
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/indentation/AbstractIndentParser", "done"));
        }
        this.myIndents.remove(marker);
        this.myNewLines.remove(marker);
        marker.done(elementType);
    }

    public static void collapse(@NotNull PsiBuilder.Marker marker, @NotNull IElementType elementType) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/indentation/AbstractIndentParser", "collapse"));
        }
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/indentation/AbstractIndentParser", "collapse"));
        }
        marker.collapse(elementType);
    }

    protected static void drop(@NotNull PsiBuilder.Marker marker) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/indentation/AbstractIndentParser", "drop"));
        }
        marker.drop();
    }

    protected void rollbackTo(@NotNull PsiBuilder.Marker marker) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/indentation/AbstractIndentParser", "rollbackTo"));
        }
        if (this.myIndents.get(marker) == null) {
            throw new RuntimeException("Parser can't rollback marker that was created by mark() method, use mark(true) instead");
        }
        this.myCurrentIndent = (Integer)this.myIndents.get(marker);
        this.myNewLine = (Boolean)this.myNewLines.get(marker);
        this.myIndents.remove(marker);
        this.myNewLines.remove(marker);
        marker.rollbackTo();
    }

    protected boolean eof() {
        return this.myBuilder.eof();
    }

    protected int getCurrentOffset() {
        return this.myBuilder.getCurrentOffset();
    }

    public int getCurrentIndent() {
        return this.myCurrentIndent;
    }

    protected void error(String message) {
        this.myBuilder.error(message);
    }

    @Nullable
    public IElementType getTokenType() {
        return this.myBuilder.getTokenType();
    }

    protected static boolean tokenIn(@Nullable IElementType elementType, IElementType ... tokens) {
        for (IElementType token : tokens) {
            if (elementType != token) continue;
            return true;
        }
        return false;
    }

    protected boolean currentTokenIn(IElementType ... tokens) {
        return AbstractIndentParser.tokenIn(this.getTokenType(), tokens);
    }

    protected boolean currentTokenIn(@NotNull TokenSet tokenSet) {
        if (tokenSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenSet", "com/intellij/indentation/AbstractIndentParser", "currentTokenIn"));
        }
        return tokenSet.contains(this.getTokenType());
    }

    protected static boolean tokenIn(@Nullable IElementType elementType, @NotNull TokenSet tokenSet) {
        if (tokenSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenSet", "com/intellij/indentation/AbstractIndentParser", "tokenIn"));
        }
        return tokenSet.contains(elementType);
    }

    @NotNull
    protected String getTokenText() {
        String result = this.myBuilder.getTokenText();
        if (result == null) {
            result = "";
        }
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/indentation/AbstractIndentParser", "getTokenText"));
        }
        return string;
    }

    protected boolean expect(@NotNull IElementType elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/indentation/AbstractIndentParser", "expect"));
        }
        return this.expect(elementType, "Expected: " + elementType);
    }

    protected boolean expect(@NotNull IElementType elementType, String expectedMessage) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/indentation/AbstractIndentParser", "expect"));
        }
        if (this.getTokenType() == elementType) {
            this.advance();
            return true;
        }
        this.error(expectedMessage);
        return false;
    }

    @Nullable
    public IElementType lookAhead(int step) {
        return this.myBuilder.lookAhead(step);
    }

    @Nullable
    public IElementType rawLookup(int step) {
        return this.myBuilder.rawLookup(step);
    }

    public boolean isNewLine() {
        return this.myNewLine;
    }

    public void advance() {
        String tokenText = this.myBuilder.getTokenText();
        int tokenLength = tokenText == null ? 0 : tokenText.length();
        int whiteSpaceStart = this.getCurrentOffset() + tokenLength;
        this.myBuilder.advanceLexer();
        int whiteSpaceEnd = this.getCurrentOffset();
        String whiteSpaceText = this.myBuilder.getOriginalText().subSequence(whiteSpaceStart, whiteSpaceEnd).toString();
        int i2 = whiteSpaceText.lastIndexOf(10);
        if (i2 >= 0) {
            this.myCurrentIndent = whiteSpaceText.length() - i2 - 1;
            this.myNewLine = true;
        } else {
            this.myNewLine = false;
        }
    }

    public void recalculateCurrentIndent() {
        int i2 = 0;
        int firstIndentOffset = this.myBuilder.getCurrentOffset();
        while (this.myBuilder.rawLookup(i2) != null && this.myBuilder.rawLookup(i2) != this.getEolElementType()) {
            firstIndentOffset = this.myBuilder.rawTokenTypeStart(i2);
            --i2;
        }
        int lastIndentOffset = firstIndentOffset;
        ++i2;
        while (this.myBuilder.rawLookup(i2) == this.getIndentElementType()) {
            lastIndentOffset = this.myBuilder.rawTokenTypeStart(++i2);
        }
        this.myCurrentIndent = lastIndentOffset - firstIndentOffset;
    }

    protected void advanceUntil(TokenSet tokenSet) {
        while (this.getTokenType() != null && !this.isNewLine() && !tokenSet.contains(this.getTokenType())) {
            this.advance();
        }
    }

    protected void advanceUntilEol() {
        this.advanceUntil(TokenSet.EMPTY);
    }

    protected void errorUntil(TokenSet tokenSet, String message) {
        PsiBuilder.Marker errorMarker = this.mark();
        this.advanceUntil(tokenSet);
        errorMarker.error(message);
    }

    protected void errorUntilEol(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/indentation/AbstractIndentParser", "errorUntilEol"));
        }
        PsiBuilder.Marker errorMarker = this.mark();
        this.advanceUntilEol();
        errorMarker.error(message);
    }

    protected void errorUntilEof(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/indentation/AbstractIndentParser", "errorUntilEof"));
        }
        PsiBuilder.Marker errorMarker = this.mark();
        while (!this.eof()) {
            this.advance();
        }
        errorMarker.error(message);
    }

    protected void expectEolOrEof() {
        if (!this.isNewLine() && !this.eof()) {
            this.errorUntilEol("End of line expected");
        }
    }

    protected abstract IElementType getIndentElementType();

    protected abstract IElementType getEolElementType();
}

