/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.xml.XmlStructureViewTreeModel;
import com.intellij.ide.structureView.xml.XmlStructureViewBuilderProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlStructureViewBuilderFactory
implements PsiStructureViewFactory {
    @Override
    @Nullable
    public StructureViewBuilder getStructureViewBuilder(final PsiFile psiFile) {
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        StructureViewBuilder builder = XmlStructureViewBuilderFactory.getStructureViewBuilderForExtensions(psiFile);
        if (builder != null) {
            return builder;
        }
        for (XmlStructureViewBuilderProvider xmlStructureViewBuilderProvider : XmlStructureViewBuilderFactory.getStructureViewBuilderProviders()) {
            StructureViewBuilder structureViewBuilder = xmlStructureViewBuilderProvider.createStructureViewBuilder((XmlFile)psiFile);
            if (structureViewBuilder == null) continue;
            return structureViewBuilder;
        }
        return new TreeBasedStructureViewBuilder(){

            @Override
            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                XmlStructureViewTreeModel xmlStructureViewTreeModel = new XmlStructureViewTreeModel((XmlFile)psiFile, editor);
                if (xmlStructureViewTreeModel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlStructureViewBuilderFactory$1", "createStructureViewModel"));
                }
                return xmlStructureViewTreeModel;
            }
        };
    }

    private static XmlStructureViewBuilderProvider[] getStructureViewBuilderProviders() {
        return (XmlStructureViewBuilderProvider[])Extensions.getExtensions("com.intellij.xmlStructureViewBuilderProvider");
    }

    @Nullable
    private static StructureViewBuilder getStructureViewBuilderForExtensions(PsiFile psiFile) {
        for (Language language : XMLLanguage.INSTANCE.getLanguageExtensionsForFile(psiFile)) {
            StructureViewBuilder builder;
            PsiStructureViewFactory factory = (PsiStructureViewFactory)LanguageStructureViewBuilder.INSTANCE.forLanguage(language);
            if (factory == null || (builder = factory.getStructureViewBuilder(psiFile)) == null) continue;
            return builder;
        }
        return null;
    }
}

