/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.impl.LineIteratorImpl;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.util.BitUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.MergingCharSequence;
import gnu.trove.TByteArrayList;
import gnu.trove.TIntArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class LineSet {
    private static final int MODIFIED_MASK = 4;
    private static final int SEPARATOR_MASK = 3;
    private final int[] myStarts;
    private final byte[] myFlags;
    private final int myLength;
    private static boolean doTest = false;

    private LineSet(int[] starts, byte[] flags, int length) {
        this.myStarts = starts;
        this.myFlags = flags;
        this.myLength = length;
    }

    public static LineSet createLineSet(CharSequence text) {
        return LineSet.createLineSet(text, false);
    }

    @NotNull
    private static LineSet createLineSet(@NotNull CharSequence text, boolean markModified) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/LineSet", "createLineSet"));
        }
        TIntArrayList starts = new TIntArrayList();
        TByteArrayList flags = new TByteArrayList();
        LineTokenizer lineTokenizer = new LineTokenizer(text);
        while (!lineTokenizer.atEnd()) {
            starts.add(lineTokenizer.getOffset());
            flags.add((byte)(lineTokenizer.getLineSeparatorLength() | (markModified ? 4 : 0)));
            lineTokenizer.advance();
        }
        LineSet lineSet = new LineSet(starts.toNativeArray(), flags.toNativeArray(), text.length());
        if (lineSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/LineSet", "createLineSet"));
        }
        return lineSet;
    }

    @NotNull
    LineSet update(@NotNull CharSequence prevText, int start, int end, @NotNull CharSequence replacement, boolean wholeTextReplaced) {
        LineSet result;
        if (prevText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prevText", "com/intellij/openapi/editor/impl/LineSet", "update"));
        }
        if (replacement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacement", "com/intellij/openapi/editor/impl/LineSet", "update"));
        }
        if (this.myLength == 0) {
            LineSet lineSet = LineSet.createLineSet(replacement, !wholeTextReplaced);
            if (lineSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/LineSet", "update"));
            }
            return lineSet;
        }
        LineSet lineSet = result = this.isSingleLineChange(prevText, start, end, replacement) ? this.updateInsideOneLine(this.findLineIndex(start), replacement.length() - (end - start)) : this.genericUpdate(prevText, start, end, replacement);
        if (doTest) {
            MergingCharSequence newText = new MergingCharSequence(new MergingCharSequence(prevText.subSequence(0, start), replacement), prevText.subSequence(end, prevText.length()));
            result.checkEquals(LineSet.createLineSet(newText));
        }
        LineSet lineSet2 = wholeTextReplaced ? result.clearModificationFlags() : result;
        if (lineSet2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/LineSet", "update"));
        }
        return lineSet2;
    }

    private boolean isSingleLineChange(@NotNull CharSequence prevText, int start, int end, @NotNull CharSequence replacement) {
        if (prevText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prevText", "com/intellij/openapi/editor/impl/LineSet", "isSingleLineChange"));
        }
        if (replacement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacement", "com/intellij/openapi/editor/impl/LineSet", "isSingleLineChange"));
        }
        if (start == 0 && end == this.myLength && replacement.length() == 0) {
            return false;
        }
        int startLine = this.findLineIndex(start);
        return startLine == this.findLineIndex(end) && !CharArrayUtil.containLineBreaks(replacement) && !this.isLastEmptyLine(startLine);
    }

    @NotNull
    private LineSet updateInsideOneLine(int line, int lengthDelta) {
        int[] starts = (int[])this.myStarts.clone();
        int i2 = line + 1;
        while (i2 < starts.length) {
            int n = i2++;
            starts[n] = starts[n] + lengthDelta;
        }
        byte[] flags = (byte[])this.myFlags.clone();
        int n = line;
        flags[n] = (byte)(flags[n] | 4);
        LineSet lineSet = new LineSet(starts, flags, this.myLength + lengthDelta);
        if (lineSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/LineSet", "updateInsideOneLine"));
        }
        return lineSet;
    }

    private LineSet genericUpdate(CharSequence prevText, int _start, int _end, CharSequence replacement) {
        int startOffset = _start;
        if (replacement.length() > 0 && replacement.charAt(0) == '\n' && startOffset > 0 && prevText.charAt(startOffset - 1) == '\r') {
            --startOffset;
        }
        int startLine = this.findLineIndex(startOffset);
        startOffset = this.getLineStart(startLine);
        int endOffset = _end;
        if (replacement.length() > 0 && replacement.charAt(replacement.length() - 1) == '\r' && endOffset < prevText.length() && prevText.charAt(endOffset) == '\n') {
            ++endOffset;
        }
        int endLine = this.findLineIndex(endOffset);
        endOffset = this.getLineEnd(endLine);
        if (!this.isLastEmptyLine(endLine)) {
            ++endLine;
        }
        replacement = new MergingCharSequence(new MergingCharSequence(prevText.subSequence(startOffset, _start), replacement), prevText.subSequence(_end, endOffset));
        LineSet patch = LineSet.createLineSet(replacement, true);
        return this.applyPatch(startOffset, endOffset, startLine, endLine, patch);
    }

    private void checkEquals(@NotNull LineSet fresh) {
        if (fresh == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fresh", "com/intellij/openapi/editor/impl/LineSet", "checkEquals"));
        }
        if (this.getLineCount() != fresh.getLineCount()) {
            throw new AssertionError();
        }
        for (int i2 = 0; i2 < this.getLineCount(); ++i2) {
            boolean sep;
            boolean start = this.getLineStart(i2) != fresh.getLineStart(i2);
            boolean end = this.getLineEnd(i2) != fresh.getLineEnd(i2);
            boolean bl = sep = this.getSeparatorLength(i2) != fresh.getSeparatorLength(i2);
            if (start || end || sep) {
                throw new AssertionError();
            }
        }
    }

    @NotNull
    private LineSet applyPatch(int startOffset, int endOffset, int startLine, int endLine, @NotNull LineSet patch) {
        int i2;
        if (patch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patch", "com/intellij/openapi/editor/impl/LineSet", "applyPatch"));
        }
        int lineShift = patch.myStarts.length - (endLine - startLine);
        int lengthShift = patch.myLength - (endOffset - startOffset);
        int newLineCount = this.myStarts.length + lineShift;
        int[] starts = new int[newLineCount];
        byte[] flags = new byte[newLineCount];
        for (i2 = 0; i2 < startLine; ++i2) {
            starts[i2] = this.myStarts[i2];
            flags[i2] = this.myFlags[i2];
        }
        for (i2 = 0; i2 < patch.myStarts.length; ++i2) {
            starts[startLine + i2] = patch.myStarts[i2] + startOffset;
            flags[startLine + i2] = patch.myFlags[i2];
        }
        for (i2 = endLine; i2 < this.myStarts.length; ++i2) {
            starts[lineShift + i2] = this.myStarts[i2] + lengthShift;
            flags[lineShift + i2] = this.myFlags[i2];
        }
        LineSet lineSet = new LineSet(starts, flags, this.myLength + lengthShift);
        if (lineSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/LineSet", "applyPatch"));
        }
        return lineSet;
    }

    public int findLineIndex(int offset) {
        if (offset < 0 || offset > this.myLength) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset + ". Should be in range: [0, " + this.myLength + "]");
        }
        if (this.myLength == 0) {
            return 0;
        }
        if (offset == this.myLength) {
            return this.getLineCount() - 1;
        }
        int bsResult = Arrays.binarySearch(this.myStarts, offset);
        return bsResult >= 0 ? bsResult : -bsResult - 2;
    }

    @NotNull
    public LineIterator createIterator() {
        LineIteratorImpl lineIteratorImpl = new LineIteratorImpl(this);
        if (lineIteratorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/LineSet", "createIterator"));
        }
        return lineIteratorImpl;
    }

    public final int getLineStart(int index) {
        this.checkLineIndex(index);
        return this.isLastEmptyLine(index) ? this.myLength : this.myStarts[index];
    }

    private boolean isLastEmptyLine(int index) {
        return index == this.myFlags.length && index > 0 && (this.myFlags[index - 1] & 3) > 0;
    }

    public final int getLineEnd(int index) {
        this.checkLineIndex(index);
        return index >= this.myStarts.length - 1 ? this.myLength : this.myStarts[index + 1];
    }

    private void checkLineIndex(int index) {
        if (index < 0 || index >= this.getLineCount()) {
            throw new IndexOutOfBoundsException("Wrong line: " + index + ". Available lines count: " + this.getLineCount());
        }
    }

    final boolean isModified(int index) {
        this.checkLineIndex(index);
        return !this.isLastEmptyLine(index) && BitUtil.isSet((int)this.myFlags[index], 4);
    }

    @NotNull
    final LineSet setModified(int index) {
        if (this.isLastEmptyLine(index) || this.isModified(index)) {
            LineSet lineSet = this;
            if (lineSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/LineSet", "setModified"));
            }
            return lineSet;
        }
        byte[] flags = (byte[])this.myFlags.clone();
        int n = index;
        flags[n] = (byte)(flags[n] | 4);
        LineSet lineSet = new LineSet(this.myStarts, flags, this.myLength);
        if (lineSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/LineSet", "setModified"));
        }
        return lineSet;
    }

    @NotNull
    LineSet clearModificationFlags(int startLine, int endLine) {
        if (startLine > endLine) {
            throw new IllegalArgumentException("endLine < startLine: " + endLine + " < " + startLine + "; lineCount: " + this.getLineCount());
        }
        this.checkLineIndex(startLine);
        this.checkLineIndex(endLine - 1);
        if (this.isLastEmptyLine(endLine - 1)) {
            --endLine;
        }
        if (startLine >= endLine) {
            LineSet lineSet = this;
            if (lineSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/LineSet", "clearModificationFlags"));
            }
            return lineSet;
        }
        byte[] flags = (byte[])this.myFlags.clone();
        int i2 = startLine;
        while (i2 < endLine) {
            int n = i2++;
            flags[n] = (byte)(flags[n] & 0xFFFFFFFB);
        }
        LineSet lineSet = new LineSet(this.myStarts, flags, this.myLength);
        if (lineSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/LineSet", "clearModificationFlags"));
        }
        return lineSet;
    }

    @NotNull
    LineSet clearModificationFlags() {
        byte[] flags = (byte[])this.myFlags.clone();
        int i2 = 0;
        while (i2 < flags.length) {
            int n = i2++;
            flags[n] = (byte)(flags[n] & 0xFFFFFFFB);
        }
        LineSet lineSet = new LineSet(this.myStarts, flags, this.myLength);
        if (lineSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/LineSet", "clearModificationFlags"));
        }
        return lineSet;
    }

    final int getSeparatorLength(int index) {
        this.checkLineIndex(index);
        return index < this.myFlags.length ? this.myFlags[index] & 3 : 0;
    }

    final int getLineCount() {
        return this.myStarts.length + (this.isLastEmptyLine(this.myStarts.length) ? 1 : 0);
    }

    public static void setTestingMode(boolean testMode) {
        doTest = testMode;
    }
}

