/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GlobalSearchScopeUtil {
    @NotNull
    public static GlobalSearchScope toGlobalSearchScope(final @NotNull SearchScope scope, final @NotNull Project project) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/GlobalSearchScopeUtil", "toGlobalSearchScope"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScopeUtil", "toGlobalSearchScope"));
        }
        if (scope instanceof GlobalSearchScope) {
            GlobalSearchScope globalSearchScope = (GlobalSearchScope)scope;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopeUtil", "toGlobalSearchScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = ApplicationManager.getApplication().runReadAction(new Computable<GlobalSearchScope>(){

            @Override
            public GlobalSearchScope compute() {
                return GlobalSearchScope.filesScope(project, GlobalSearchScopeUtil.getLocalScopeFiles((LocalSearchScope)scope));
            }
        });
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopeUtil", "toGlobalSearchScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static Set<VirtualFile> getLocalScopeFiles(final @NotNull LocalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/GlobalSearchScopeUtil", "getLocalScopeFiles"));
        }
        Set<VirtualFile> set = ApplicationManager.getApplication().runReadAction(new Computable<Set<VirtualFile>>(){

            @Override
            public Set<VirtualFile> compute() {
                LinkedHashSet<VirtualFile> files = new LinkedHashSet<VirtualFile>();
                for (PsiElement element : scope.getScope()) {
                    PsiFile file = element.getContainingFile();
                    if (file == null) continue;
                    ContainerUtil.addIfNotNull(files, file.getVirtualFile());
                    ContainerUtil.addIfNotNull(files, file.getNavigationElement().getContainingFile().getVirtualFile());
                }
                return files;
            }
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopeUtil", "getLocalScopeFiles"));
        }
        return set;
    }
}

