/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassLevelDeclarationStatement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiTemplateStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowUtils {
    private ControlFlowUtils() {
    }

    public static boolean isElseIf(PsiIfStatement ifStatement) {
        PsiElement parent = ifStatement.getParent();
        if (!(parent instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement parentStatement = (PsiIfStatement)parent;
        PsiStatement elseBranch = parentStatement.getElseBranch();
        return ifStatement.equals(elseBranch);
    }

    public static boolean statementMayCompleteNormally(@Nullable PsiStatement statement) {
        if (statement == null) {
            return true;
        }
        if (statement instanceof PsiBreakStatement || statement instanceof PsiContinueStatement || statement instanceof PsiReturnStatement || statement instanceof PsiThrowStatement) {
            return false;
        }
        if (statement instanceof PsiExpressionListStatement || statement instanceof PsiEmptyStatement || statement instanceof PsiAssertStatement || statement instanceof PsiDeclarationStatement || statement instanceof PsiSwitchLabelStatement || statement instanceof PsiForeachStatement) {
            return true;
        }
        if (statement instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return true;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return true;
            }
            String methodName = method.getName();
            if (!methodName.equals("exit")) {
                return true;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return true;
            }
            String className = aClass.getQualifiedName();
            return !"java.lang.System".equals(className);
        }
        if (statement instanceof PsiForStatement) {
            return ControlFlowUtils.forStatementMayCompleteNormally((PsiForStatement)statement);
        }
        if (statement instanceof PsiWhileStatement) {
            return ControlFlowUtils.whileStatementMayCompleteNormally((PsiWhileStatement)statement);
        }
        if (statement instanceof PsiDoWhileStatement) {
            return ControlFlowUtils.doWhileStatementMayCompleteNormally((PsiDoWhileStatement)statement);
        }
        if (statement instanceof PsiSynchronizedStatement) {
            PsiCodeBlock body = ((PsiSynchronizedStatement)statement).getBody();
            return ControlFlowUtils.codeBlockMayCompleteNormally(body);
        }
        if (statement instanceof PsiBlockStatement) {
            PsiCodeBlock codeBlock = ((PsiBlockStatement)statement).getCodeBlock();
            return ControlFlowUtils.codeBlockMayCompleteNormally(codeBlock);
        }
        if (statement instanceof PsiLabeledStatement) {
            return ControlFlowUtils.labeledStatementMayCompleteNormally((PsiLabeledStatement)statement);
        }
        if (statement instanceof PsiIfStatement) {
            return ControlFlowUtils.ifStatementMayCompleteNormally((PsiIfStatement)statement);
        }
        if (statement instanceof PsiTryStatement) {
            return ControlFlowUtils.tryStatementMayCompleteNormally((PsiTryStatement)statement);
        }
        if (statement instanceof PsiSwitchStatement) {
            return ControlFlowUtils.switchStatementMayCompleteNormally((PsiSwitchStatement)statement);
        }
        if (statement instanceof PsiTemplateStatement || statement instanceof PsiClassLevelDeclarationStatement) {
            return true;
        }
        assert (false) : "unknown statement type: " + statement.getClass();
        return true;
    }

    private static boolean doWhileStatementMayCompleteNormally(@NotNull PsiDoWhileStatement loopStatement) {
        if (loopStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopStatement", "com/siyeh/ig/psiutils/ControlFlowUtils", "doWhileStatementMayCompleteNormally"));
        }
        PsiExpression condition = loopStatement.getCondition();
        Object value = ExpressionUtils.computeConstantExpression(condition);
        PsiStatement body = loopStatement.getBody();
        return ControlFlowUtils.statementMayCompleteNormally(body) && value != Boolean.TRUE || ControlFlowUtils.statementIsBreakTarget(loopStatement) || ControlFlowUtils.statementContainsContinueToAncestor(loopStatement);
    }

    private static boolean whileStatementMayCompleteNormally(@NotNull PsiWhileStatement loopStatement) {
        if (loopStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopStatement", "com/siyeh/ig/psiutils/ControlFlowUtils", "whileStatementMayCompleteNormally"));
        }
        PsiExpression condition = loopStatement.getCondition();
        Object value = ExpressionUtils.computeConstantExpression(condition);
        return value != Boolean.TRUE || ControlFlowUtils.statementIsBreakTarget(loopStatement) || ControlFlowUtils.statementContainsContinueToAncestor(loopStatement);
    }

    private static boolean forStatementMayCompleteNormally(@NotNull PsiForStatement loopStatement) {
        if (loopStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopStatement", "com/siyeh/ig/psiutils/ControlFlowUtils", "forStatementMayCompleteNormally"));
        }
        if (ControlFlowUtils.statementIsBreakTarget(loopStatement)) {
            return true;
        }
        if (ControlFlowUtils.statementContainsContinueToAncestor(loopStatement)) {
            return true;
        }
        PsiExpression condition = loopStatement.getCondition();
        if (condition == null) {
            return false;
        }
        Object value = ExpressionUtils.computeConstantExpression(condition);
        return Boolean.TRUE != value;
    }

    private static boolean switchStatementMayCompleteNormally(@NotNull PsiSwitchStatement switchStatement) {
        if (switchStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "switchStatement", "com/siyeh/ig/psiutils/ControlFlowUtils", "switchStatementMayCompleteNormally"));
        }
        if (ControlFlowUtils.statementIsBreakTarget(switchStatement)) {
            return true;
        }
        PsiCodeBlock body = switchStatement.getBody();
        if (body == null) {
            return true;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length == 0) {
            return true;
        }
        int numCases = 0;
        boolean hasDefaultCase = false;
        for (PsiStatement statement : statements) {
            PsiBreakStatement breakStatement;
            if (statement instanceof PsiSwitchLabelStatement) {
                ++numCases;
                PsiSwitchLabelStatement switchLabelStatement = (PsiSwitchLabelStatement)statement;
                if (switchLabelStatement.isDefaultCase()) {
                    hasDefaultCase = true;
                }
            }
            if (!(statement instanceof PsiBreakStatement) || (breakStatement = (PsiBreakStatement)statement).getLabelIdentifier() != null) continue;
            return true;
        }
        boolean isEnum = ControlFlowUtils.isEnumSwitch(switchStatement);
        if (!hasDefaultCase && !isEnum) {
            return true;
        }
        if (!hasDefaultCase) {
            PsiExpression expression = switchStatement.getExpression();
            if (expression == null) {
                return true;
            }
            PsiClassType type = (PsiClassType)expression.getType();
            if (type == null) {
                return true;
            }
            PsiClass aClass = type.resolve();
            if (aClass == null) {
                return true;
            }
            PsiField[] fields = aClass.getFields();
            int numEnums = 0;
            for (PsiField field : fields) {
                PsiType fieldType = field.getType();
                if (!fieldType.equals(type)) continue;
                ++numEnums;
            }
            if (numEnums != numCases) {
                return true;
            }
        }
        return ControlFlowUtils.statementMayCompleteNormally(statements[statements.length - 1]);
    }

    private static boolean isEnumSwitch(PsiSwitchStatement statement) {
        PsiExpression expression = statement.getExpression();
        if (expression == null) {
            return false;
        }
        PsiType type = expression.getType();
        if (type == null) {
            return false;
        }
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClass aClass = ((PsiClassType)type).resolve();
        return aClass != null && aClass.isEnum();
    }

    private static boolean tryStatementMayCompleteNormally(@NotNull PsiTryStatement tryStatement) {
        PsiCodeBlock[] catchBlocks;
        if (tryStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tryStatement", "com/siyeh/ig/psiutils/ControlFlowUtils", "tryStatementMayCompleteNormally"));
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null && !ControlFlowUtils.codeBlockMayCompleteNormally(finallyBlock)) {
            return false;
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (ControlFlowUtils.codeBlockMayCompleteNormally(tryBlock)) {
            return true;
        }
        for (PsiCodeBlock catchBlock : catchBlocks = tryStatement.getCatchBlocks()) {
            if (!ControlFlowUtils.codeBlockMayCompleteNormally(catchBlock)) continue;
            return true;
        }
        return false;
    }

    private static boolean ifStatementMayCompleteNormally(@NotNull PsiIfStatement ifStatement) {
        PsiStatement branch2;
        PsiStatement branch1;
        if (ifStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/siyeh/ig/psiutils/ControlFlowUtils", "ifStatementMayCompleteNormally"));
        }
        PsiExpression condition = ifStatement.getCondition();
        Object value = ExpressionUtils.computeConstantExpression(condition);
        PsiStatement thenBranch = ifStatement.getThenBranch();
        if (value == Boolean.TRUE) {
            return ControlFlowUtils.statementMayCompleteNormally(thenBranch);
        }
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (value == Boolean.FALSE) {
            return ControlFlowUtils.statementMayCompleteNormally(elseBranch);
        }
        if ((thenBranch == null ? 0 : thenBranch.getTextLength()) < (elseBranch == null ? 0 : elseBranch.getTextLength())) {
            branch1 = thenBranch;
            branch2 = elseBranch;
        } else {
            branch2 = thenBranch;
            branch1 = elseBranch;
        }
        return ControlFlowUtils.statementMayCompleteNormally(branch1) || ControlFlowUtils.statementMayCompleteNormally(branch2);
    }

    private static boolean labeledStatementMayCompleteNormally(@NotNull PsiLabeledStatement labeledStatement) {
        if (labeledStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labeledStatement", "com/siyeh/ig/psiutils/ControlFlowUtils", "labeledStatementMayCompleteNormally"));
        }
        PsiStatement statement = labeledStatement.getStatement();
        if (statement == null) {
            return false;
        }
        return ControlFlowUtils.statementMayCompleteNormally(statement) || ControlFlowUtils.statementIsBreakTarget(statement);
    }

    public static boolean codeBlockMayCompleteNormally(@Nullable PsiCodeBlock block) {
        PsiStatement[] statements;
        if (block == null) {
            return true;
        }
        for (PsiStatement statement : statements = block.getStatements()) {
            if (ControlFlowUtils.statementMayCompleteNormally(statement)) continue;
            return false;
        }
        return true;
    }

    private static boolean statementIsBreakTarget(@NotNull PsiStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils", "statementIsBreakTarget"));
        }
        BreakFinder breakFinder = new BreakFinder(statement);
        statement.accept(breakFinder);
        return breakFinder.breakFound();
    }

    private static boolean statementContainsContinueToAncestor(@NotNull PsiStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils", "statementContainsContinueToAncestor"));
        }
        PsiElement parent = statement.getParent();
        while (parent instanceof PsiLabeledStatement) {
            statement = (PsiStatement)parent;
            parent = parent.getParent();
        }
        ContinueToAncestorFinder continueToAncestorFinder = new ContinueToAncestorFinder(statement);
        statement.accept(continueToAncestorFinder);
        return continueToAncestorFinder.continueToAncestorFound();
    }

    public static boolean containsReturn(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/ControlFlowUtils", "containsReturn"));
        }
        ReturnFinder returnFinder = new ReturnFinder();
        element.accept(returnFinder);
        return returnFinder.returnFound();
    }

    public static boolean statementIsContinueTarget(@NotNull PsiStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils", "statementIsContinueTarget"));
        }
        ContinueFinder continueFinder = new ContinueFinder(statement);
        statement.accept(continueFinder);
        return continueFinder.continueFound();
    }

    public static boolean containsSystemExit(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/ControlFlowUtils", "containsSystemExit"));
        }
        SystemExitFinder systemExitFinder = new SystemExitFinder();
        element.accept(systemExitFinder);
        return systemExitFinder.exitFound();
    }

    public static boolean elementContainsCallToMethod(PsiElement context, String containingClassName, PsiType returnType, String methodName, PsiType ... parameterTypes) {
        MethodCallFinder methodCallFinder = new MethodCallFinder(containingClassName, returnType, methodName, parameterTypes);
        context.accept(methodCallFinder);
        return methodCallFinder.containsCallToMethod();
    }

    public static boolean isInLoop(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/ControlFlowUtils", "isInLoop"));
        }
        PsiLoopStatement loopStatement = PsiTreeUtil.getParentOfType(element, PsiLoopStatement.class, true, PsiClass.class);
        if (loopStatement == null) {
            return false;
        }
        PsiStatement body = loopStatement.getBody();
        return body != null && PsiTreeUtil.isAncestor(body, element, true);
    }

    public static boolean isInFinallyBlock(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/ControlFlowUtils", "isInFinallyBlock"));
        }
        PsiElement currentElement = element;
        PsiTryStatement tryStatement;
        while ((tryStatement = PsiTreeUtil.getParentOfType(currentElement, PsiTryStatement.class, true, PsiClass.class, PsiLambdaExpression.class)) != null) {
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (finallyBlock != null && PsiTreeUtil.isAncestor(finallyBlock, currentElement, true)) {
                PsiMethod elementMethod = PsiTreeUtil.getParentOfType(currentElement, PsiMethod.class);
                PsiMethod finallyMethod = PsiTreeUtil.getParentOfType((PsiElement)finallyBlock, PsiMethod.class);
                return elementMethod != null && elementMethod.equals(finallyMethod);
            }
            currentElement = tryStatement;
        }
        return false;
    }

    public static boolean isInCatchBlock(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/ControlFlowUtils", "isInCatchBlock"));
        }
        return PsiTreeUtil.getParentOfType(element, PsiCatchSection.class, true, PsiClass.class) != null;
    }

    public static boolean isInExitStatement(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/ControlFlowUtils", "isInExitStatement"));
        }
        return ControlFlowUtils.isInReturnStatementArgument(expression) || ControlFlowUtils.isInThrowStatementArgument(expression);
    }

    private static boolean isInReturnStatementArgument(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/ControlFlowUtils", "isInReturnStatementArgument"));
        }
        return PsiTreeUtil.getParentOfType((PsiElement)expression, PsiReturnStatement.class) != null;
    }

    public static boolean isInThrowStatementArgument(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/ControlFlowUtils", "isInThrowStatementArgument"));
        }
        return PsiTreeUtil.getParentOfType((PsiElement)expression, PsiThrowStatement.class) != null;
    }

    @Nullable
    public static PsiStatement stripBraces(@Nullable PsiStatement statement) {
        if (statement instanceof PsiBlockStatement) {
            PsiBlockStatement block = (PsiBlockStatement)statement;
            PsiStatement onlyStatement = ControlFlowUtils.getOnlyStatementInBlock(block.getCodeBlock());
            return onlyStatement != null ? onlyStatement : block;
        }
        return statement;
    }

    public static boolean statementCompletesWithStatement(@NotNull PsiStatement containingStatement, @NotNull PsiStatement statement) {
        if (containingStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingStatement", "com/siyeh/ig/psiutils/ControlFlowUtils", "statementCompletesWithStatement"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils", "statementCompletesWithStatement"));
        }
        PsiElement statementToCheck = statement;
        while (!statementToCheck.equals(containingStatement)) {
            PsiElement container = ControlFlowUtils.getContainingStatementOrBlock(statementToCheck);
            if (container == null) {
                return false;
            }
            if (container instanceof PsiCodeBlock && !ControlFlowUtils.statementIsLastInBlock((PsiCodeBlock)container, statementToCheck)) {
                return false;
            }
            if (container instanceof PsiLoopStatement) {
                return false;
            }
            statementToCheck = container;
        }
        return true;
    }

    public static boolean blockCompletesWithStatement(@NotNull PsiCodeBlock body, @NotNull PsiStatement statement) {
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/siyeh/ig/psiutils/ControlFlowUtils", "blockCompletesWithStatement"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils", "blockCompletesWithStatement"));
        }
        PsiElement statementToCheck = statement;
        while (statementToCheck != null) {
            PsiElement container = ControlFlowUtils.getContainingStatementOrBlock(statementToCheck);
            if (container == null) {
                return false;
            }
            if (container instanceof PsiLoopStatement) {
                return false;
            }
            if (container instanceof PsiCodeBlock) {
                if (!ControlFlowUtils.statementIsLastInBlock((PsiCodeBlock)container, statementToCheck)) {
                    return false;
                }
                if (container.equals(body)) {
                    return true;
                }
                statementToCheck = PsiTreeUtil.getParentOfType(container, PsiStatement.class);
                continue;
            }
            statementToCheck = container;
        }
        return false;
    }

    @Nullable
    private static PsiElement getContainingStatementOrBlock(@NotNull PsiElement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils", "getContainingStatementOrBlock"));
        }
        return PsiTreeUtil.getParentOfType(statement, PsiStatement.class, PsiCodeBlock.class);
    }

    private static boolean statementIsLastInBlock(@NotNull PsiCodeBlock block, @NotNull PsiStatement statement) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/siyeh/ig/psiutils/ControlFlowUtils", "statementIsLastInBlock"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils", "statementIsLastInBlock"));
        }
        for (PsiElement child = block.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (!(child instanceof PsiStatement)) continue;
            PsiStatement childStatement = (PsiStatement)child;
            if (statement.equals(childStatement)) {
                return true;
            }
            if (statement instanceof PsiEmptyStatement) continue;
            return false;
        }
        return false;
    }

    @Nullable
    public static PsiStatement getFirstStatementInBlock(@Nullable PsiCodeBlock codeBlock) {
        return PsiTreeUtil.getChildOfType(codeBlock, PsiStatement.class);
    }

    @Nullable
    public static PsiStatement getLastStatementInBlock(@Nullable PsiCodeBlock codeBlock) {
        return ControlFlowUtils.getLastChildOfType(codeBlock, PsiStatement.class);
    }

    private static <T extends PsiElement> T getLastChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/psiutils/ControlFlowUtils", "getLastChildOfType"));
        }
        if (element == null) {
            return null;
        }
        for (PsiElement child = element.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (!aClass.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    @Nullable
    public static PsiStatement getOnlyStatementInBlock(@Nullable PsiCodeBlock codeBlock) {
        return ControlFlowUtils.getOnlyChildOfType(codeBlock, PsiStatement.class);
    }

    static <T extends PsiElement> T getOnlyChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/psiutils/ControlFlowUtils", "getOnlyChildOfType"));
        }
        if (element == null) {
            return null;
        }
        PsiElement result = null;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass.isInstance(child)) continue;
            if (result == null) {
                result = child;
                continue;
            }
            return null;
        }
        return (T)result;
    }

    public static boolean hasStatementCount(@Nullable PsiCodeBlock codeBlock, int count) {
        return ControlFlowUtils.hasChildrenOfTypeCount(codeBlock, count, PsiStatement.class);
    }

    static <T extends PsiElement> boolean hasChildrenOfTypeCount(@Nullable PsiElement element, int count, @NotNull Class<T> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/psiutils/ControlFlowUtils", "hasChildrenOfTypeCount"));
        }
        if (element == null) {
            return false;
        }
        int i2 = 0;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass.isInstance(child) || ++i2 <= count) continue;
            return false;
        }
        return i2 == count;
    }

    public static boolean isEmptyCodeBlock(PsiCodeBlock codeBlock) {
        return ControlFlowUtils.hasStatementCount(codeBlock, 0);
    }

    public static boolean methodAlwaysThrowsException(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/psiutils/ControlFlowUtils", "methodAlwaysThrowsException"));
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return true;
        }
        return !ControlFlowUtils.containsReturn(body) && !ControlFlowUtils.codeBlockMayCompleteNormally(body);
    }

    public static boolean lambdaExpressionAlwaysThrowsException(PsiLambdaExpression expression) {
        PsiElement body = expression.getBody();
        if (body instanceof PsiExpression) {
            return false;
        }
        if (!(body instanceof PsiCodeBlock)) {
            return true;
        }
        PsiCodeBlock codeBlock = (PsiCodeBlock)body;
        return !ControlFlowUtils.containsReturn(codeBlock) && !ControlFlowUtils.codeBlockMayCompleteNormally(codeBlock);
    }

    public static boolean statementContainsNakedBreak(PsiStatement statement) {
        if (statement == null) {
            return false;
        }
        NakedBreakFinder breakFinder = new NakedBreakFinder();
        statement.accept(breakFinder);
        return breakFinder.breakFound();
    }

    @Contract(value="null, _ -> false")
    public static boolean statementBreaksLoop(PsiStatement statement, PsiLoopStatement loop) {
        if (statement instanceof PsiBreakStatement) {
            return ((PsiBreakStatement)statement).findExitedStatement() == loop;
        }
        if (statement instanceof PsiReturnStatement) {
            PsiElement nextElement;
            PsiExpression returnValue = ((PsiReturnStatement)statement).getReturnValue();
            PsiElement cur = loop;
            PsiElement parent = cur.getParent();
            while (true) {
                if (parent instanceof PsiLabeledStatement) {
                    cur = parent;
                } else if (parent instanceof PsiCodeBlock) {
                    PsiCodeBlock block = (PsiCodeBlock)parent;
                    PsiStatement[] statements = block.getStatements();
                    if (!(block.getParent() instanceof PsiBlockStatement) || statements.length <= 0 || statements[statements.length - 1] != cur) break;
                    cur = block.getParent();
                } else {
                    if (!(parent instanceof PsiIfStatement) || cur != ((PsiIfStatement)parent).getThenBranch() && cur != ((PsiIfStatement)parent).getElseBranch()) break;
                    cur = parent;
                }
                parent = cur.getParent();
            }
            if ((nextElement = PsiTreeUtil.skipSiblingsForward(cur, PsiComment.class, PsiWhiteSpace.class)) instanceof PsiReturnStatement) {
                return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(returnValue, ((PsiReturnStatement)nextElement).getReturnValue());
            }
            if (nextElement == null && returnValue == null && cur.getParent() instanceof PsiMethod) {
                return true;
            }
        }
        return false;
    }

    private static class ContinueToAncestorFinder
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiStatement statement;
        private boolean found;

        private ContinueToAncestorFinder(PsiStatement statement) {
            this.statement = statement;
        }

        @Override
        public void visitElement(PsiElement element) {
            if (this.found) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitContinueStatement(PsiContinueStatement continueStatement) {
            if (this.found) {
                return;
            }
            super.visitContinueStatement(continueStatement);
            PsiIdentifier labelIdentifier = continueStatement.getLabelIdentifier();
            if (labelIdentifier == null) {
                return;
            }
            PsiStatement continuedStatement = continueStatement.findContinuedStatement();
            if (continuedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor(continuedStatement, this.statement, true)) {
                this.found = true;
            }
        }

        private boolean continueToAncestorFound() {
            return this.found;
        }
    }

    private static class MethodCallFinder
    extends JavaRecursiveElementWalkingVisitor {
        private final String containingClassName;
        private final PsiType returnType;
        private final String methodName;
        private final PsiType[] parameterTypeNames;
        private boolean containsCallToMethod;

        private MethodCallFinder(String containingClassName, PsiType returnType, String methodName, PsiType ... parameterTypeNames) {
            this.containingClassName = containingClassName;
            this.returnType = returnType;
            this.methodName = methodName;
            this.parameterTypeNames = parameterTypeNames;
        }

        @Override
        public void visitElement(PsiElement element) {
            if (this.containsCallToMethod) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            if (this.containsCallToMethod) {
                return;
            }
            super.visitMethodCallExpression(expression);
            if (!MethodCallUtils.isCallToMethod(expression, this.containingClassName, this.returnType, this.methodName, this.parameterTypeNames)) {
                return;
            }
            this.containsCallToMethod = true;
        }

        private boolean containsCallToMethod() {
            return this.containsCallToMethod;
        }
    }

    private static class ContinueFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;
        private final PsiStatement m_target;

        private ContinueFinder(@NotNull PsiStatement target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/siyeh/ig/psiutils/ControlFlowUtils$ContinueFinder", "<init>"));
            }
            this.m_target = target;
        }

        private boolean continueFound() {
            return this.m_found;
        }

        @Override
        public void visitContinueStatement(@NotNull PsiContinueStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils$ContinueFinder", "visitContinueStatement"));
            }
            if (this.m_found) {
                return;
            }
            super.visitContinueStatement(statement);
            PsiStatement continuedStatement = statement.findContinuedStatement();
            if (continuedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor(continuedStatement, this.m_target, false)) {
                this.m_found = true;
            }
        }

        @Override
        public void visitIfStatement(PsiIfStatement statement) {
            PsiStatement elseBranch;
            PsiStatement thenBranch;
            if (this.m_found) {
                return;
            }
            PsiExpression condition = statement.getCondition();
            Object value = ExpressionUtils.computeConstantExpression(condition);
            if (Boolean.FALSE != value && (thenBranch = statement.getThenBranch()) != null) {
                thenBranch.accept(this);
            }
            if (Boolean.TRUE != value && (elseBranch = statement.getElseBranch()) != null) {
                elseBranch.accept(this);
            }
        }
    }

    private static class BreakFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;
        private final PsiStatement m_target;

        private BreakFinder(@NotNull PsiStatement target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/siyeh/ig/psiutils/ControlFlowUtils$BreakFinder", "<init>"));
            }
            this.m_target = target;
        }

        private boolean breakFound() {
            return this.m_found;
        }

        @Override
        public void visitBreakStatement(@NotNull PsiBreakStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils$BreakFinder", "visitBreakStatement"));
            }
            if (this.m_found) {
                return;
            }
            super.visitBreakStatement(statement);
            PsiStatement exitedStatement = statement.findExitedStatement();
            if (exitedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor(exitedStatement, this.m_target, false)) {
                this.m_found = true;
            }
        }

        @Override
        public void visitIfStatement(PsiIfStatement statement) {
            PsiStatement elseBranch;
            PsiStatement thenBranch;
            if (this.m_found) {
                return;
            }
            PsiExpression condition = statement.getCondition();
            Object value = ExpressionUtils.computeConstantExpression(condition);
            if (Boolean.FALSE != value && (thenBranch = statement.getThenBranch()) != null) {
                thenBranch.accept(this);
            }
            if (Boolean.TRUE != value && (elseBranch = statement.getElseBranch()) != null) {
                elseBranch.accept(this);
            }
        }
    }

    private static class ReturnFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;

        private ReturnFinder() {
        }

        private boolean returnFound() {
            return this.m_found;
        }

        @Override
        public void visitClass(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/siyeh/ig/psiutils/ControlFlowUtils$ReturnFinder", "visitClass"));
            }
        }

        @Override
        public void visitLambdaExpression(PsiLambdaExpression expression) {
        }

        @Override
        public void visitReturnStatement(@NotNull PsiReturnStatement returnStatement) {
            if (returnStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnStatement", "com/siyeh/ig/psiutils/ControlFlowUtils$ReturnFinder", "visitReturnStatement"));
            }
            if (this.m_found) {
                return;
            }
            super.visitReturnStatement(returnStatement);
            this.m_found = true;
        }
    }

    private static class SystemExitFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;

        private SystemExitFinder() {
        }

        private boolean exitFound() {
            return this.m_found;
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/psiutils/ControlFlowUtils$SystemExitFinder", "visitClass"));
            }
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/ControlFlowUtils$SystemExitFinder", "visitMethodCallExpression"));
            }
            if (this.m_found) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            String methodName = method.getName();
            if (!methodName.equals("exit")) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String className = aClass.getQualifiedName();
            if (!"java.lang.System".equals(className) && !"java.lang.Runtime".equals(className)) {
                return;
            }
            this.m_found = true;
        }
    }

    private static class NakedBreakFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;

        private NakedBreakFinder() {
        }

        private boolean breakFound() {
            return this.m_found;
        }

        @Override
        public void visitElement(PsiElement element) {
            if (this.m_found) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
        }

        @Override
        public void visitBreakStatement(PsiBreakStatement statement) {
            if (statement.getLabelIdentifier() != null) {
                return;
            }
            this.m_found = true;
        }

        @Override
        public void visitDoWhileStatement(PsiDoWhileStatement statement) {
        }

        @Override
        public void visitForStatement(PsiForStatement statement) {
        }

        @Override
        public void visitForeachStatement(PsiForeachStatement statement) {
        }

        @Override
        public void visitWhileStatement(PsiWhileStatement statement) {
        }

        @Override
        public void visitSwitchStatement(PsiSwitchStatement statement) {
        }
    }
}

