/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18api;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.List;
import java.util.Optional;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java8CollectionRemoveIfInspection
extends BaseJavaBatchLocalInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/java18api/Java8CollectionRemoveIfInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher(holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/Java8CollectionRemoveIfInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            void handleIteratorLoop(PsiLoopStatement statement, PsiJavaToken endToken, IteratorDeclaration declaration) {
                if (endToken == null) {
                    return;
                }
                PsiStatement body = statement.getBody();
                if (!(body instanceof PsiBlockStatement)) {
                    return;
                }
                PsiStatement[] statements = ((PsiBlockStatement)body).getCodeBlock().getStatements();
                if (statements.length == 2 && statements[1] instanceof PsiIfStatement) {
                    PsiVariable element = declaration.getNextElementVariable(statements[0]);
                    if (element == null) {
                        return;
                    }
                    PsiIfStatement ifStatement = (PsiIfStatement)statements[1];
                    if (this.checkAndExtractCondition(declaration, ifStatement) == null) {
                        return;
                    }
                    this.registerProblem(statement, endToken);
                } else if (statements.length == 1 && statements[0] instanceof PsiIfStatement) {
                    PsiIfStatement ifStatement = (PsiIfStatement)statements[0];
                    PsiExpression condition = this.checkAndExtractCondition(declaration, ifStatement);
                    if (condition == null) {
                        return;
                    }
                    PsiElement ref = declaration.findOnlyIteratorRef(condition);
                    if (ref != null && declaration.isIteratorMethodCall(ref.getParent().getParent(), "next") && this.isAlwaysExecuted(condition, ref)) {
                        this.registerProblem(statement, endToken);
                    }
                }
            }

            private boolean isAlwaysExecuted(PsiExpression condition, PsiElement ref) {
                while (ref != condition) {
                    PsiPolyadicExpression polyadicExpression;
                    IElementType type;
                    PsiElement parent = ref.getParent();
                    if (parent instanceof PsiPolyadicExpression && ((type = (polyadicExpression = (PsiPolyadicExpression)parent).getOperationTokenType()).equals(JavaTokenType.ANDAND) || type.equals(JavaTokenType.OROR)) && polyadicExpression.getOperands()[0] != ref) {
                        return false;
                    }
                    if (parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() != ref) {
                        return false;
                    }
                    ref = parent;
                }
                return true;
            }

            private void registerProblem(PsiLoopStatement statement, PsiJavaToken endToken) {
                holder.registerProblem((PsiElement)statement, new TextRange(0, endToken.getTextOffset() - statement.getTextOffset() + 1), QuickFixBundle.message("java.8.collection.removeif.inspection.description", new Object[0]), new ReplaceWithRemoveIfQuickFix());
            }

            @Nullable
            private PsiExpression checkAndExtractCondition(IteratorDeclaration declaration, PsiIfStatement ifStatement) {
                PsiExpression condition = ifStatement.getCondition();
                if (condition == null || ifStatement.getElseBranch() != null) {
                    return null;
                }
                PsiStatement thenStatement = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
                if (!(thenStatement instanceof PsiExpressionStatement)) {
                    return null;
                }
                if (!declaration.isIteratorMethodCall(((PsiExpressionStatement)thenStatement).getExpression(), "remove")) {
                    return null;
                }
                if (!LambdaGenerationUtil.canBeUncheckedLambda(condition)) {
                    return null;
                }
                return condition;
            }

            @Override
            public void visitForStatement(PsiForStatement statement) {
                super.visitForStatement(statement);
                PsiStatement initialization = statement.getInitialization();
                IteratorDeclaration declaration = IteratorDeclaration.extract(initialization);
                if (declaration == null) {
                    return;
                }
                if (statement.getUpdate() != null) {
                    return;
                }
                if (!declaration.isHasNextCall(statement.getCondition())) {
                    return;
                }
                this.handleIteratorLoop(statement, statement.getRParenth(), declaration);
            }

            @Override
            public void visitWhileStatement(PsiWhileStatement statement) {
                super.visitWhileStatement(statement);
                PsiElement previous = PsiTreeUtil.skipSiblingsBackward(statement, PsiComment.class, PsiWhiteSpace.class);
                if (!(previous instanceof PsiDeclarationStatement)) {
                    return;
                }
                IteratorDeclaration declaration = IteratorDeclaration.extract((PsiStatement)previous);
                if (declaration == null || !declaration.isHasNextCall(statement.getCondition())) {
                    return;
                }
                if (!ReferencesSearch.search(declaration.myIterator, declaration.myIterator.getUseScope()).forEach(ref -> PsiTreeUtil.isAncestor(statement, ref.getElement(), true))) {
                    return;
                }
                this.handleIteratorLoop(statement, statement.getRParenth(), declaration);
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/Java8CollectionRemoveIfInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static class IteratorDeclaration {
        @NotNull
        private final PsiLocalVariable myIterator;
        @Nullable
        private final PsiExpression myCollection;

        private IteratorDeclaration(@NotNull PsiLocalVariable iterator, @Nullable PsiExpression collection) {
            if (iterator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/codeInspection/java18api/Java8CollectionRemoveIfInspection$IteratorDeclaration", "<init>"));
            }
            this.myIterator = iterator;
            this.myCollection = collection;
        }

        public boolean isHasNextCall(PsiExpression condition) {
            return this.isIteratorMethodCall(condition, "hasNext");
        }

        @Nullable
        public PsiElement findOnlyIteratorRef(PsiExpression parent) {
            PsiCodeBlock block;
            PsiElement element = PsiUtil.getVariableCodeBlock(this.myIterator, null);
            PsiCodeBlock psiCodeBlock = block = element instanceof PsiCodeBlock ? (PsiCodeBlock)element : PsiTreeUtil.getParentOfType(element, PsiCodeBlock.class);
            if (block == null) {
                return null;
            }
            return ((Optional)((StreamEx)StreamEx.of((Object[])DefUseUtil.getRefs(block, this.myIterator, this.myIterator.getInitializer())).filter(e -> PsiTreeUtil.isAncestor(parent, e, false))).collect(MoreCollectors.onlyOne())).orElse(null);
        }

        boolean isIteratorMethodCall(PsiElement candidate, String method) {
            if (!(candidate instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)candidate;
            if (call.getArgumentList().getExpressions().length != 0) {
                return false;
            }
            PsiReferenceExpression expression = call.getMethodExpression();
            if (!method.equals(expression.getReferenceName())) {
                return false;
            }
            PsiExpression qualifier = expression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return false;
            }
            return ((PsiReferenceExpression)qualifier).isReferenceTo(this.myIterator);
        }

        public PsiVariable getNextElementVariable(PsiStatement statement) {
            if (!(statement instanceof PsiDeclarationStatement)) {
                return null;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)statement;
            if (declaration.getDeclaredElements().length != 1) {
                return null;
            }
            PsiElement element = declaration.getDeclaredElements()[0];
            if (!(element instanceof PsiLocalVariable)) {
                return null;
            }
            PsiLocalVariable var = (PsiLocalVariable)element;
            if (!this.isIteratorMethodCall(var.getInitializer(), "next")) {
                return null;
            }
            return var;
        }

        @Contract(value="null -> null")
        static IteratorDeclaration extract(PsiStatement statement) {
            if (!(statement instanceof PsiDeclarationStatement)) {
                return null;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)statement;
            if (declaration.getDeclaredElements().length != 1) {
                return null;
            }
            PsiElement element = declaration.getDeclaredElements()[0];
            if (!(element instanceof PsiLocalVariable)) {
                return null;
            }
            PsiLocalVariable variable = (PsiLocalVariable)element;
            PsiExpression initializer = variable.getInitializer();
            if (!(initializer instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)initializer;
            if (call.getArgumentList().getExpressions().length != 0) {
                return null;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            if (!"iterator".equals(methodExpression.getReferenceName())) {
                return null;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null || !InheritanceUtil.isInheritor(method.getContainingClass(), "java.util.Collection")) {
                return null;
            }
            PsiType type = variable.getType();
            if (!(type instanceof PsiClassType) || !((PsiClassType)type).rawType().equalsToText("java.util.Iterator")) {
                return null;
            }
            return new IteratorDeclaration(variable, methodExpression.getQualifierExpression());
        }
    }

    private static class ReplaceWithRemoveIfQuickFix
    implements LocalQuickFix {
        private ReplaceWithRemoveIfQuickFix() {
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message("java.8.collection.removeif.inspection.fix.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/Java8CollectionRemoveIfInspection$ReplaceWithRemoveIfQuickFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            IteratorDeclaration declaration;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/java18api/Java8CollectionRemoveIfInspection$ReplaceWithRemoveIfQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/java18api/Java8CollectionRemoveIfInspection$ReplaceWithRemoveIfQuickFix", "applyFix"));
            }
            PsiElement element = descriptor.getStartElement();
            if (!(element instanceof PsiLoopStatement)) {
                return;
            }
            PsiLoopStatement loop = (PsiLoopStatement)element;
            PsiElement previous = null;
            if (loop instanceof PsiForStatement) {
                declaration = IteratorDeclaration.extract(((PsiForStatement)loop).getInitialization());
            } else if (loop instanceof PsiWhileStatement) {
                previous = PsiTreeUtil.skipSiblingsBackward(loop, PsiComment.class, PsiWhiteSpace.class);
                if (!(previous instanceof PsiDeclarationStatement)) {
                    return;
                }
                declaration = IteratorDeclaration.extract((PsiStatement)previous);
            } else {
                return;
            }
            if (declaration == null) {
                return;
            }
            PsiStatement body = loop.getBody();
            if (!(body instanceof PsiBlockStatement)) {
                return;
            }
            PsiStatement[] statements = ((PsiBlockStatement)body).getCodeBlock().getStatements();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
            String replacement = null;
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                return;
            }
            if (statements.length == 2 && statements[1] instanceof PsiIfStatement) {
                PsiVariable variable = declaration.getNextElementVariable(statements[0]);
                if (variable == null) {
                    return;
                }
                PsiExpression condition = ((PsiIfStatement)statements[1]).getCondition();
                if (condition == null) {
                    return;
                }
                replacement = (declaration.myCollection == null ? "" : declaration.myCollection.getText() + ".") + "removeIf(" + LambdaUtil.createLambda(variable, condition) + ");";
            } else if (statements.length == 1 && statements[0] instanceof PsiIfStatement) {
                PsiExpression condition = ((PsiIfStatement)statements[0]).getCondition();
                if (condition == null) {
                    return;
                }
                PsiElement ref = declaration.findOnlyIteratorRef(condition);
                if (ref != null) {
                    PsiElement call = ref.getParent().getParent();
                    if (!declaration.isIteratorMethodCall(call, "next")) {
                        return;
                    }
                    PsiType type = ((PsiExpression)call).getType();
                    JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance(project);
                    SuggestedNameInfo info = javaCodeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, type);
                    if (info.names.length == 0) {
                        info = javaCodeStyleManager.suggestVariableName(VariableKind.PARAMETER, "value", null, type);
                    }
                    String paramName = javaCodeStyleManager.suggestUniqueVariableName((SuggestedNameInfo)info, (PsiElement)condition, (boolean)true).names[0];
                    call.replace(factory.createIdentifier(paramName));
                    replacement = (declaration.myCollection == null ? "" : declaration.myCollection.getText() + ".") + "removeIf(" + paramName + "->" + condition.getText() + ");";
                }
            }
            if (replacement == null) {
                return;
            }
            List<PsiComment> comments = ContainerUtil.map(PsiTreeUtil.findChildrenOfType(loop, PsiComment.class), comment -> (PsiComment)comment.copy());
            PsiElement result = loop.replace(factory.createStatementFromText(replacement, loop));
            if (previous != null) {
                previous.delete();
            }
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
            CodeStyleManager.getInstance(project).reformat(result);
            comments.forEach(comment -> result.getParent().addBefore((PsiElement)comment, result));
        }
    }
}

