/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeMapper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TypeCorrector
extends PsiTypeMapper {
    private final Map<PsiClassType, PsiClassType> myResultMap = ContainerUtil.newIdentityHashMap();
    private final GlobalSearchScope myResolveScope;

    TypeCorrector(GlobalSearchScope resolveScope) {
        this.myResolveScope = resolveScope;
    }

    @Override
    public PsiType visitType(PsiType type) {
        if (LambdaUtil.notInferredType(type)) {
            return type;
        }
        return super.visitType(type);
    }

    @Nullable
    public <T extends PsiType> T correctType(@NotNull T type) {
        PsiClass mappedClass;
        PsiClassType.ClassResolveResult classResolveResult;
        PsiClass psiClass;
        PsiClassType classType;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/TypeCorrector", "correctType"));
        }
        if (type instanceof PsiClassType && (classType = (PsiClassType)type).getParameterCount() == 0 && (psiClass = (classResolveResult = classType.resolveGenerics()).getElement()) != null && classResolveResult.getSubstitutor() == PsiSubstitutor.EMPTY && ((mappedClass = PsiSuperMethodUtil.correctClassByScope(psiClass, this.myResolveScope)) == null || mappedClass == psiClass)) {
            return (T)classType;
        }
        return (T)type.accept(this);
    }

    @Override
    public PsiType visitClassType(PsiClassType classType) {
        PsiClassType alreadyComputed = this.myResultMap.get(classType);
        if (alreadyComputed != null) {
            return alreadyComputed;
        }
        PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
        PsiClass psiClass = classResolveResult.getElement();
        PsiSubstitutor substitutor = classResolveResult.getSubstitutor();
        if (psiClass == null) {
            return classType;
        }
        PsiUtilCore.ensureValid(psiClass);
        PsiClass mappedClass = PsiSuperMethodUtil.correctClassByScope(psiClass, this.myResolveScope);
        if (mappedClass == null) {
            return classType;
        }
        PsiCorrectedClassType mappedType = new PsiCorrectedClassType(classType.getLanguageLevel(), classType, new CorrectedResolveResult(psiClass, mappedClass, substitutor, classResolveResult));
        this.myResultMap.put(classType, mappedType);
        return mappedType;
    }

    @NotNull
    private PsiSubstitutor mapSubstitutor(PsiClass originalClass, PsiClass mappedClass, PsiSubstitutor substitutor) {
        PsiClass originalContaining;
        PsiTypeParameter[] originalTypeParameters;
        PsiTypeParameter[] typeParameters = mappedClass.getTypeParameters();
        if (typeParameters.length != (originalTypeParameters = originalClass.getTypeParameters()).length) {
            if (originalTypeParameters.length == 0) {
                PsiSubstitutor psiSubstitutor = JavaPsiFacade.getElementFactory(mappedClass.getProject()).createRawSubstitutor(mappedClass);
                if (psiSubstitutor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/TypeCorrector", "mapSubstitutor"));
                }
                return psiSubstitutor;
            }
            PsiSubstitutor psiSubstitutor = substitutor;
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/TypeCorrector", "mapSubstitutor"));
            }
            return psiSubstitutor;
        }
        Map<PsiTypeParameter, PsiType> substitutionMap = substitutor.getSubstitutionMap();
        PsiSubstitutor mappedSubstitutor = PsiSubstitutor.EMPTY;
        for (int i2 = 0; i2 < originalTypeParameters.length; ++i2) {
            if (!substitutionMap.containsKey(originalTypeParameters[i2])) continue;
            PsiType originalSubstitute = substitutor.substitute(originalTypeParameters[i2]);
            if (originalSubstitute != null) {
                PsiType substitute = this.mapType(originalSubstitute);
                if (substitute == null) {
                    PsiSubstitutor psiSubstitutor = substitutor;
                    if (psiSubstitutor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/TypeCorrector", "mapSubstitutor"));
                    }
                    return psiSubstitutor;
                }
                mappedSubstitutor = mappedSubstitutor.put(typeParameters[i2], substitute);
                continue;
            }
            mappedSubstitutor = mappedSubstitutor.put(typeParameters[i2], null);
        }
        if (mappedClass.hasModifierProperty("static")) {
            PsiSubstitutor psiSubstitutor = mappedSubstitutor;
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/TypeCorrector", "mapSubstitutor"));
            }
            return psiSubstitutor;
        }
        PsiClass mappedContaining = mappedClass.getContainingClass();
        if (mappedContaining != null != ((originalContaining = originalClass.getContainingClass()) != null)) {
            PsiSubstitutor psiSubstitutor = substitutor;
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/TypeCorrector", "mapSubstitutor"));
            }
            return psiSubstitutor;
        }
        if (mappedContaining != null) {
            PsiSubstitutor psiSubstitutor = mappedSubstitutor.putAll(this.mapSubstitutor(originalContaining, mappedContaining, substitutor));
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/TypeCorrector", "mapSubstitutor"));
            }
            return psiSubstitutor;
        }
        PsiSubstitutor psiSubstitutor = mappedSubstitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/TypeCorrector", "mapSubstitutor"));
        }
        return psiSubstitutor;
    }

    private class CorrectedResolveResult
    implements PsiClassType.ClassResolveResult {
        private final PsiClass myPsiClass;
        private final PsiClass myMappedClass;
        private final PsiSubstitutor mySubstitutor;
        private final PsiClassType.ClassResolveResult myClassResolveResult;
        private volatile PsiSubstitutor myLazySubstitutor;

        public CorrectedResolveResult(PsiClass psiClass, PsiClass mappedClass, PsiSubstitutor substitutor, PsiClassType.ClassResolveResult classResolveResult) {
            this.myPsiClass = psiClass;
            this.myMappedClass = mappedClass;
            this.mySubstitutor = substitutor;
            this.myClassResolveResult = classResolveResult;
        }

        @Override
        @NotNull
        public PsiSubstitutor getSubstitutor() {
            PsiSubstitutor result = this.myLazySubstitutor;
            if (result == null) {
                this.myLazySubstitutor = result = TypeCorrector.this.mapSubstitutor(this.myPsiClass, this.myMappedClass, this.mySubstitutor);
            }
            PsiSubstitutor psiSubstitutor = result;
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/TypeCorrector$CorrectedResolveResult", "getSubstitutor"));
            }
            return psiSubstitutor;
        }

        @Override
        public PsiClass getElement() {
            return this.myMappedClass;
        }

        @Override
        public boolean isPackagePrefixPackageReference() {
            return this.myClassResolveResult.isPackagePrefixPackageReference();
        }

        @Override
        public boolean isAccessible() {
            return this.myClassResolveResult.isAccessible();
        }

        @Override
        public boolean isStaticsScopeCorrect() {
            return this.myClassResolveResult.isStaticsScopeCorrect();
        }

        @Override
        public PsiElement getCurrentFileResolveScope() {
            return this.myClassResolveResult.getCurrentFileResolveScope();
        }

        @Override
        public boolean isValidResult() {
            return this.myClassResolveResult.isValidResult();
        }
    }

    public class PsiCorrectedClassType
    extends PsiClassType.Stub {
        private final PsiClassType myDelegate;
        private final CorrectedResolveResult myResolveResult;

        private PsiCorrectedClassType(LanguageLevel languageLevel, PsiClassType delegate, CorrectedResolveResult resolveResult) {
            this(languageLevel, delegate, resolveResult, delegate.getAnnotationProvider());
        }

        private PsiCorrectedClassType(LanguageLevel languageLevel, PsiClassType delegate, CorrectedResolveResult resolveResult, TypeAnnotationProvider delegateAnnotationProvider) {
            super(languageLevel, delegateAnnotationProvider);
            this.myDelegate = delegate;
            this.myResolveResult = resolveResult;
        }

        @Override
        @NotNull
        public PsiClass resolve() {
            PsiClass psiClass = this.myResolveResult.myMappedClass;
            if (psiClass == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/TypeCorrector$PsiCorrectedClassType", "resolve"));
            }
            return psiClass;
        }

        @Override
        public String getClassName() {
            return this.myDelegate.getClassName();
        }

        @Override
        @NotNull
        public PsiType[] getParameters() {
            PsiType[] psiTypeArray = ContainerUtil.map2Array(this.myDelegate.getParameters(), PsiType.class, new Function<PsiType, PsiType>(){

                @Override
                public PsiType fun(PsiType type) {
                    if (type == null) {
                        LOG.error(PsiCorrectedClassType.this.myDelegate + " of " + PsiCorrectedClassType.this.myDelegate.getClass() + "; substitutor=" + PsiCorrectedClassType.this.myDelegate.resolveGenerics().getSubstitutor());
                        return null;
                    }
                    return TypeCorrector.this.mapType(type);
                }
            });
            if (psiTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/TypeCorrector$PsiCorrectedClassType", "getParameters"));
            }
            return psiTypeArray;
        }

        @Override
        public int getParameterCount() {
            return this.myDelegate.getParameters().length;
        }

        @Override
        @NotNull
        public PsiClassType.ClassResolveResult resolveGenerics() {
            CorrectedResolveResult correctedResolveResult = this.myResolveResult;
            if (correctedResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/TypeCorrector$PsiCorrectedClassType", "resolveGenerics"));
            }
            return correctedResolveResult;
        }

        @Override
        @NotNull
        public PsiClassType rawType() {
            PsiClass psiClass = this.resolve();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(psiClass.getProject());
            PsiClassType psiClassType = factory.createType(psiClass, factory.createRawSubstitutor(psiClass));
            if (psiClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/TypeCorrector$PsiCorrectedClassType", "rawType"));
            }
            return psiClassType;
        }

        @Override
        @NotNull
        public GlobalSearchScope getResolveScope() {
            GlobalSearchScope globalSearchScope = TypeCorrector.this.myResolveScope;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/TypeCorrector$PsiCorrectedClassType", "getResolveScope"));
            }
            return globalSearchScope;
        }

        @Override
        @NotNull
        public LanguageLevel getLanguageLevel() {
            LanguageLevel languageLevel = this.myLanguageLevel;
            if (languageLevel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/TypeCorrector$PsiCorrectedClassType", "getLanguageLevel"));
            }
            return languageLevel;
        }

        @Override
        @NotNull
        public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
            if (languageLevel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/impl/TypeCorrector$PsiCorrectedClassType", "setLanguageLevel"));
            }
            PsiCorrectedClassType psiCorrectedClassType = new PsiCorrectedClassType(languageLevel, this.myDelegate, this.myResolveResult);
            if (psiCorrectedClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/TypeCorrector$PsiCorrectedClassType", "setLanguageLevel"));
            }
            return psiCorrectedClassType;
        }

        @Override
        @NotNull
        public String getPresentableText(boolean annotated) {
            String string = this.myDelegate.getPresentableText(annotated);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/TypeCorrector$PsiCorrectedClassType", "getPresentableText"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getCanonicalText(boolean annotated) {
            String string = this.myDelegate.getCanonicalText(annotated);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/TypeCorrector$PsiCorrectedClassType", "getCanonicalText"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getInternalCanonicalText() {
            String string = this.myDelegate.getInternalCanonicalText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/TypeCorrector$PsiCorrectedClassType", "getInternalCanonicalText"));
            }
            return string;
        }

        @Override
        public boolean isValid() {
            return this.myDelegate.isValid() && this.resolve().isValid();
        }

        @Override
        public boolean equalsToText(@NotNull @NonNls String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/TypeCorrector$PsiCorrectedClassType", "equalsToText"));
            }
            return this.myDelegate.equalsToText(text);
        }
    }
}

