/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncResult<T>
extends ActionCallback {
    private static final Logger LOG = Logger.getInstance(AsyncResult.class);
    protected T myResult;

    public AsyncResult() {
    }

    AsyncResult(int countToDone, @Nullable T result) {
        super(countToDone);
        this.myResult = result;
    }

    @NotNull
    public AsyncResult<T> setDone(T result) {
        this.myResult = result;
        this.setDone();
        AsyncResult asyncResult = this;
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/AsyncResult", "setDone"));
        }
        return asyncResult;
    }

    @NotNull
    public AsyncResult<T> setRejected(T result) {
        this.myResult = result;
        this.setRejected();
        AsyncResult asyncResult = this;
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/AsyncResult", "setRejected"));
        }
        return asyncResult;
    }

    @NotNull
    public <DependentResult> AsyncResult<DependentResult> subResult(@NotNull Function<T, DependentResult> doneHandler) {
        if (doneHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doneHandler", "com/intellij/openapi/util/AsyncResult", "subResult"));
        }
        AsyncResult<T> asyncResult = this.subResult(new AsyncResult<T>(), doneHandler);
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/AsyncResult", "subResult"));
        }
        return asyncResult;
    }

    @NotNull
    public <SubResult, SubAsyncResult extends AsyncResult<SubResult>> SubAsyncResult subResult(@NotNull SubAsyncResult subResult, @NotNull Function<T, SubResult> doneHandler) {
        if (subResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subResult", "com/intellij/openapi/util/AsyncResult", "subResult"));
        }
        if (doneHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doneHandler", "com/intellij/openapi/util/AsyncResult", "subResult"));
        }
        this.doWhenDone(new SubResultDoneCallback<T, SubResult, SubAsyncResult>(subResult, doneHandler)).notifyWhenRejected(subResult);
        SubAsyncResult SubAsyncResult = subResult;
        if (SubAsyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/AsyncResult", "subResult"));
        }
        return SubAsyncResult;
    }

    @Deprecated
    @NotNull
    public AsyncResult<T> doWhenDone(final @NotNull Handler<T> handler) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/openapi/util/AsyncResult", "doWhenDone"));
        }
        this.doWhenDone(new Runnable(){

            @Override
            public void run() {
                handler.run(AsyncResult.this.myResult);
            }
        });
        AsyncResult asyncResult = this;
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/AsyncResult", "doWhenDone"));
        }
        return asyncResult;
    }

    @NotNull
    public AsyncResult<T> doWhenDone(final @NotNull Consumer<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/openapi/util/AsyncResult", "doWhenDone"));
        }
        this.doWhenDone(new Runnable(){

            @Override
            public void run() {
                consumer.consume(AsyncResult.this.myResult);
            }
        });
        AsyncResult asyncResult = this;
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/AsyncResult", "doWhenDone"));
        }
        return asyncResult;
    }

    @NotNull
    public AsyncResult<T> doWhenRejected(final @NotNull PairConsumer<T, String> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/openapi/util/AsyncResult", "doWhenRejected"));
        }
        this.doWhenRejected(new Runnable(){

            @Override
            public void run() {
                consumer.consume(AsyncResult.this.myResult, AsyncResult.this.myError);
            }
        });
        AsyncResult asyncResult = this;
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/AsyncResult", "doWhenRejected"));
        }
        return asyncResult;
    }

    @Override
    @NotNull
    public final AsyncResult<T> notify(@NotNull ActionCallback child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/openapi/util/AsyncResult", "notify"));
        }
        super.notify(child);
        AsyncResult asyncResult = this;
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/AsyncResult", "notify"));
        }
        return asyncResult;
    }

    public T getResult() {
        return this.myResult;
    }

    public T getResultSync() {
        return this.getResultSync(-1L);
    }

    @Nullable
    public T getResultSync(long msTimeout) {
        this.waitFor(msTimeout);
        return this.myResult;
    }

    @NotNull
    public final ActionCallback doWhenProcessed(final @NotNull Consumer<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/openapi/util/AsyncResult", "doWhenProcessed"));
        }
        this.doWhenDone(consumer);
        this.doWhenRejected(new PairConsumer<T, String>(){

            @Override
            public void consume(T result, String error) {
                consumer.consume(result);
            }
        });
        AsyncResult asyncResult = this;
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/AsyncResult", "doWhenProcessed"));
        }
        return asyncResult;
    }

    @Deprecated
    @NotNull
    public static <R> AsyncResult<R> rejected() {
        Rejected rejected2 = new Rejected();
        if (rejected2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/AsyncResult", "rejected"));
        }
        return rejected2;
    }

    @Deprecated
    @NotNull
    public static <R> AsyncResult<R> rejected(@NotNull String errorMessage) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/util/AsyncResult", "rejected"));
        }
        AsyncResult result = new AsyncResult();
        result.reject(errorMessage);
        AsyncResult asyncResult = result;
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/AsyncResult", "rejected"));
        }
        return asyncResult;
    }

    @NotNull
    public static <R> AsyncResult<R> done(@Nullable R result) {
        AsyncResult asyncResult = new AsyncResult<R>().setDone(result);
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/AsyncResult", "done"));
        }
        return asyncResult;
    }

    private static class SubResultDoneCallback<Result, SubResult, AsyncSubResult extends AsyncResult<SubResult>>
    implements Consumer<Result> {
        private final AsyncSubResult subResult;
        private final Function<Result, SubResult> doneHandler;

        public SubResultDoneCallback(AsyncSubResult subResult, Function<Result, SubResult> doneHandler) {
            this.subResult = subResult;
            this.doneHandler = doneHandler;
        }

        @Override
        public void consume(Result result) {
            SubResult v;
            try {
                v = this.doneHandler.fun(result);
            }
            catch (Throwable e) {
                ((ActionCallback)this.subResult).reject(e.getMessage());
                LOG.error(e);
                return;
            }
            ((AsyncResult)this.subResult).setDone(v);
        }
    }

    @Deprecated
    public static class Rejected<T>
    extends AsyncResult<T> {
        public Rejected() {
            this.setRejected();
        }

        public Rejected(T value) {
            this.setRejected(value);
        }
    }

    @Deprecated
    public static class Done<T>
    extends AsyncResult<T> {
        public Done(T value) {
            this.setDone(value);
        }
    }

    @Deprecated
    public static interface Handler<T> {
        public void run(T var1);
    }
}

