/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.util.ProperTextRange;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public abstract class VisibleHighlightingPassFactory {
    @NotNull
    public static ProperTextRange calculateVisibleRange(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/VisibleHighlightingPassFactory", "calculateVisibleRange"));
        }
        Rectangle rect = editor.getScrollingModel().getVisibleArea();
        LogicalPosition startPosition = editor.xyToLogicalPosition(new Point(rect.x, rect.y));
        int visibleStart = editor.logicalPositionToOffset(startPosition);
        LogicalPosition endPosition = editor.xyToLogicalPosition(new Point(rect.x + rect.width, rect.y + rect.height));
        int visibleEnd = editor.logicalPositionToOffset(new LogicalPosition(endPosition.line + 1, 0));
        ProperTextRange properTextRange = new ProperTextRange(visibleStart, Math.max(visibleEnd, visibleStart));
        if (properTextRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/VisibleHighlightingPassFactory", "calculateVisibleRange"));
        }
        return properTextRange;
    }
}

