/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class QualifyThisOrSuperArgumentFix
implements IntentionAction {
    protected static final Logger LOG = Logger.getInstance("#" + QualifyThisOrSuperArgumentFix.class.getName());
    protected final PsiExpression myExpression;
    protected final PsiClass myPsiClass;
    private String myText;

    public QualifyThisOrSuperArgumentFix(@NotNull PsiExpression expression, @NotNull PsiClass psiClass) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/quickfix/QualifyThisOrSuperArgumentFix", "<init>"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/daemon/impl/quickfix/QualifyThisOrSuperArgumentFix", "<init>"));
        }
        this.myExpression = expression;
        this.myPsiClass = psiClass;
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/QualifyThisOrSuperArgumentFix", "getText"));
        }
        return string;
    }

    protected abstract String getQualifierText();

    protected abstract PsiExpression getQualifier(PsiManager var1);

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/QualifyThisOrSuperArgumentFix", "isAvailable"));
        }
        if (!this.myExpression.isValid()) {
            return false;
        }
        if (!this.myPsiClass.isValid()) {
            return false;
        }
        this.myText = "Qualify " + this.getQualifierText() + " expression with '" + this.myPsiClass.getQualifiedName() + "'";
        return true;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = "Qualify " + this.getQualifierText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/QualifyThisOrSuperArgumentFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/QualifyThisOrSuperArgumentFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        this.myExpression.replace(this.getQualifier(PsiManager.getInstance(project)));
    }
}

