/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18api;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.java18api.ReplaceConditionalMapPutFix;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java8CollectionsApiInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(Java8CollectionsApiInspection.class);
    public boolean myReportContainsCondition;
    public boolean mySuggestPutIfAbsentForComplexExpression;

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel(this);
        panel.addCheckbox("Report when 'containsKey' is used in condition (may change semantics)", "myReportContainsCondition");
        panel.addCheckbox("Suggest to replace with 'putIfAbsent' if value is complex expression (may change semantics)", "mySuggestPutIfAbsentForComplexExpression");
        return panel;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/java18api/Java8CollectionsApiInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher(holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/Java8CollectionsApiInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitConditionalExpression(PsiConditionalExpression expression) {
                ConditionInfo conditionInfo = Java8CollectionsApiInspection.this.extractConditionInfo(expression.getCondition());
                if (conditionInfo == null) {
                    return;
                }
                PsiExpression thenExpression = expression.getThenExpression();
                PsiExpression elseExpression = expression.getElseExpression();
                if (thenExpression == null || elseExpression == null) {
                    return;
                }
                Java8CollectionsApiInspection.this.analyzeCorrespondenceOfPutAndGet(conditionInfo.isInverted() ? thenExpression : elseExpression, conditionInfo.isInverted() ? elseExpression : thenExpression, conditionInfo.getQualifier(), conditionInfo.getContainsKey(), holder, expression);
            }

            @Override
            public void visitIfStatement(PsiIfStatement statement) {
                PsiStatement maybePutStatement;
                PsiStatement branch;
                PsiStatement maybeGetBranch;
                PsiExpression condition = statement.getCondition();
                ConditionInfo conditionInfo = Java8CollectionsApiInspection.this.extractConditionInfo(condition);
                if (conditionInfo == null) {
                    return;
                }
                PsiStatement psiStatement = maybeGetBranch = conditionInfo.isInverted() ? statement.getElseBranch() : statement.getThenBranch();
                if (maybeGetBranch instanceof PsiBlockStatement) {
                    PsiStatement[] getBranchStatements = ((PsiBlockStatement)maybeGetBranch).getCodeBlock().getStatements();
                    if (getBranchStatements.length > 1) {
                        return;
                    }
                    maybeGetBranch = getBranchStatements.length == 0 ? null : getBranchStatements[0];
                }
                PsiStatement psiStatement2 = branch = conditionInfo.isInverted() ? statement.getThenBranch() : statement.getElseBranch();
                if (branch instanceof PsiBlockStatement) {
                    PsiStatement[] statements = ((PsiBlockStatement)branch).getCodeBlock().getStatements();
                    if (statements.length != 1) {
                        return;
                    }
                    maybePutStatement = statements[statements.length - 1];
                } else {
                    maybePutStatement = branch;
                }
                if (maybePutStatement != null) {
                    Java8CollectionsApiInspection.this.analyzeCorrespondenceOfPutAndGet(maybePutStatement, maybeGetBranch, conditionInfo.getQualifier(), conditionInfo.getContainsKey(), holder, statement);
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/Java8CollectionsApiInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @Nullable
    private ConditionInfo extractConditionInfo(PsiExpression condition) {
        ConditionInfo info = Java8CollectionsApiInspection.extractConditionInfoIfGet(condition);
        if (info != null) {
            return info;
        }
        return !this.myReportContainsCondition ? null : Java8CollectionsApiInspection.extractConditionInfoIfContains(condition);
    }

    @Nullable
    static PsiExpression getValueComparedWithNull(PsiBinaryExpression binOp) {
        if (!binOp.getOperationTokenType().equals(JavaTokenType.EQEQ) && !binOp.getOperationTokenType().equals(JavaTokenType.NE)) {
            return null;
        }
        PsiExpression left = binOp.getLOperand();
        PsiExpression right = binOp.getROperand();
        if (ExpressionUtils.isNullLiteral(right)) {
            return left;
        }
        if (ExpressionUtils.isNullLiteral(left)) {
            return right;
        }
        return null;
    }

    @Nullable
    private static ConditionInfo extractConditionInfoIfGet(PsiExpression condition) {
        if (!(condition instanceof PsiBinaryExpression)) {
            return null;
        }
        PsiBinaryExpression binOp = (PsiBinaryExpression)condition;
        PsiExpression operand = Java8CollectionsApiInspection.getValueComparedWithNull(binOp);
        if (!(operand instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression maybeGetCall = (PsiMethodCallExpression)operand;
        if (!Java8CollectionsApiInspection.isJavaUtilMapMethodWithName(maybeGetCall, "get")) {
            return null;
        }
        PsiExpression[] arguments = maybeGetCall.getArgumentList().getExpressions();
        if (arguments.length != 1) {
            return null;
        }
        PsiExpression getQualifier = maybeGetCall.getMethodExpression().getQualifierExpression();
        PsiExpression keyExpression = arguments[0];
        return new ConditionInfo(getQualifier, keyExpression, binOp.getOperationTokenType().equals(JavaTokenType.EQEQ));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static ConditionInfo extractConditionInfoIfContains(PsiExpression condition) {
        PsiMethodCallExpression conditionMethodCall;
        boolean inverted = false;
        if (condition instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)condition;
            if (!JavaTokenType.EXCL.equals(prefixExpression.getOperationSign().getTokenType()) || !(prefixExpression.getOperand() instanceof PsiMethodCallExpression)) return null;
            conditionMethodCall = (PsiMethodCallExpression)prefixExpression.getOperand();
            inverted = true;
        } else {
            if (!(condition instanceof PsiMethodCallExpression)) return null;
            conditionMethodCall = (PsiMethodCallExpression)condition;
        }
        if (!Java8CollectionsApiInspection.isJavaUtilMapMethodWithName(conditionMethodCall, "containsKey")) {
            return null;
        }
        PsiExpression containsQualifier = conditionMethodCall.getMethodExpression().getQualifierExpression();
        if (containsQualifier == null) {
            return null;
        }
        PsiExpression[] expressions = conditionMethodCall.getArgumentList().getExpressions();
        if (expressions.length != 1) {
            return null;
        }
        PsiExpression containsKey = expressions[0];
        return new ConditionInfo(containsQualifier, containsKey, inverted);
    }

    private void analyzeCorrespondenceOfPutAndGet(@NotNull PsiElement adjustedElseBranch, @Nullable PsiElement adjustedThenBranch, @Nullable PsiExpression containsQualifier, @Nullable PsiExpression containsKey, @NotNull ProblemsHolder holder, @NotNull PsiElement context) {
        PsiElement maybePutMethodCall;
        PsiElement maybeGetMethodCall;
        if (adjustedElseBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adjustedElseBranch", "com/intellij/codeInspection/java18api/Java8CollectionsApiInspection", "analyzeCorrespondenceOfPutAndGet"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/java18api/Java8CollectionsApiInspection", "analyzeCorrespondenceOfPutAndGet"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/java18api/Java8CollectionsApiInspection", "analyzeCorrespondenceOfPutAndGet"));
        }
        if (adjustedThenBranch == null) {
            PsiExpression expression;
            maybeGetMethodCall = null;
            maybePutMethodCall = adjustedElseBranch instanceof PsiExpressionStatement ? ((expression = ((PsiExpressionStatement)adjustedElseBranch).getExpression()) instanceof PsiMethodCallExpression && Java8CollectionsApiInspection.isJavaUtilMapMethodWithName((PsiMethodCallExpression)expression, "put") ? expression : null) : null;
        } else if (adjustedElseBranch instanceof PsiStatement && adjustedThenBranch instanceof PsiStatement) {
            EquivalenceChecker.Decision decision = EquivalenceChecker.getCanonicalPsiEquivalence().statementsAreEquivalentDecision((PsiStatement)adjustedElseBranch, (PsiStatement)adjustedThenBranch);
            maybePutMethodCall = decision.getLeftDiff();
            maybeGetMethodCall = decision.getRightDiff();
        } else {
            maybePutMethodCall = adjustedElseBranch;
            maybeGetMethodCall = adjustedThenBranch;
        }
        if (maybePutMethodCall instanceof PsiMethodCallExpression && (maybeGetMethodCall == null || maybeGetMethodCall instanceof PsiMethodCallExpression)) {
            PsiExpression getQualifier;
            PsiMethodCallExpression putMethodCall = (PsiMethodCallExpression)maybePutMethodCall;
            PsiMethodCallExpression getMethodCall = (PsiMethodCallExpression)maybeGetMethodCall;
            PsiExpression putQualifier = putMethodCall.getMethodExpression().getQualifierExpression();
            PsiExpression psiExpression = getQualifier = getMethodCall == null ? null : getMethodCall.getMethodExpression().getQualifierExpression();
            if ((getMethodCall == null || EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(putQualifier, getQualifier)) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(putQualifier, containsQualifier) && Java8CollectionsApiInspection.isJavaUtilMapMethodWithName(putMethodCall, "put") && (getMethodCall == null || Java8CollectionsApiInspection.isJavaUtilMapMethodWithName(getMethodCall, "get"))) {
                PsiExpression getArgument;
                if (getMethodCall != null) {
                    PsiExpression[] arguments = getMethodCall.getArgumentList().getExpressions();
                    if (arguments.length != 1) {
                        return;
                    }
                    getArgument = arguments[0];
                } else {
                    getArgument = null;
                }
                PsiExpression[] putArguments = putMethodCall.getArgumentList().getExpressions();
                if (putArguments.length != 2) {
                    return;
                }
                PsiExpression putKeyArgument = putArguments[0];
                PsiExpression putValueArgument = putArguments[1];
                if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(containsKey, putKeyArgument) && (getArgument == null || EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(getArgument, putKeyArgument))) {
                    ReplaceConditionalMapPutFix fix = null;
                    if (ExpressionUtils.isSimpleExpression(putValueArgument)) {
                        fix = new ReplaceConditionalMapPutFix(putMethodCall, false);
                    } else if (maybePutMethodCall.getParent() instanceof PsiExpressionStatement && LambdaGenerationUtil.canBeUncheckedLambda(putValueArgument)) {
                        fix = new ReplaceConditionalMapPutFix(putMethodCall, true);
                    } else if (this.mySuggestPutIfAbsentForComplexExpression) {
                        fix = new ReplaceConditionalMapPutFix(putMethodCall, false);
                    }
                    if (fix != null) {
                        holder.registerProblem(context, QuickFixBundle.message("java.8.collections.api.inspection.description", new Object[0]), fix);
                    }
                }
            }
        }
    }

    static boolean isJavaUtilMapMethodWithName(@NotNull PsiMethodCallExpression methodCallExpression, @NotNull String expectedName) {
        if (methodCallExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression", "com/intellij/codeInspection/java18api/Java8CollectionsApiInspection", "isJavaUtilMapMethodWithName"));
        }
        if (expectedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedName", "com/intellij/codeInspection/java18api/Java8CollectionsApiInspection", "isJavaUtilMapMethodWithName"));
        }
        if (!expectedName.equals(methodCallExpression.getMethodExpression().getReferenceName())) {
            return false;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        Object[] superMethods = method.findDeepestSuperMethods();
        if (superMethods.length == 0) {
            superMethods = new PsiMethod[]{method};
        }
        return ((StreamEx)StreamEx.of((Object[])superMethods).map(PsiMember::getContainingClass).nonNull()).map(PsiClass::getQualifiedName).has((Object)"java.util.Map");
    }

    private static class ConditionInfo {
        private final PsiExpression myQualifier;
        private final PsiExpression myContainsKey;
        private final boolean myInverted;

        private ConditionInfo(PsiExpression qualifier, PsiExpression containsKey, boolean inverted) {
            this.myQualifier = qualifier;
            this.myContainsKey = containsKey;
            this.myInverted = inverted;
        }

        public PsiExpression getQualifier() {
            return this.myQualifier;
        }

        public PsiExpression getContainsKey() {
            return this.myContainsKey;
        }

        public boolean isInverted() {
            return this.myInverted;
        }
    }
}

