/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.javaDoc;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.javaDoc.JavadocHighlightUtil;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.javadoc.JavadocManager;
import com.intellij.psi.javadoc.JavadocTagInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDocLocalInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    public static final String SHORT_NAME = "JavaDoc";
    protected static final String NONE = "none";
    protected static final String PACKAGE_LOCAL = "package";
    protected static final String PUBLIC = "public";
    protected static final String PROTECTED = "protected";
    protected static final String PRIVATE = "private";
    private static final String IGNORE_ACCESSORS_ATTR_NAME = "IGNORE_ACCESSORS";
    private static final String IGNORE_DUPLICATED_THROWS_TAGS_ATTR_NAME = "IGNORE_DUPLICATED_THROWS_TAGS";
    protected final Options PACKAGE_OPTIONS = new Options("none", "");
    public Options TOP_LEVEL_CLASS_OPTIONS = new Options("none", "");
    public Options INNER_CLASS_OPTIONS = new Options("none", "");
    public Options METHOD_OPTIONS = new Options("none", "@return@param@throws or @exception");
    public Options FIELD_OPTIONS = new Options("none", "");
    public boolean IGNORE_DEPRECATED;
    public boolean IGNORE_JAVADOC_PERIOD = true;
    @Deprecated
    public boolean IGNORE_DUPLICATED_THROWS;
    public boolean IGNORE_POINT_TO_ITSELF;
    public String myAdditionalJavadocTags = "";
    private boolean myIgnoreDuplicatedThrows = true;
    private boolean myIgnoreEmptyDescriptions;
    private boolean myIgnoreSimpleAccessors;

    public void setPackageOption(String modifier, String tags) {
        this.PACKAGE_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR = modifier;
        this.PACKAGE_OPTIONS.REQUIRED_TAGS = tags;
    }

    public void registerAdditionalTag(@NotNull String tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "registerAdditionalTag"));
        }
        this.myAdditionalJavadocTags = !this.myAdditionalJavadocTags.isEmpty() ? this.myAdditionalJavadocTags + "," + tag : tag;
    }

    public boolean isIgnoreDuplicatedThrows() {
        return this.myIgnoreDuplicatedThrows;
    }

    public void setIgnoreDuplicatedThrows(boolean ignoreDuplicatedThrows) {
        this.myIgnoreDuplicatedThrows = ignoreDuplicatedThrows;
    }

    public void setIgnoreEmptyDescriptions(boolean ignoreEmptyDescriptions) {
        this.myIgnoreEmptyDescriptions = ignoreEmptyDescriptions;
    }

    public boolean isIgnoreSimpleAccessors() {
        return this.myIgnoreSimpleAccessors;
    }

    public void setIgnoreSimpleAccessors(boolean ignoreSimpleAccessors) {
        this.myIgnoreSimpleAccessors = ignoreSimpleAccessors;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "writeSettings"));
        }
        super.writeSettings(node);
        if (this.myIgnoreSimpleAccessors) {
            node.addContent(new Element(IGNORE_ACCESSORS_ATTR_NAME).setAttribute("value", String.valueOf(true)));
        }
        if (!this.myIgnoreDuplicatedThrows) {
            node.addContent(new Element(IGNORE_DUPLICATED_THROWS_TAGS_ATTR_NAME).setAttribute("value", String.valueOf(false)));
        }
        if (!this.PACKAGE_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR.equals(NONE) || !this.PACKAGE_OPTIONS.REQUIRED_TAGS.isEmpty()) {
            this.PACKAGE_OPTIONS.writeExternal(node);
        }
    }

    @Override
    public void readSettings(@NotNull Element node) throws InvalidDataException {
        Element ignoreDupThrowsTag;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "readSettings"));
        }
        super.readSettings(node);
        Element ignoreAccessorsTag = node.getChild(IGNORE_ACCESSORS_ATTR_NAME);
        if (ignoreAccessorsTag != null) {
            this.myIgnoreSimpleAccessors = Boolean.parseBoolean(ignoreAccessorsTag.getAttributeValue("value"));
        }
        if ((ignoreDupThrowsTag = node.getChild(IGNORE_DUPLICATED_THROWS_TAGS_ATTR_NAME)) != null) {
            this.myIgnoreDuplicatedThrows = Boolean.parseBoolean(ignoreDupThrowsTag.getAttributeValue("value"));
        }
        this.PACKAGE_OPTIONS.readExternal(node);
    }

    @Override
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "checkFile"));
        }
        if (!"package-info.java".equals(file.getName()) || !(file instanceof PsiJavaFile)) {
            return null;
        }
        PsiDocComment docComment = PsiTreeUtil.getChildOfType(file, PsiDocComment.class);
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(file.getContainingDirectory());
        boolean required = aPackage != null && JavadocHighlightUtil.isJavaDocRequired(this, aPackage);
        ProblemHolderImpl holder = new ProblemHolderImpl(manager, isOnTheFly);
        if (this.IGNORE_DEPRECATED && (AnnotationUtil.findAnnotation((PsiModifierListOwner)aPackage, "java.lang.Deprecated") != null || docComment != null && docComment.findTagByName("deprecated") != null)) {
            return null;
        }
        if (docComment == null) {
            if (required) {
                PsiElement toHighlight = ObjectUtils.notNull(((PsiJavaFile)file).getPackageStatement(), file);
                JavadocHighlightUtil.reportMissingTag(toHighlight, holder);
            }
        } else {
            PsiDocTag[] tags = docComment.getTags();
            if (required) {
                Predicate<String> tagChecker = tag -> this.isTagRequired(aPackage, (String)tag);
                JavadocHighlightUtil.checkRequiredTags(tags, tagChecker, docComment.getFirstChild(), holder);
            }
            JavadocHighlightUtil.checkRequiredTagDescriptions(tags, holder);
            JavadocHighlightUtil.checkTagValues(tags, aPackage, holder);
            JavadocHighlightUtil.checkInlineTags(docComment.getDescriptionElements(), holder);
            if (!this.IGNORE_JAVADOC_PERIOD) {
                JavadocHighlightUtil.checkForPeriod(docComment, aPackage, holder);
            }
            JavadocHighlightUtil.checkForBadCharacters(docComment, holder);
        }
        return holder.problems();
    }

    @Override
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass psiClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "checkClass"));
        }
        if (psiClass instanceof PsiAnonymousClass || psiClass instanceof PsiSyntheticClass || psiClass instanceof PsiTypeParameter) {
            return null;
        }
        if (this.IGNORE_DEPRECATED && psiClass.isDeprecated()) {
            return null;
        }
        PsiDocComment docComment = psiClass.getDocComment();
        boolean required = JavadocHighlightUtil.isJavaDocRequired(this, psiClass);
        ProblemHolderImpl holder = new ProblemHolderImpl(manager, isOnTheFly);
        if (docComment == null) {
            if (required) {
                PsiElement toHighlight = ObjectUtils.notNull(psiClass.getNameIdentifier(), psiClass);
                JavadocHighlightUtil.reportMissingTag(toHighlight, holder);
            }
        } else {
            PsiDocTag[] tags = docComment.getTags();
            if (required) {
                Predicate<String> tagChecker = tag -> {
                    if (psiClass == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "lambda$checkClass$1"));
                    }
                    return this.isTagRequired(psiClass, (String)tag);
                };
                JavadocHighlightUtil.checkRequiredTags(tags, tagChecker, docComment.getFirstChild(), holder);
            }
            JavadocHighlightUtil.checkRequiredTagDescriptions(tags, holder);
            JavadocHighlightUtil.checkTagValues(tags, psiClass, holder);
            if (!this.IGNORE_JAVADOC_PERIOD) {
                JavadocHighlightUtil.checkForPeriod(docComment, psiClass, holder);
            }
            JavadocHighlightUtil.checkInlineTags(docComment.getDescriptionElements(), holder);
            JavadocHighlightUtil.checkForBadCharacters(docComment, holder);
            JavadocHighlightUtil.checkDuplicateTags(tags, holder);
            if (required && this.isTagRequired(psiClass, "param")) {
                JavadocHighlightUtil.checkMissingTypeParamTags(psiClass, tags, docComment.getFirstChild(), holder);
            }
        }
        return holder.problems();
    }

    @Override
    @Nullable
    public ProblemDescriptor[] checkField(@NotNull PsiField psiField, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiField", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "checkField"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "checkField"));
        }
        if (this.IGNORE_DEPRECATED && JavaDocLocalInspectionBase.isDeprecated(psiField)) {
            return null;
        }
        PsiDocComment docComment = psiField.getDocComment();
        boolean required = JavadocHighlightUtil.isJavaDocRequired(this, psiField);
        ProblemHolderImpl holder = new ProblemHolderImpl(manager, isOnTheFly);
        if (docComment == null) {
            if (required) {
                JavadocHighlightUtil.reportMissingTag(psiField.getNameIdentifier(), holder);
            }
        } else {
            JavadocHighlightUtil.checkTagValues(docComment.getTags(), psiField, holder);
            JavadocHighlightUtil.checkInlineTags(docComment.getDescriptionElements(), holder);
            if (!this.IGNORE_JAVADOC_PERIOD) {
                JavadocHighlightUtil.checkForPeriod(docComment, psiField, holder);
            }
            JavadocHighlightUtil.checkDuplicateTags(docComment.getTags(), holder);
            JavadocHighlightUtil.checkForBadCharacters(docComment, holder);
        }
        return holder.problems();
    }

    @Override
    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod psiMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "checkMethod"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "checkMethod"));
        }
        if (psiMethod instanceof SyntheticElement) {
            return null;
        }
        if (this.IGNORE_DEPRECATED && JavaDocLocalInspectionBase.isDeprecated(psiMethod)) {
            return null;
        }
        if (this.myIgnoreSimpleAccessors && PropertyUtil.isSimplePropertyAccessor(psiMethod)) {
            return null;
        }
        PsiDocComment docComment = psiMethod.getDocComment();
        boolean hasSupers = psiMethod.findSuperMethods().length > 0;
        boolean required = JavadocHighlightUtil.isJavaDocRequired(this, psiMethod);
        ProblemHolderImpl holder = new ProblemHolderImpl(manager, isOnTheFly);
        if (docComment == null) {
            if (!required || hasSupers) {
                return null;
            }
            PsiIdentifier nameIdentifier = psiMethod.getNameIdentifier();
            if (nameIdentifier == null) {
                return null;
            }
            ExtensionPoint ep = Extensions.getRootArea().getExtensionPoint("com.intellij.javaDocNotNecessary");
            if (Stream.of(ep.getExtensions()).anyMatch(condition -> {
                if (psiMethod == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "lambda$checkMethod$2"));
                }
                return condition.value(psiMethod);
            })) {
                return null;
            }
            JavadocHighlightUtil.reportMissingTag(nameIdentifier, holder);
        } else {
            PsiElement[] descriptionElements = docComment.getDescriptionElements();
            if (JavaDocLocalInspectionBase.isInherited(docComment, descriptionElements, psiMethod)) {
                return null;
            }
            JavadocHighlightUtil.checkInlineTags(descriptionElements, holder);
            PsiDocTag[] tags = docComment.getTags();
            if (required && !hasSupers) {
                if (this.isTagRequired(psiMethod, "return")) {
                    JavadocHighlightUtil.checkMissingReturnTag(tags, psiMethod, docComment.getFirstChild(), holder);
                }
                if (this.isTagRequired(psiMethod, "param")) {
                    JavadocHighlightUtil.checkMissingParamTags(tags, psiMethod, docComment.getFirstChild(), holder);
                }
                if (this.isTagRequired(psiMethod, "throws")) {
                    JavadocHighlightUtil.checkMissingThrowsTags(tags, psiMethod, docComment.getFirstChild(), holder);
                }
            }
            if (!this.myIgnoreEmptyDescriptions) {
                JavadocHighlightUtil.checkEmptyMethodTagsDescription(tags, holder);
            }
            JavadocHighlightUtil.checkTagValues(tags, psiMethod, holder);
            if (!this.IGNORE_JAVADOC_PERIOD) {
                JavadocHighlightUtil.checkForPeriod(docComment, psiMethod, holder);
            }
            JavadocHighlightUtil.checkForBadCharacters(docComment, holder);
            JavadocHighlightUtil.checkDuplicateTags(tags, holder);
        }
        return holder.problems();
    }

    private boolean isTagRequired(PsiElement context, String tag) {
        if (context instanceof PsiPackage) {
            return JavaDocLocalInspectionBase.isTagRequired(this.PACKAGE_OPTIONS, tag);
        }
        if (context instanceof PsiClass) {
            boolean isInner = PsiTreeUtil.getParentOfType(context, PsiClass.class) != null;
            return JavaDocLocalInspectionBase.isTagRequired(isInner ? this.INNER_CLASS_OPTIONS : this.TOP_LEVEL_CLASS_OPTIONS, tag);
        }
        if (context instanceof PsiMethod) {
            return JavaDocLocalInspectionBase.isTagRequired(this.METHOD_OPTIONS, tag);
        }
        if (context instanceof PsiField) {
            return JavaDocLocalInspectionBase.isTagRequired(this.FIELD_OPTIONS, tag);
        }
        return false;
    }

    protected static boolean isTagRequired(Options options, String tag) {
        return options.REQUIRED_TAGS.contains(tag);
    }

    private static boolean isDeprecated(PsiDocCommentOwner element) {
        return element.isDeprecated() || element.getContainingClass() != null && element.getContainingClass().isDeprecated();
    }

    private static boolean isInherited(PsiDocComment docComment, PsiElement[] descriptionElements, PsiMethod psiMethod) {
        JavadocTagInfo tagInfo;
        for (PsiElement descriptionElement : descriptionElements) {
            if (!(descriptionElement instanceof PsiInlineDocTag) || !"inheritDoc".equals(((PsiInlineDocTag)descriptionElement).getName())) continue;
            return true;
        }
        return docComment.findTagByName("inheritDoc") != null && (tagInfo = JavadocManager.SERVICE.getInstance(psiMethod.getProject()).getTagInfo("inheritDoc")) != null && tagInfo.isValidInContext(psiMethod);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.javadoc.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message("group.names.javadoc.issues", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "getShortName"));
        }
        return SHORT_NAME;
    }

    @Override
    @Nullable
    public String getAlternativeID() {
        return "javadoc";
    }

    protected LocalQuickFix createAddJavadocFix(@NotNull PsiElement nameIdentifier, boolean isOnTheFly) {
        if (nameIdentifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameIdentifier", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "createAddJavadocFix"));
        }
        return null;
    }

    protected LocalQuickFix createAddMissingTagFix(@NotNull String tag, @NotNull String value, boolean isOnTheFly) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "createAddMissingTagFix"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "createAddMissingTagFix"));
        }
        return null;
    }

    protected LocalQuickFix createAddMissingParamTagFix(@NotNull String name, boolean isOnTheFly) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "createAddMissingParamTagFix"));
        }
        return null;
    }

    protected LocalQuickFix createRegisterTagFix(@NotNull String tag, boolean isOnTheFly) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "createRegisterTagFix"));
        }
        return null;
    }

    private class ProblemHolderImpl
    implements JavadocHighlightUtil.ProblemHolder {
        private final InspectionManager myManager;
        private final boolean myOnTheFly;
        private List<ProblemDescriptor> myProblems;

        private ProblemHolderImpl(InspectionManager manager, boolean onTheFly) {
            this.myManager = manager;
            this.myOnTheFly = onTheFly;
        }

        public ProblemDescriptor[] problems() {
            return this.myProblems == null || this.myProblems.isEmpty() ? null : this.myProblems.toArray(new ProblemDescriptor[this.myProblems.size()]);
        }

        @Override
        public Project project() {
            return this.myManager.getProject();
        }

        @Override
        public JavaDocLocalInspectionBase inspection() {
            return JavaDocLocalInspectionBase.this;
        }

        @Override
        public void problem(@NotNull PsiElement toHighlight, @NotNull @Nls String message, @Nullable LocalQuickFix fix) {
            if (toHighlight == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toHighlight", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase$ProblemHolderImpl", "problem"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase$ProblemHolderImpl", "problem"));
            }
            if (this.myProblems == null) {
                this.myProblems = ContainerUtil.newSmartList();
            }
            this.myProblems.add(this.myManager.createProblemDescriptor(toHighlight, message, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly));
        }

        @Override
        public void eolProblem(@NotNull PsiElement toHighlight, @NotNull @Nls String message, @Nullable LocalQuickFix fix) {
            LocalQuickFix[] localQuickFixArray;
            if (toHighlight == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toHighlight", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase$ProblemHolderImpl", "eolProblem"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase$ProblemHolderImpl", "eolProblem"));
            }
            if (this.myProblems == null) {
                this.myProblems = ContainerUtil.newSmartList();
            }
            if (fix != null) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = fix;
            } else {
                localQuickFixArray = null;
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            this.myProblems.add(this.myManager.createProblemDescriptor(toHighlight, message, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, true));
        }

        @Override
        public LocalQuickFix addJavadocFix(@NotNull PsiElement nameIdentifier) {
            if (nameIdentifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameIdentifier", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase$ProblemHolderImpl", "addJavadocFix"));
            }
            return JavaDocLocalInspectionBase.this.createAddJavadocFix(nameIdentifier, this.myOnTheFly);
        }

        @Override
        public LocalQuickFix addMissingTagFix(@NotNull String tag, @NotNull String value) {
            if (tag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase$ProblemHolderImpl", "addMissingTagFix"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase$ProblemHolderImpl", "addMissingTagFix"));
            }
            return JavaDocLocalInspectionBase.this.createAddMissingTagFix(tag, value, this.myOnTheFly);
        }

        @Override
        public LocalQuickFix addMissingParamTagFix(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase$ProblemHolderImpl", "addMissingParamTagFix"));
            }
            return JavaDocLocalInspectionBase.this.createAddMissingParamTagFix(name, this.myOnTheFly);
        }

        @Override
        public LocalQuickFix registerTagFix(@NotNull String tag) {
            if (tag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase$ProblemHolderImpl", "registerTagFix"));
            }
            return JavaDocLocalInspectionBase.this.createRegisterTagFix(tag, this.myOnTheFly);
        }
    }

    public static class Options
    implements JDOMExternalizable {
        public String ACCESS_JAVADOC_REQUIRED_FOR = "none";
        public String REQUIRED_TAGS = "";

        public Options() {
        }

        public Options(String accessJavadocRequiredFor, String requiredTags) {
            this.ACCESS_JAVADOC_REQUIRED_FOR = accessJavadocRequiredFor;
            this.REQUIRED_TAGS = requiredTags;
        }

        @Override
        public void readExternal(Element element) throws InvalidDataException {
            DefaultJDOMExternalizer.readExternal(this, element);
        }

        @Override
        public void writeExternal(Element element) throws WriteExternalException {
            DefaultJDOMExternalizer.writeExternal(this, element);
        }
    }
}

