/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.InheritedJdkOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ModuleOrderEnumerator;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class RootModelBase
implements ModuleRootModel {
    @Override
    @NotNull
    public VirtualFile[] getContentRoots() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (ContentEntry contentEntry : this.getContent()) {
            VirtualFile file = contentEntry.getFile();
            if (file == null) continue;
            result.add(file);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelBase", "getContentRoots"));
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public String[] getContentRootUrls() {
        if (this.getContent().isEmpty()) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelBase", "getContentRootUrls"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> result = new ArrayList<String>(this.getContent().size());
        for (ContentEntry contentEntry : this.getContent()) {
            result.add(contentEntry.getUrl());
        }
        String[] stringArray = ArrayUtil.toStringArray(result);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelBase", "getContentRootUrls"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public String[] getExcludeRootUrls() {
        SmartList<String> result = new SmartList<String>();
        for (ContentEntry contentEntry : this.getContent()) {
            result.addAll(contentEntry.getExcludeFolderUrls());
        }
        String[] stringArray = ArrayUtil.toStringArray(result);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelBase", "getExcludeRootUrls"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public VirtualFile[] getExcludeRoots() {
        SmartList result = new SmartList();
        for (ContentEntry contentEntry : this.getContent()) {
            Collections.addAll(result, contentEntry.getExcludeFolderFiles());
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelBase", "getExcludeRoots"));
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public String[] getSourceRootUrls() {
        String[] stringArray = this.getSourceRootUrls(true);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelBase", "getSourceRootUrls"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public String[] getSourceRootUrls(boolean includingTests) {
        SmartList<String> result = new SmartList<String>();
        for (ContentEntry contentEntry : this.getContent()) {
            SourceFolder[] sourceFolders;
            for (SourceFolder sourceFolder : sourceFolders = contentEntry.getSourceFolders()) {
                if (!includingTests && sourceFolder.isTestSource()) continue;
                result.add(sourceFolder.getUrl());
            }
        }
        String[] stringArray = ArrayUtil.toStringArray(result);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelBase", "getSourceRootUrls"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public VirtualFile[] getSourceRoots() {
        VirtualFile[] virtualFileArray = this.getSourceRoots(true);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelBase", "getSourceRoots"));
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public VirtualFile[] getSourceRoots(boolean includingTests) {
        SmartList<VirtualFile> result = new SmartList<VirtualFile>();
        for (ContentEntry contentEntry : this.getContent()) {
            SourceFolder[] sourceFolders;
            for (SourceFolder sourceFolder : sourceFolders = contentEntry.getSourceFolders()) {
                VirtualFile file = sourceFolder.getFile();
                if (file == null || !includingTests && sourceFolder.isTestSource()) continue;
                result.add(file);
            }
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelBase", "getSourceRoots"));
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull JpsModuleSourceRootType<?> rootType) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/RootModelBase", "getSourceRoots"));
        }
        List<VirtualFile> list = this.getSourceRoots(Collections.singleton(rootType));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelBase", "getSourceRoots"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (rootTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootTypes", "com/intellij/openapi/roots/impl/RootModelBase", "getSourceRoots"));
        }
        SmartList<VirtualFile> result = new SmartList<VirtualFile>();
        for (ContentEntry contentEntry : this.getContent()) {
            List<SourceFolder> sourceFolders = contentEntry.getSourceFolders(rootTypes);
            for (SourceFolder sourceFolder : sourceFolders) {
                VirtualFile file = sourceFolder.getFile();
                if (file == null) continue;
                result.add(file);
            }
        }
        SmartList<VirtualFile> smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelBase", "getSourceRoots"));
        }
        return smartList;
    }

    @Override
    @NotNull
    public ContentEntry[] getContentEntries() {
        Collection<ContentEntry> content = this.getContent();
        ContentEntry[] contentEntryArray = content.toArray(new ContentEntry[content.size()]);
        if (contentEntryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelBase", "getContentEntries"));
        }
        return contentEntryArray;
    }

    protected abstract Collection<ContentEntry> getContent();

    @Override
    public Sdk getSdk() {
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            if (!(orderEntry instanceof JdkOrderEntry)) continue;
            return ((JdkOrderEntry)orderEntry).getJdk();
        }
        return null;
    }

    @Override
    public boolean isSdkInherited() {
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            if (!(orderEntry instanceof InheritedJdkOrderEntry)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public OrderEnumerator orderEntries() {
        ModuleOrderEnumerator moduleOrderEnumerator = new ModuleOrderEnumerator(this, null);
        if (moduleOrderEnumerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelBase", "orderEntries"));
        }
        return moduleOrderEnumerator;
    }

    @Override
    public <R> R processOrder(RootPolicy<R> policy, R initialValue) {
        R result = initialValue;
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            result = orderEntry.accept(policy, result);
        }
        return result;
    }

    @Override
    @NotNull
    public String[] getDependencyModuleNames() {
        List result = this.orderEntries().withoutSdk().withoutLibraries().withoutModuleSourceEntries().process(new CollectDependentModules(), new ArrayList());
        String[] stringArray = ArrayUtil.toStringArray(result);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelBase", "getDependencyModuleNames"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public Module[] getModuleDependencies() {
        Module[] moduleArray = this.getModuleDependencies(true);
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelBase", "getModuleDependencies"));
        }
        return moduleArray;
    }

    @Override
    @NotNull
    public Module[] getModuleDependencies(boolean includeTests) {
        OrderEntry[] entries = this.getOrderEntries();
        ArrayList<Module> result = new ArrayList<Module>(entries.length);
        for (OrderEntry entry : entries) {
            Module module;
            if (!(entry instanceof ModuleOrderEntry)) continue;
            DependencyScope scope = ((ModuleOrderEntry)entry).getScope();
            if (!includeTests && !scope.isForProductionCompile() && !scope.isForProductionRuntime() || (module = ((ModuleOrderEntry)entry).getModule()) == null) continue;
            result.add(module);
        }
        Module[] moduleArray = result.isEmpty() ? Module.EMPTY_ARRAY : ContainerUtil.toArray(result, new Module[result.size()]);
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelBase", "getModuleDependencies"));
        }
        return moduleArray;
    }

    private static class CollectDependentModules
    extends RootPolicy<List<String>> {
        private CollectDependentModules() {
        }

        @Override
        @NotNull
        public List<String> visitModuleOrderEntry(@NotNull ModuleOrderEntry moduleOrderEntry, @NotNull List<String> arrayList) {
            if (moduleOrderEntry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleOrderEntry", "com/intellij/openapi/roots/impl/RootModelBase$CollectDependentModules", "visitModuleOrderEntry"));
            }
            if (arrayList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayList", "com/intellij/openapi/roots/impl/RootModelBase$CollectDependentModules", "visitModuleOrderEntry"));
            }
            arrayList.add(moduleOrderEntry.getModuleName());
            List<String> list = arrayList;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelBase$CollectDependentModules", "visitModuleOrderEntry"));
            }
            return list;
        }
    }
}

