/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.search.JavaOverridingMethodsSearcher;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaAllOverridingMethodsSearcher
implements QueryExecutor<Pair<PsiMethod, PsiMethod>, AllOverridingMethodsSearch.SearchParameters> {
    @Override
    public boolean execute(@NotNull AllOverridingMethodsSearch.SearchParameters p, @NotNull Processor<Pair<PsiMethod, PsiMethod>> consumer) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/JavaAllOverridingMethodsSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaAllOverridingMethodsSearcher", "execute"));
        }
        PsiClass psiClass = p.getPsiClass();
        List potentials = ReadAction.compute(() -> ContainerUtil.filter(psiClass.getMethods(), PsiUtil::canBeOverriden));
        SearchScope scope = p.getScope();
        Processor<PsiClass> inheritorsProcessor = inheritor -> {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaAllOverridingMethodsSearcher", "lambda$execute$1"));
            }
            Project project = psiClass.getProject();
            for (PsiMethod superMethod : potentials) {
                PsiMethod inInheritor;
                ProgressManager.checkCanceled();
                if (superMethod.hasModifierProperty("packageLocal") && !JavaPsiFacade.getInstance(project).arePackagesTheSame(psiClass, (PsiElement)inheritor) || (inInheritor = JavaOverridingMethodsSearcher.findOverridingMethod(project, inheritor, superMethod, psiClass)) == null || consumer.process(Pair.create(superMethod, inInheritor))) continue;
                return false;
            }
            return true;
        };
        return ClassInheritorsSearch.search(psiClass, scope, true).forEach(inheritorsProcessor);
    }
}

