/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.redundancy;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;

public class UnusedLabelInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unused.label.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/redundancy/UnusedLabelInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnusedLabelVisitor();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unused.label.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/redundancy/UnusedLabelInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnusedLabelFix();
    }

    private static class LabelFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean found;
        private final String label;

        private LabelFinder(PsiLabeledStatement target) {
            PsiIdentifier labelIdentifier = target.getLabelIdentifier();
            this.label = labelIdentifier.getText();
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/redundancy/UnusedLabelInspection$LabelFinder", "visitElement"));
            }
            if (this.found) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitContinueStatement(@NotNull PsiContinueStatement continueStatement) {
            if (continueStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "continueStatement", "com/siyeh/ig/redundancy/UnusedLabelInspection$LabelFinder", "visitContinueStatement"));
            }
            if (this.found) {
                return;
            }
            super.visitContinueStatement(continueStatement);
            PsiIdentifier labelIdentifier = continueStatement.getLabelIdentifier();
            if (this.labelMatches(labelIdentifier)) {
                this.found = true;
            }
        }

        @Override
        public void visitBreakStatement(@NotNull PsiBreakStatement breakStatement) {
            if (breakStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakStatement", "com/siyeh/ig/redundancy/UnusedLabelInspection$LabelFinder", "visitBreakStatement"));
            }
            if (this.found) {
                return;
            }
            super.visitBreakStatement(breakStatement);
            PsiIdentifier labelIdentifier = breakStatement.getLabelIdentifier();
            if (this.labelMatches(labelIdentifier)) {
                this.found = true;
            }
        }

        private boolean labelMatches(PsiIdentifier labelIdentifier) {
            if (labelIdentifier == null) {
                return false;
            }
            String labelText = labelIdentifier.getText();
            return labelText.equals(this.label);
        }

        boolean jumpFound() {
            return this.found;
        }
    }

    private static class UnusedLabelVisitor
    extends BaseInspectionVisitor {
        private UnusedLabelVisitor() {
        }

        @Override
        public void visitLabeledStatement(PsiLabeledStatement statement) {
            if (UnusedLabelVisitor.containsBreakOrContinueForLabel(statement)) {
                return;
            }
            PsiIdentifier labelIdentifier = statement.getLabelIdentifier();
            this.registerError((PsiElement)labelIdentifier, new Object[0]);
        }

        private static boolean containsBreakOrContinueForLabel(PsiLabeledStatement statement) {
            LabelFinder labelFinder = new LabelFinder(statement);
            statement.accept(labelFinder);
            return labelFinder.jumpFound();
        }
    }

    private static class UnusedLabelFix
    extends InspectionGadgetsFix {
        private UnusedLabelFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unused.label.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/redundancy/UnusedLabelInspection$UnusedLabelFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement label = descriptor.getPsiElement();
            PsiElement parent = label.getParent();
            if (!(parent instanceof PsiLabeledStatement)) {
                return;
            }
            PsiLabeledStatement labeledStatement = (PsiLabeledStatement)parent;
            PsiStatement statement = labeledStatement.getStatement();
            if (statement == null) {
                return;
            }
            String statementText = statement.getText();
            PsiReplacementUtil.replaceStatement(labeledStatement, statementText);
        }
    }
}

