/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.PsiJavaModuleStub;
import com.intellij.psi.impl.java.stubs.impl.PsiExportsStatementStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaModuleStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiRequiresStatementStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.BitUtil;
import java.util.Arrays;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ModuleVisitor;

public class ModuleStubBuildingVisitor
extends ClassVisitor {
    private static final int ACC_TRANSITIVE = 16;
    private static final int ACC_STATIC_PHASE = 32;
    private final PsiJavaFileStub myParent;
    private final String myModuleName;
    private PsiJavaModuleStub myResult;

    public ModuleStubBuildingVisitor(PsiJavaFileStub parent, String moduleName) {
        super(393216);
        this.myParent = parent;
        this.myModuleName = moduleName;
    }

    public PsiJavaModuleStub getResult() {
        return this.myResult;
    }

    public ModuleVisitor visitModule() {
        this.myResult = new PsiJavaModuleStubImpl((StubElement)this.myParent, this.myModuleName);
        return new ModuleVisitor(393216){

            public void visitRequire(String module, int access) {
                if (!BitUtil.isSet(access, 4096) && !BitUtil.isSet(access, 32768)) {
                    boolean isPublic = BitUtil.isSet(access, 16) | BitUtil.isSet(access, 1);
                    new PsiRequiresStatementStubImpl(ModuleStubBuildingVisitor.this.myResult, module, isPublic, BitUtil.isSet(access, 32));
                }
            }

            public void visitExport(String packageName, String ... modules) {
                new PsiExportsStatementStubImpl(ModuleStubBuildingVisitor.this.myResult, packageName.replace('/', '.'), modules == null ? null : Arrays.asList(modules));
            }
        };
    }
}

