/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.VolatileNullableLazyValue;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextAttributesKey
implements Comparable<TextAttributesKey> {
    private static final Logger LOG = Logger.getInstance(TextAttributesKey.class);
    private static final TextAttributes NULL_ATTRIBUTES = new TextAttributes();
    private static final ConcurrentMap<String, TextAttributesKey> ourRegistry = ContainerUtil.newConcurrentMap();
    private static final NullableLazyValue<TextAttributeKeyDefaultsProvider> ourDefaultsProvider = new VolatileNullableLazyValue<TextAttributeKeyDefaultsProvider>(){

        @Override
        @Nullable
        protected TextAttributeKeyDefaultsProvider compute() {
            return ServiceManager.getService(TextAttributeKeyDefaultsProvider.class);
        }
    };
    private final String myExternalName;
    private TextAttributes myDefaultAttributes;
    private TextAttributesKey myFallbackAttributeKey;

    private TextAttributesKey(String externalName) {
        this.myDefaultAttributes = NULL_ATTRIBUTES;
        this.myExternalName = externalName;
    }

    public TextAttributesKey(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/editor/colors/TextAttributesKey", "<init>"));
        }
        this(JDOMExternalizerUtil.readField(element, "myExternalName"));
        Element myDefaultAttributesElement = JDOMExternalizerUtil.getOption(element, "myDefaultAttributes");
        if (myDefaultAttributesElement != null) {
            this.myDefaultAttributes = new TextAttributes(myDefaultAttributesElement);
        }
    }

    @NotNull
    public static TextAttributesKey find(@NotNull @NonNls String externalName) {
        if (externalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalName", "com/intellij/openapi/editor/colors/TextAttributesKey", "find"));
        }
        TextAttributesKey v = (TextAttributesKey)ourRegistry.get(externalName);
        if (v != null) {
            TextAttributesKey textAttributesKey = v;
            if (textAttributesKey == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/TextAttributesKey", "find"));
            }
            return textAttributesKey;
        }
        v = new TextAttributesKey(externalName);
        TextAttributesKey prev = ourRegistry.putIfAbsent(externalName, v);
        TextAttributesKey textAttributesKey = prev == null ? v : prev;
        if (textAttributesKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/TextAttributesKey", "find"));
        }
        return textAttributesKey;
    }

    public String toString() {
        return this.myExternalName;
    }

    public String getExternalName() {
        return this.myExternalName;
    }

    @Override
    public int compareTo(@NotNull TextAttributesKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/TextAttributesKey", "compareTo"));
        }
        return this.myExternalName.compareTo(key.myExternalName);
    }

    @NotNull
    public static TextAttributesKey createTextAttributesKey(@NonNls @NotNull String externalName) {
        if (externalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalName", "com/intellij/openapi/editor/colors/TextAttributesKey", "createTextAttributesKey"));
        }
        TextAttributesKey textAttributesKey = TextAttributesKey.find(externalName);
        if (textAttributesKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/TextAttributesKey", "createTextAttributesKey"));
        }
        return textAttributesKey;
    }

    public void writeExternal(Element element) {
        JDOMExternalizerUtil.writeField(element, "myExternalName", this.myExternalName);
        if (this.myDefaultAttributes != NULL_ATTRIBUTES) {
            Element option = JDOMExternalizerUtil.writeOption(element, "myDefaultAttributes");
            this.myDefaultAttributes.writeExternal(option);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextAttributesKey that = (TextAttributesKey)o;
        return this.myExternalName.equals(that.myExternalName);
    }

    public int hashCode() {
        return this.myExternalName.hashCode();
    }

    public TextAttributes getDefaultAttributes() {
        if (this.myDefaultAttributes == NULL_ATTRIBUTES) {
            this.myDefaultAttributes = null;
            TextAttributeKeyDefaultsProvider provider = ourDefaultsProvider.getValue();
            if (provider != null) {
                this.myDefaultAttributes = provider.getDefaultAttributes(this);
            }
        } else if (this.myDefaultAttributes == null) {
            this.myDefaultAttributes = NULL_ATTRIBUTES;
        }
        return this.myDefaultAttributes;
    }

    @Deprecated
    @NotNull
    public static TextAttributesKey createTextAttributesKey(@NonNls @NotNull String externalName, TextAttributes defaultAttributes) {
        if (externalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalName", "com/intellij/openapi/editor/colors/TextAttributesKey", "createTextAttributesKey"));
        }
        TextAttributesKey key = TextAttributesKey.find(externalName);
        if (key.myDefaultAttributes == null || key.myDefaultAttributes == NULL_ATTRIBUTES) {
            key.myDefaultAttributes = defaultAttributes;
        }
        TextAttributesKey textAttributesKey = key;
        if (textAttributesKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/TextAttributesKey", "createTextAttributesKey"));
        }
        return textAttributesKey;
    }

    @NotNull
    public static TextAttributesKey createTextAttributesKey(@NonNls @NotNull String externalName, TextAttributesKey fallbackAttributeKey) {
        if (externalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalName", "com/intellij/openapi/editor/colors/TextAttributesKey", "createTextAttributesKey"));
        }
        TextAttributesKey key = TextAttributesKey.find(externalName);
        key.setFallbackAttributeKey(fallbackAttributeKey);
        TextAttributesKey textAttributesKey = key;
        if (textAttributesKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/TextAttributesKey", "createTextAttributesKey"));
        }
        return textAttributesKey;
    }

    @Nullable
    public TextAttributesKey getFallbackAttributeKey() {
        return this.myFallbackAttributeKey;
    }

    public void setFallbackAttributeKey(@Nullable TextAttributesKey fallbackAttributeKey) {
        this.myFallbackAttributeKey = fallbackAttributeKey;
        if (fallbackAttributeKey != null) {
            this.checkDependencies(fallbackAttributeKey, (Set<TextAttributesKey>)new THashSet());
        }
    }

    public static void removeTextAttributesKey(@NonNls @NotNull String externalName) {
        if (externalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalName", "com/intellij/openapi/editor/colors/TextAttributesKey", "removeTextAttributesKey"));
        }
        if (ourRegistry.containsKey(externalName)) {
            ourRegistry.remove(externalName);
        }
    }

    private void checkDependencies(@NotNull TextAttributesKey key, @NotNull Set<TextAttributesKey> referencedKeys) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/TextAttributesKey", "checkDependencies"));
        }
        if (referencedKeys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedKeys", "com/intellij/openapi/editor/colors/TextAttributesKey", "checkDependencies"));
        }
        if (referencedKeys.add(key)) {
            TextAttributesKey fallbackKey = key.getFallbackAttributeKey();
            if (fallbackKey != null) {
                this.checkDependencies(fallbackKey, referencedKeys);
            }
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("Cyclic TextAttributesKey dependency found: ");
            this.printDependencyLoop(sb, key);
            this.myFallbackAttributeKey = null;
            LOG.error(sb.toString());
        }
    }

    private void printDependencyLoop(@NotNull StringBuilder stringBuilder, @NotNull TextAttributesKey currNode) {
        if (stringBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringBuilder", "com/intellij/openapi/editor/colors/TextAttributesKey", "printDependencyLoop"));
        }
        if (currNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currNode", "com/intellij/openapi/editor/colors/TextAttributesKey", "printDependencyLoop"));
        }
        stringBuilder.append(currNode.getExternalName()).append("->");
        TextAttributesKey fallbackKey = currNode.getFallbackAttributeKey();
        if (fallbackKey == this) {
            stringBuilder.append(this.getExternalName());
        } else if (fallbackKey != null) {
            this.printDependencyLoop(stringBuilder, fallbackKey);
        }
    }

    public static interface TextAttributeKeyDefaultsProvider {
        public TextAttributes getDefaultAttributes(TextAttributesKey var1);
    }
}

