/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.event;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import java.util.EventObject;

public class SelectionEvent
extends EventObject {
    private static final TextRange[] EMPTY_RANGES = new TextRange[0];
    private TextRange[] myOldRanges;
    private TextRange[] myNewRanges;

    public SelectionEvent(Editor editor, int[] oldSelectionStarts, int[] oldSelectionEnds, int[] newSelectionStarts, int[] newSelectionEnds) {
        super(editor);
        SelectionEvent.assertCorrectSelection(oldSelectionStarts, oldSelectionEnds);
        SelectionEvent.assertCorrectSelection(newSelectionStarts, newSelectionEnds);
        this.myOldRanges = SelectionEvent.getRanges(oldSelectionStarts, oldSelectionEnds);
        this.myNewRanges = SelectionEvent.getRanges(newSelectionStarts, newSelectionEnds);
    }

    public SelectionEvent(Editor editor, int oldStart, int oldEnd, int newStart, int newEnd) {
        this(editor, new int[]{oldStart}, new int[]{oldEnd}, new int[]{newStart}, new int[]{newEnd});
    }

    private static void assertCorrectSelection(int[] starts, int[] ends) {
        assert (starts.length == ends.length);
    }

    public Editor getEditor() {
        return (Editor)this.getSource();
    }

    public TextRange getOldRange() {
        return SelectionEvent.getRange(this.myOldRanges);
    }

    public TextRange getNewRange() {
        return SelectionEvent.getRange(this.myNewRanges);
    }

    public TextRange[] getOldRanges() {
        return this.myOldRanges;
    }

    public TextRange[] getNewRanges() {
        return this.myNewRanges;
    }

    private static TextRange[] getRanges(int[] starts, int[] ends) {
        if (starts.length == 0) {
            return EMPTY_RANGES;
        }
        TextRange[] ranges = new TextRange[starts.length];
        for (int i2 = 0; i2 < starts.length; ++i2) {
            ranges[i2] = new TextRange(starts[i2], ends[i2]);
        }
        return ranges;
    }

    private static TextRange getRange(TextRange[] ranges) {
        if (ranges.length == 0) {
            return TextRange.EMPTY_RANGE;
        }
        return new TextRange(ranges[0].getStartOffset(), ranges[ranges.length - 1].getEndOffset());
    }
}

