/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

class MakePublicStaticFix
extends InspectionGadgetsFix {
    private final String myName;
    private final boolean myMakeStatic;

    public MakePublicStaticFix(String name, boolean makeStatic) {
        this.myName = name;
        this.myMakeStatic = makeStatic;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiElement parent;
        PsiElement element = descriptor.getPsiElement();
        if (element != null && (parent = element.getParent()) instanceof PsiMember) {
            PsiUtil.setModifierProperty((PsiMember)parent, "public", true);
            PsiUtil.setModifierProperty((PsiMember)parent, "static", this.myMakeStatic);
        }
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/MakePublicStaticFix", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        if ("Make public/static" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/MakePublicStaticFix", "getFamilyName"));
        }
        return "Make public/static";
    }
}

