/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileReferenceUtil {
    private FileReferenceUtil() {
    }

    @Nullable
    public static PsiFile findFile(@Nullable PsiElement element) {
        return element == null ? null : FileReferenceUtil.findFile(element.getReferences());
    }

    @Nullable
    public static PsiFile findFile(PsiReference ... references) {
        for (int i2 = references.length - 1; i2 >= 0; --i2) {
            PsiReference ref = references[i2];
            if (ref instanceof FileReferenceOwner && !(ref instanceof PsiFileReference)) {
                ref = ((FileReferenceOwner)((Object)ref)).getLastFileReference();
            }
            if (!(ref instanceof PsiFileReference)) continue;
            PsiElement file = references[i2].resolve();
            return file instanceof PsiFile ? (PsiFile)file : null;
        }
        return null;
    }

    @Nullable
    public static PsiFileReference findFileReference(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceUtil", "findFileReference"));
        }
        PsiReference[] references = element.getReferences();
        for (int i2 = references.length - 1; i2 >= 0; --i2) {
            PsiReference ref = references[i2];
            if (ref instanceof FileReferenceOwner && !(ref instanceof PsiFileReference)) {
                ref = ((FileReferenceOwner)((Object)ref)).getLastFileReference();
            }
            if (!(ref instanceof PsiFileReference)) continue;
            return (PsiFileReference)references[i2];
        }
        return null;
    }
}

