/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScopeBuilder;
import com.intellij.util.NotNullFunction;
import org.jetbrains.annotations.NotNull;

public class ProjectScope {
    private static final NotNullLazyKey<GlobalSearchScope, Project> ALL_SCOPE_KEY = NotNullLazyKey.create("ALL_SCOPE_KEY", new NotNullFunction<Project, GlobalSearchScope>(){

        @Override
        @NotNull
        public GlobalSearchScope fun(Project project) {
            GlobalSearchScope globalSearchScope = ProjectScopeBuilder.getInstance(project).buildAllScope();
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScope$1", "fun"));
            }
            return globalSearchScope;
        }
    });
    private static final NotNullLazyKey<GlobalSearchScope, Project> PROJECT_SCOPE_KEY = NotNullLazyKey.create("PROJECT_SCOPE_KEY", new NotNullFunction<Project, GlobalSearchScope>(){

        @Override
        @NotNull
        public GlobalSearchScope fun(Project project) {
            GlobalSearchScope globalSearchScope = ProjectScopeBuilder.getInstance(project).buildProjectScope();
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScope$2", "fun"));
            }
            return globalSearchScope;
        }
    });
    private static final NotNullLazyKey<GlobalSearchScope, Project> LIBRARIES_SCOPE_KEY = NotNullLazyKey.create("LIBRARIES_SCOPE_KEY", new NotNullFunction<Project, GlobalSearchScope>(){

        @Override
        @NotNull
        public GlobalSearchScope fun(Project project) {
            GlobalSearchScope globalSearchScope = ProjectScopeBuilder.getInstance(project).buildLibrariesScope();
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScope$3", "fun"));
            }
            return globalSearchScope;
        }
    });
    private static final NotNullLazyKey<GlobalSearchScope, Project> CONTENT_SCOPE_KEY = NotNullLazyKey.create("CONTENT_SCOPE_KEY", new NotNullFunction<Project, GlobalSearchScope>(){

        @Override
        @NotNull
        public GlobalSearchScope fun(Project project) {
            GlobalSearchScope globalSearchScope = ProjectScopeBuilder.getInstance(project).buildContentScope();
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScope$4", "fun"));
            }
            return globalSearchScope;
        }
    });
    private static final NotNullLazyKey<EverythingGlobalScope, Project> EVERYTHING_SCOPE_KEY = NotNullLazyKey.create("EVERYTHING_SCOPE_KEY", new NotNullFunction<Project, EverythingGlobalScope>(){

        @Override
        @NotNull
        public EverythingGlobalScope fun(Project project) {
            EverythingGlobalScope everythingGlobalScope = new EverythingGlobalScope(project){

                @Override
                @NotNull
                public String getDisplayName() {
                    if ("All Places" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScope$5$1", "getDisplayName"));
                    }
                    return "All Places";
                }
            };
            if (everythingGlobalScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScope$5", "fun"));
            }
            return everythingGlobalScope;
        }
    });

    private ProjectScope() {
    }

    @NotNull
    public static GlobalSearchScope getAllScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/ProjectScope", "getAllScope"));
        }
        GlobalSearchScope globalSearchScope = ALL_SCOPE_KEY.getValue(project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScope", "getAllScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getProjectScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/ProjectScope", "getProjectScope"));
        }
        GlobalSearchScope globalSearchScope = PROJECT_SCOPE_KEY.getValue(project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScope", "getProjectScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getLibrariesScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/ProjectScope", "getLibrariesScope"));
        }
        GlobalSearchScope globalSearchScope = LIBRARIES_SCOPE_KEY.getValue(project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScope", "getLibrariesScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getContentScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/ProjectScope", "getContentScope"));
        }
        GlobalSearchScope globalSearchScope = CONTENT_SCOPE_KEY.getValue(project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScope", "getContentScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getEverythingScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/ProjectScope", "getEverythingScope"));
        }
        GlobalSearchScope globalSearchScope = EVERYTHING_SCOPE_KEY.getValue(project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScope", "getEverythingScope"));
        }
        return globalSearchScope;
    }
}

