/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.internationalization.NonNlsUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class DateToStringInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("CallToDateToString" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/DateToStringInspection", "getID"));
        }
        return "CallToDateToString";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("call.to.date.tostring.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/DateToStringInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("call.to.date.tostring.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/DateToStringInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DateToStringVisitor();
    }

    private static class DateToStringVisitor
    extends BaseInspectionVisitor {
        private DateToStringVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/internationalization/DateToStringInspection$DateToStringVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            String methodName = MethodCallUtils.getMethodName(expression);
            if (!"toString".equals(methodName)) {
                return;
            }
            PsiType targetType = MethodCallUtils.getTargetType(expression);
            if (!TypeUtils.typeEquals("java.util.Date", targetType)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList.getExpressions().length != 0) {
                return;
            }
            if (NonNlsUtils.isNonNlsAnnotatedUse(expression)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }
}

