/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SimplifyStreamApiCallChainsInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceInefficientStreamCountInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(ReplaceInefficientStreamCountInspection.class);
    private static final String COUNT_METHOD = "count";
    private static final String SIZE_METHOD = "size";
    private static final String STREAM_METHOD = "stream";
    private static final String FLAT_MAP_METHOD = "flatMap";

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher(holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression methodCall) {
                PsiMethod method = methodCall.resolveMethod();
                if (SimplifyStreamApiCallChainsInspection.isCallOf(method, "java.util.stream.Stream", ReplaceInefficientStreamCountInspection.COUNT_METHOD, 0)) {
                    CountFix fix;
                    PsiMethodCallExpression qualifierCall = SimplifyStreamApiCallChainsInspection.getQualifierMethodCall(methodCall);
                    if (qualifierCall == null) {
                        return;
                    }
                    PsiMethod qualifier = qualifierCall.resolveMethod();
                    if (SimplifyStreamApiCallChainsInspection.isCallOf(qualifier, "java.util.Collection", ReplaceInefficientStreamCountInspection.STREAM_METHOD, 0)) {
                        fix = new CountFix(false);
                    } else if (SimplifyStreamApiCallChainsInspection.isCallOf(qualifier, "java.util.stream.Stream", ReplaceInefficientStreamCountInspection.FLAT_MAP_METHOD, 1) && ReplaceInefficientStreamCountInspection.this.doesFlatMapCallCollectionStream(qualifierCall)) {
                        fix = new CountFix(true);
                    } else {
                        return;
                    }
                    PsiElement nameElement = methodCall.getMethodExpression().getReferenceNameElement();
                    LOG.assertTrue(nameElement != null);
                    holder.registerProblem((PsiElement)methodCall, nameElement.getTextRange().shiftRight(-methodCall.getTextOffset()), fix.getMessage(), fix);
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    boolean doesFlatMapCallCollectionStream(PsiMethodCallExpression flatMapCall) {
        PsiMethod lambdaMethod;
        PsiExpression expression;
        PsiMethodReferenceExpression methodRef;
        PsiElement resolvedMethodRef;
        PsiExpression[] parameters = flatMapCall.getArgumentList().getExpressions();
        if (parameters.length != 1) {
            return false;
        }
        PsiExpression parameter = parameters[0];
        return parameter instanceof PsiMethodReferenceExpression ? (resolvedMethodRef = (methodRef = (PsiMethodReferenceExpression)parameter).resolve()) instanceof PsiMethod && SimplifyStreamApiCallChainsInspection.isCallOf((PsiMethod)resolvedMethodRef, "java.util.Collection", STREAM_METHOD, 0) : parameter instanceof PsiLambdaExpression && (expression = ReplaceInefficientStreamCountInspection.extractLambdaReturnExpression((PsiLambdaExpression)parameter)) instanceof PsiMethodCallExpression && SimplifyStreamApiCallChainsInspection.isCallOf(lambdaMethod = ((PsiMethodCallExpression)expression).resolveMethod(), "java.util.Collection", STREAM_METHOD, 0);
    }

    @Nullable
    private static PsiExpression extractLambdaReturnExpression(PsiLambdaExpression lambda2) {
        PsiStatement[] statements;
        PsiElement lambdaBody = lambda2.getBody();
        PsiExpression expression = null;
        if (lambdaBody instanceof PsiExpression) {
            expression = (PsiExpression)lambdaBody;
        } else if (lambdaBody instanceof PsiCodeBlock && (statements = ((PsiCodeBlock)lambdaBody).getStatements()).length == 1 && statements[0] instanceof PsiReturnStatement) {
            expression = ((PsiReturnStatement)statements[0]).getReturnValue();
        }
        return PsiUtil.skipParenthesizedExprDown(expression);
    }

    private static class CountFix
    implements LocalQuickFix {
        private final boolean myFlatMapMode;

        CountFix(boolean flatMapMode) {
            this.myFlatMapMode = flatMapMode;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = this.myFlatMapMode ? "Replace Stream.flatMap().count() with Stream.mapToLong().sum()" : "Replace Collection.stream().count() with Collection.size()";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection$CountFix", "getName"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace inefficient Stream.count()" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection$CountFix", "getFamilyName"));
            }
            return "Replace inefficient Stream.count()";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection$CountFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection$CountFix", "applyFix"));
            }
            PsiElement element = descriptor.getStartElement();
            if (!(element instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression countCall = (PsiMethodCallExpression)element;
            PsiElement countName = countCall.getMethodExpression().getReferenceNameElement();
            if (countName == null) {
                return;
            }
            PsiMethodCallExpression qualifierCall = SimplifyStreamApiCallChainsInspection.getQualifierMethodCall(countCall);
            if (qualifierCall == null) {
                return;
            }
            PsiMethod qualifier = qualifierCall.resolveMethod();
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element.getContainingFile())) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
            if (this.myFlatMapMode) {
                CountFix.replaceFlatMap(countName, qualifierCall, qualifier, factory);
            } else {
                CountFix.replaceSimpleCount(countCall, qualifierCall, qualifier, factory);
            }
        }

        private static void replaceSimpleCount(PsiMethodCallExpression countCall, PsiMethodCallExpression qualifierCall, PsiMethod qualifier, PsiElementFactory factory) {
            PsiTypeElement castElement;
            if (!SimplifyStreamApiCallChainsInspection.isCallOf(qualifier, "java.util.Collection", ReplaceInefficientStreamCountInspection.STREAM_METHOD, 0)) {
                return;
            }
            PsiExpression qualifierExpression = qualifierCall.getMethodExpression().getQualifierExpression();
            if (qualifierExpression == null) {
                return;
            }
            boolean addCast = true;
            PsiElement toReplace = countCall;
            PsiElement parent = PsiUtil.skipParenthesizedExprUp(countCall.getParent());
            if (parent instanceof PsiExpressionStatement) {
                addCast = false;
            } else if (parent instanceof PsiTypeCastExpression && (castElement = ((PsiTypeCastExpression)parent).getCastType()) != null && castElement.getType() instanceof PsiPrimitiveType) {
                addCast = false;
                if (PsiType.INT.equals(castElement.getType())) {
                    toReplace = parent;
                }
            }
            String replacementText = (addCast ? "(long) " : "") + qualifierExpression.getText() + "." + ReplaceInefficientStreamCountInspection.SIZE_METHOD + "()";
            PsiElement replacement = toReplace.replace(factory.createExpressionFromText(replacementText, countCall));
            if (replacement instanceof PsiTypeCastExpression && RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)replacement)) {
                RedundantCastUtil.removeCast((PsiTypeCastExpression)replacement);
            }
        }

        private static void replaceFlatMap(PsiElement countName, PsiMethodCallExpression qualifierCall, PsiMethod qualifier, PsiElementFactory factory) {
            PsiExpression expression;
            if (!SimplifyStreamApiCallChainsInspection.isCallOf(qualifier, "java.util.stream.Stream", ReplaceInefficientStreamCountInspection.FLAT_MAP_METHOD, 1)) {
                return;
            }
            PsiElement flatMapName = qualifierCall.getMethodExpression().getReferenceNameElement();
            if (flatMapName == null) {
                return;
            }
            PsiExpression parameter = qualifierCall.getArgumentList().getExpressions()[0];
            PsiElement streamCallName = null;
            if (parameter instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)parameter;
                streamCallName = methodRef.getReferenceNameElement();
            } else if (parameter instanceof PsiLambdaExpression && (expression = ReplaceInefficientStreamCountInspection.extractLambdaReturnExpression((PsiLambdaExpression)parameter)) instanceof PsiMethodCallExpression) {
                streamCallName = ((PsiMethodCallExpression)expression).getMethodExpression().getReferenceNameElement();
            }
            if (streamCallName == null || !streamCallName.getText().equals(ReplaceInefficientStreamCountInspection.STREAM_METHOD)) {
                return;
            }
            streamCallName.replace(factory.createIdentifier(ReplaceInefficientStreamCountInspection.SIZE_METHOD));
            flatMapName.replace(factory.createIdentifier("mapToLong"));
            countName.replace(factory.createIdentifier("sum"));
            PsiReferenceParameterList parameterList = qualifierCall.getMethodExpression().getParameterList();
            if (parameterList != null) {
                parameterList.delete();
            }
        }

        public String getMessage() {
            return this.myFlatMapMode ? "Stream.flatMap().count() can be replaced with Stream.mapToLong().sum()" : "Collection.stream().count() can be replaced with Collection.size()";
        }
    }
}

