/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.html.structureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.xml.XmlStructureViewTreeModel;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.SorterUtil;
import com.intellij.ide.util.treeView.smartTree.TreeStructureUtil;
import com.intellij.lang.html.structureView.Html5SectionsNodeProvider;
import com.intellij.lang.html.structureView.HtmlFileTreeElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.PlaceHolder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HtmlStructureViewTreeModel
extends XmlStructureViewTreeModel
implements PlaceHolder<String> {
    private final Collection<NodeProvider> myNodeProviders = Arrays.asList(new Html5SectionsNodeProvider());
    private String myStructureViewPlace;
    private static final Sorter HTML_ALPHA_SORTER = new Sorter(){

        @Override
        @NotNull
        public Comparator getComparator() {
            Comparator comparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    String s1 = SorterUtil.getStringPresentation(o1);
                    String s2 = SorterUtil.getStringPresentation(o2);
                    if (this.isTagPresentation(s1, "head") && this.isTagPresentation(s2, "body")) {
                        return -1;
                    }
                    if (this.isTagPresentation(s1, "body") && this.isTagPresentation(s2, "head")) {
                        return 1;
                    }
                    return s1.compareToIgnoreCase(s2);
                }

                private boolean isTagPresentation(String presentation, String tagName) {
                    String lowerCased = presentation.toLowerCase();
                    return lowerCased.startsWith(tagName) && (lowerCased.length() == tagName.length() || !Character.isLetter(lowerCased.charAt(tagName.length())));
                }
            };
            if (comparator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/html/structureView/HtmlStructureViewTreeModel$1", "getComparator"));
            }
            return comparator;
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        public String toString() {
            return this.getName();
        }

        @Override
        @NotNull
        public ActionPresentation getPresentation() {
            ActionPresentationData actionPresentationData = new ActionPresentationData(IdeBundle.message("action.sort.alphabetically", new Object[0]), IdeBundle.message("action.sort.alphabetically", new Object[0]), AllIcons.ObjectBrowser.Sorted);
            if (actionPresentationData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/html/structureView/HtmlStructureViewTreeModel$1", "getPresentation"));
            }
            return actionPresentationData;
        }

        @Override
        @NotNull
        public String getName() {
            if ("ALPHA_COMPARATOR" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/html/structureView/HtmlStructureViewTreeModel$1", "getName"));
            }
            return "ALPHA_COMPARATOR";
        }
    };
    private static final Sorter[] ourSorters = new Sorter[]{HTML_ALPHA_SORTER};

    public HtmlStructureViewTreeModel(XmlFile file, @Nullable Editor editor) {
        super(file, editor);
    }

    @Override
    public void setPlace(@NotNull String place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/html/structureView/HtmlStructureViewTreeModel", "setPlace"));
        }
        this.myStructureViewPlace = place;
    }

    @Override
    public String getPlace() {
        return this.myStructureViewPlace;
    }

    @Override
    @NotNull
    public Sorter[] getSorters() {
        if (TreeStructureUtil.isInStructureViewPopup(this)) {
            if (Sorter.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/html/structureView/HtmlStructureViewTreeModel", "getSorters"));
            }
            return Sorter.EMPTY_ARRAY;
        }
        if (ourSorters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/html/structureView/HtmlStructureViewTreeModel", "getSorters"));
        }
        return ourSorters;
    }

    @Override
    @NotNull
    public Collection<NodeProvider> getNodeProviders() {
        Collection<NodeProvider> collection = this.myNodeProviders;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/html/structureView/HtmlStructureViewTreeModel", "getNodeProviders"));
        }
        return collection;
    }

    @Override
    @NotNull
    public StructureViewTreeElement getRoot() {
        HtmlFileTreeElement htmlFileTreeElement = new HtmlFileTreeElement(TreeStructureUtil.isInStructureViewPopup(this), this.getPsiFile());
        if (htmlFileTreeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/html/structureView/HtmlStructureViewTreeModel", "getRoot"));
        }
        return htmlFileTreeElement;
    }
}

