/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightersRecycler;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.RedBlackTree;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateHighlightersUtil {
    private static final Comparator<HighlightInfo> BY_START_OFFSET_NODUPS = (o1, o2) -> {
        int d = o1.getActualStartOffset() - o2.getActualStartOffset();
        if (d != 0) {
            return d;
        }
        d = o1.getActualEndOffset() - o2.getActualEndOffset();
        if (d != 0) {
            return d;
        }
        d = Comparing.compare(o1.getSeverity(), o2.getSeverity());
        if (d != 0) {
            return -d;
        }
        if (!Comparing.equal(o1.type, o2.type)) {
            return String.valueOf(o1.type).compareTo(String.valueOf(o2.type));
        }
        if (!Comparing.equal(o1.getGutterIconRenderer(), o2.getGutterIconRenderer())) {
            return String.valueOf(o1.getGutterIconRenderer()).compareTo(String.valueOf(o2.getGutterIconRenderer()));
        }
        if (!Comparing.equal(o1.forcedTextAttributes, o2.forcedTextAttributes)) {
            return String.valueOf(o1.getGutterIconRenderer()).compareTo(String.valueOf(o2.getGutterIconRenderer()));
        }
        if (!Comparing.equal(o1.forcedTextAttributesKey, o2.forcedTextAttributesKey)) {
            return String.valueOf(o1.getGutterIconRenderer()).compareTo(String.valueOf(o2.getGutterIconRenderer()));
        }
        return Comparing.compare(o1.getDescription(), o2.getDescription());
    };
    private static final Key<Boolean> TYPING_INSIDE_HIGHLIGHTER_OCCURRED = Key.create("TYPING_INSIDE_HIGHLIGHTER_OCCURRED");

    private static boolean isCoveredByOffsets(HighlightInfo info, HighlightInfo coveredBy) {
        return coveredBy.startOffset <= info.startOffset && info.endOffset <= coveredBy.endOffset && info.getGutterIconRenderer() == null;
    }

    static void addHighlighterToEditorIncrementally(@NotNull Project project, @NotNull Document document, @NotNull PsiFile file, int startOffset, int endOffset, @NotNull HighlightInfo info, @Nullable EditorColorsScheme colorsScheme, int group, @NotNull Map<TextRange, RangeMarker> ranges2markersCache) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "addHighlighterToEditorIncrementally"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "addHighlighterToEditorIncrementally"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "addHighlighterToEditorIncrementally"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "addHighlighterToEditorIncrementally"));
        }
        if (ranges2markersCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges2markersCache", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "addHighlighterToEditorIncrementally"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (UpdateHighlightersUtil.isFileLevelOrGutterAnnotation(info)) {
            return;
        }
        if (info.getStartOffset() < startOffset || info.getEndOffset() > endOffset) {
            return;
        }
        MarkupModel markup = DocumentMarkupModel.forDocument(document, project, true);
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project);
        boolean myInfoIsError = UpdateHighlightersUtil.isSevere(info, severityRegistrar);
        Processor<HighlightInfo> otherHighlightInTheWayProcessor = oldInfo -> {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "lambda$addHighlighterToEditorIncrementally$1"));
            }
            if (!myInfoIsError && UpdateHighlightersUtil.isCovered(info, severityRegistrar, oldInfo)) {
                return false;
            }
            return oldInfo.getGroup() != group || !oldInfo.equalsByActualOffset(info);
        };
        boolean allIsClear = DaemonCodeAnalyzerEx.processHighlights(document, project, null, info.getActualStartOffset(), info.getActualEndOffset(), otherHighlightInTheWayProcessor);
        if (allIsClear) {
            UpdateHighlightersUtil.createOrReuseHighlighterFor(info, colorsScheme, document, group, file, (MarkupModelEx)markup, null, ranges2markersCache, severityRegistrar);
            UpdateHighlightersUtil.clearWhiteSpaceOptimizationFlag(document);
            UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
        }
    }

    public static boolean isFileLevelOrGutterAnnotation(HighlightInfo info) {
        return info.isFileLevelAnnotation() || info.getGutterIconRenderer() != null;
    }

    public static void setHighlightersToEditor(@NotNull Project project, @NotNull Document document, int startOffset, int endOffset, @NotNull Collection<HighlightInfo> highlights, @Nullable EditorColorsScheme colorsScheme, int group) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "setHighlightersToEditor"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "setHighlightersToEditor"));
        }
        if (highlights == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlights", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "setHighlightersToEditor"));
        }
        TextRange range = new TextRange(startOffset, endOffset);
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiFile psiFile = PsiDocumentManager.getInstance(project).getPsiFile(document);
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project);
        codeAnalyzer.cleanFileLevelHighlights(project, group, psiFile);
        MarkupModel markup = DocumentMarkupModel.forDocument(document, project, true);
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
        UpdateHighlightersUtil.setHighlightersInRange(project, document, range, colorsScheme, new ArrayList<HighlightInfo>(highlights), (MarkupModelEx)markup, group);
    }

    @Deprecated
    public static void setHighlightersToEditor(@NotNull Project project, @NotNull Document document, int startOffset, int endOffset, @NotNull Collection<HighlightInfo> highlights, int group) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "setHighlightersToEditor"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "setHighlightersToEditor"));
        }
        if (highlights == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlights", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "setHighlightersToEditor"));
        }
        UpdateHighlightersUtil.setHighlightersToEditor(project, document, startOffset, endOffset, highlights, null, group);
    }

    static void setHighlightersOutsideRange(@NotNull Project project, @NotNull Document document, @NotNull PsiFile psiFile, @NotNull List<HighlightInfo> infos, @Nullable EditorColorsScheme colorsScheme, int startOffset, int endOffset, @NotNull ProperTextRange priorityRange, int group) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "setHighlightersOutsideRange"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "setHighlightersOutsideRange"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "setHighlightersOutsideRange"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "setHighlightersOutsideRange"));
        }
        if (priorityRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priorityRange", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "setHighlightersOutsideRange"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project);
        if (startOffset == 0 && endOffset == document.getTextLength()) {
            codeAnalyzer.cleanFileLevelHighlights(project, group, psiFile);
        }
        MarkupModel markup = DocumentMarkupModel.forDocument(document, project, true);
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project);
        HighlightersRecycler infosToRemove = new HighlightersRecycler();
        ContainerUtil.quickSort(infos, BY_START_OFFSET_NODUPS);
        THashSet infoSet = new THashSet(infos);
        Processor<HighlightInfo> processor = arg_0 -> UpdateHighlightersUtil.lambda$setHighlightersOutsideRange$2(group, document, startOffset, endOffset, (Set)infoSet, priorityRange, infosToRemove, arg_0);
        DaemonCodeAnalyzerEx.processHighlightsOverlappingOutside(document, project, null, priorityRange.getStartOffset(), priorityRange.getEndOffset(), processor);
        THashMap ranges2markersCache = new THashMap(10);
        boolean[] changed = new boolean[]{false};
        RangeMarkerTree.sweep(processor1 -> {
            if (infos == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "lambda$setHighlightersOutsideRange$3"));
            }
            return ContainerUtil.process(infos, processor1);
        }, (arg_0, arg_1, arg_2, arg_3) -> UpdateHighlightersUtil.lambda$setHighlightersOutsideRange$4(document, startOffset, endOffset, codeAnalyzer, project, group, psiFile, changed, severityRegistrar, priorityRange, colorsScheme, markup, infosToRemove, (Map)ranges2markersCache, arg_0, arg_1, arg_2, arg_3));
        for (RangeHighlighter rangeHighlighter : infosToRemove.forAllInGarbageBin()) {
            rangeHighlighter.dispose();
            changed[0] = true;
        }
        if (changed[0]) {
            UpdateHighlightersUtil.clearWhiteSpaceOptimizationFlag(document);
        }
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
    }

    static void setHighlightersInRange(@NotNull Project project, @NotNull Document document, @NotNull TextRange range, @Nullable EditorColorsScheme colorsScheme, @NotNull List<HighlightInfo> infos, @NotNull MarkupModelEx markup, int group) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "setHighlightersInRange"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "setHighlightersInRange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "setHighlightersInRange"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "setHighlightersInRange"));
        }
        if (markup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markup", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "setHighlightersInRange"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project);
        HighlightersRecycler infosToRemove = new HighlightersRecycler();
        DaemonCodeAnalyzerEx.processHighlights(document, project, null, range.getStartOffset(), range.getEndOffset(), info -> {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "lambda$setHighlightersInRange$5"));
            }
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "lambda$setHighlightersInRange$5"));
            }
            if (info.getGroup() == group) {
                boolean willBeRemoved;
                RangeHighlighterEx highlighter = info.highlighter;
                int hiStart = highlighter.getStartOffset();
                int hiEnd = highlighter.getEndOffset();
                boolean bl = willBeRemoved = hiEnd == document.getTextLength() && range.getEndOffset() == document.getTextLength() || range.containsRange(hiStart, hiEnd);
                if (willBeRemoved) {
                    infosToRemove.recycleHighlighter(highlighter);
                    info.highlighter = null;
                }
            }
            return true;
        });
        ContainerUtil.quickSort(infos, BY_START_OFFSET_NODUPS);
        THashMap ranges2markersCache = new THashMap(10);
        PsiFile psiFile = PsiDocumentManager.getInstance(project).getPsiFile(document);
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project);
        boolean[] changed = new boolean[]{false};
        RangeMarkerTree.sweep(processor -> {
            if (infos == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "lambda$setHighlightersInRange$6"));
            }
            return ContainerUtil.process(infos, processor);
        }, (arg_0, arg_1, arg_2, arg_3) -> UpdateHighlightersUtil.lambda$setHighlightersInRange$7(psiFile, codeAnalyzer, project, group, changed, severityRegistrar, range, colorsScheme, document, markup, infosToRemove, (Map)ranges2markersCache, arg_0, arg_1, arg_2, arg_3));
        for (RangeHighlighter rangeHighlighter : infosToRemove.forAllInGarbageBin()) {
            rangeHighlighter.dispose();
            changed[0] = true;
        }
        if (changed[0]) {
            UpdateHighlightersUtil.clearWhiteSpaceOptimizationFlag(document);
        }
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
    }

    private static boolean isWarningCoveredByError(@NotNull HighlightInfo info, @NotNull Collection<HighlightInfo> overlappingIntervals, @NotNull SeverityRegistrar severityRegistrar) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "isWarningCoveredByError"));
        }
        if (overlappingIntervals == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overlappingIntervals", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "isWarningCoveredByError"));
        }
        if (severityRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severityRegistrar", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "isWarningCoveredByError"));
        }
        if (!UpdateHighlightersUtil.isSevere(info, severityRegistrar)) {
            for (HighlightInfo overlapping : overlappingIntervals) {
                if (!UpdateHighlightersUtil.isCovered(info, severityRegistrar, overlapping)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCovered(@NotNull HighlightInfo warning, @NotNull SeverityRegistrar severityRegistrar, @NotNull HighlightInfo candidate) {
        if (warning == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "warning", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "isCovered"));
        }
        if (severityRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severityRegistrar", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "isCovered"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "isCovered"));
        }
        if (!UpdateHighlightersUtil.isCoveredByOffsets(warning, candidate)) {
            return false;
        }
        HighlightSeverity severity = candidate.getSeverity();
        if (severity == HighlightInfoType.SYMBOL_TYPE_SEVERITY) {
            return false;
        }
        return UpdateHighlightersUtil.isSevere(candidate, severityRegistrar);
    }

    private static boolean isSevere(@NotNull HighlightInfo info, @NotNull SeverityRegistrar severityRegistrar) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "isSevere"));
        }
        if (severityRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severityRegistrar", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "isSevere"));
        }
        HighlightSeverity severity = info.getSeverity();
        return severityRegistrar.compare(HighlightSeverity.ERROR, severity) <= 0 || severity == HighlightInfoType.SYMBOL_TYPE_SEVERITY;
    }

    private static void createOrReuseHighlighterFor(@NotNull HighlightInfo info, @Nullable EditorColorsScheme colorsScheme, @NotNull Document document, int group, @NotNull PsiFile psiFile, @NotNull MarkupModelEx markup, @Nullable HighlightersRecycler infosToRemove, @NotNull Map<TextRange, RangeMarker> ranges2markersCache, @NotNull SeverityRegistrar severityRegistrar) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "createOrReuseHighlighterFor"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "createOrReuseHighlighterFor"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "createOrReuseHighlighterFor"));
        }
        if (markup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markup", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "createOrReuseHighlighterFor"));
        }
        if (ranges2markersCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges2markersCache", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "createOrReuseHighlighterFor"));
        }
        if (severityRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severityRegistrar", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "createOrReuseHighlighterFor"));
        }
        int infoStartOffset = info.startOffset;
        int infoEndOffset = info.endOffset;
        int docLength = document.getTextLength();
        if (infoEndOffset > docLength) {
            infoEndOffset = docLength;
            infoStartOffset = Math.min(infoStartOffset, infoEndOffset);
        }
        if (infoEndOffset == infoStartOffset && !info.isAfterEndOfLine()) {
            if (infoEndOffset == docLength) {
                return;
            }
            ++infoEndOffset;
        }
        info.setGroup(group);
        int layer = UpdateHighlightersUtil.getLayer(info, severityRegistrar);
        RangeHighlighterEx highlighter = infosToRemove == null ? null : (RangeHighlighterEx)infosToRemove.pickupHighlighterFromGarbageBin(info.startOffset, info.endOffset, layer);
        TextRange finalInfoRange = new TextRange(infoStartOffset, infoEndOffset);
        TextAttributes infoAttributes = info.getTextAttributes(psiFile, colorsScheme);
        Consumer<RangeHighlighterEx> changeAttributes = finalHighlighter -> {
            ProperTextRange fixRange;
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "lambda$createOrReuseHighlighterFor$8"));
            }
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "lambda$createOrReuseHighlighterFor$8"));
            }
            if (ranges2markersCache == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges2markersCache", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "lambda$createOrReuseHighlighterFor$8"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "lambda$createOrReuseHighlighterFor$8"));
            }
            if (infoAttributes != null) {
                finalHighlighter.setTextAttributes(infoAttributes);
            }
            info.highlighter = finalHighlighter;
            finalHighlighter.setAfterEndOfLine(info.isAfterEndOfLine());
            Color color = info.getErrorStripeMarkColor(psiFile, colorsScheme);
            finalHighlighter.setErrorStripeMarkColor(color);
            if (info != finalHighlighter.getErrorStripeTooltip()) {
                finalHighlighter.setErrorStripeTooltip(info);
            }
            GutterMark renderer = info.getGutterIconRenderer();
            finalHighlighter.setGutterIconRenderer((GutterIconRenderer)renderer);
            ranges2markersCache.put(finalInfoRange, info.highlighter);
            if (info.quickFixActionRanges != null) {
                ArrayList list = new ArrayList(info.quickFixActionRanges.size());
                for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : info.quickFixActionRanges) {
                    TextRange textRange = (TextRange)pair.second;
                    RangeMarker marker = UpdateHighlightersUtil.getOrCreate(document, ranges2markersCache, textRange);
                    list.add(Pair.create(pair.first, marker));
                }
                info.quickFixActionMarkers = ContainerUtil.createLockFreeCopyOnWriteList(list);
            }
            info.fixMarker = finalInfoRange.equals(fixRange = info.getFixTextRange()) ? null : UpdateHighlightersUtil.getOrCreate(document, ranges2markersCache, fixRange);
        };
        if (highlighter == null) {
            highlighter = markup.addRangeHighlighterAndChangeAttributes(infoStartOffset, infoEndOffset, layer, null, HighlighterTargetArea.EXACT_RANGE, false, changeAttributes);
        } else {
            markup.changeAttributesInBatch(highlighter, changeAttributes);
        }
        boolean attributesSet = Comparing.equal(infoAttributes, highlighter.getTextAttributes());
        assert (attributesSet) : "Info: " + infoAttributes + "; colorsScheme: " + (colorsScheme == null ? "[global]" : colorsScheme.getName()) + "; highlighter:" + highlighter.getTextAttributes();
    }

    private static int getLayer(@NotNull HighlightInfo info, @NotNull SeverityRegistrar severityRegistrar) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "getLayer"));
        }
        if (severityRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severityRegistrar", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "getLayer"));
        }
        HighlightSeverity severity = info.getSeverity();
        int layer = severity == HighlightSeverity.WARNING ? 4000 : (severityRegistrar.compare(severity, HighlightSeverity.ERROR) >= 0 ? 5000 : (severity == HighlightInfoType.INJECTED_FRAGMENT_SEVERITY ? 1999 : (severity == HighlightInfoType.ELEMENT_UNDER_CARET_SEVERITY ? 5500 : 3000)));
        return layer;
    }

    private static RangeMarker getOrCreate(@NotNull Document document, @NotNull Map<TextRange, RangeMarker> ranges2markersCache, @NotNull TextRange textRange) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "getOrCreate"));
        }
        if (ranges2markersCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges2markersCache", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "getOrCreate"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "getOrCreate"));
        }
        RangeMarker marker = ranges2markersCache.get(textRange);
        if (marker == null) {
            marker = document.createRangeMarker(textRange);
            ranges2markersCache.put(textRange, marker);
        }
        return marker;
    }

    static boolean isWhitespaceOptimizationAllowed(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "isWhitespaceOptimizationAllowed"));
        }
        return document.getUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED) == null;
    }

    private static void disableWhiteSpaceOptimization(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "disableWhiteSpaceOptimization"));
        }
        document.putUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED, Boolean.TRUE);
    }

    private static void clearWhiteSpaceOptimizationFlag(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "clearWhiteSpaceOptimizationFlag"));
        }
        document.putUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED, null);
    }

    static void updateHighlightersByTyping(@NotNull Project project, @NotNull DocumentEvent e) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "updateHighlightersByTyping"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "updateHighlightersByTyping"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Document document = e.getDocument();
        if (document instanceof DocumentEx && ((DocumentEx)document).isInBulkUpdate()) {
            return;
        }
        MarkupModel markup = DocumentMarkupModel.forDocument(document, project, true);
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
        int start = e.getOffset() - 1;
        int end = start + e.getOldLength();
        ArrayList toRemove = new ArrayList();
        DaemonCodeAnalyzerEx.processHighlights(document, project, null, start, end, info -> {
            if (!info.needUpdateOnTyping()) {
                return true;
            }
            RangeHighlighterEx highlighter = info.highlighter;
            int highlighterStart = highlighter.getStartOffset();
            int highlighterEnd = highlighter.getEndOffset();
            if (info.isAfterEndOfLine()) {
                if (highlighterStart < document.getTextLength()) {
                    ++highlighterStart;
                }
                if (highlighterEnd < document.getTextLength()) {
                    ++highlighterEnd;
                }
            }
            if (!highlighter.isValid() || start < highlighterEnd && highlighterStart <= end) {
                toRemove.add(info);
            }
            return true;
        });
        for (HighlightInfo info2 : toRemove) {
            if (info2.highlighter.isValid() && !info2.type.equals(HighlightInfoType.WRONG_REF)) continue;
            info2.highlighter.dispose();
        }
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
        if (!toRemove.isEmpty()) {
            UpdateHighlightersUtil.disableWhiteSpaceOptimization(document);
        }
    }

    private static void assertMarkupConsistent(@NotNull MarkupModel markup, @NotNull Project project) {
        RangeHighlighter[] allHighlighters;
        if (markup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markup", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "assertMarkupConsistent"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "assertMarkupConsistent"));
        }
        if (!RedBlackTree.VERIFY) {
            return;
        }
        Document document = markup.getDocument();
        DaemonCodeAnalyzerEx.processHighlights(document, project, null, 0, document.getTextLength(), info -> {
            if (markup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markup", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "lambda$assertMarkupConsistent$10"));
            }
            assert (((MarkupModelEx)markup).containsHighlighter(info.highlighter));
            return true;
        });
        for (RangeHighlighter highlighter : allHighlighters = markup.getAllHighlighters()) {
            boolean contains;
            Object tooltip;
            if (!highlighter.isValid() || !((tooltip = highlighter.getErrorStripeTooltip()) instanceof HighlightInfo)) continue;
            HighlightInfo info2 = (HighlightInfo)tooltip;
            boolean bl = contains = !DaemonCodeAnalyzerEx.processHighlights(document, project, null, info2.getActualStartOffset(), info2.getActualEndOffset(), highlightInfo -> BY_START_OFFSET_NODUPS.compare((HighlightInfo)highlightInfo, info2) != 0);
            assert (contains) : info2;
        }
    }

    private static /* synthetic */ boolean lambda$setHighlightersInRange$7(PsiFile psiFile, DaemonCodeAnalyzerEx codeAnalyzer, @NotNull Project project, int group, boolean[] changed, SeverityRegistrar severityRegistrar, @NotNull TextRange range, @Nullable EditorColorsScheme colorsScheme, @NotNull Document document, @NotNull MarkupModelEx markup, HighlightersRecycler infosToRemove, Map ranges2markersCache, int offset, HighlightInfo info, boolean atStart, Collection overlappingIntervals) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "lambda$setHighlightersInRange$7"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "lambda$setHighlightersInRange$7"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "lambda$setHighlightersInRange$7"));
        }
        if (markup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markup", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "lambda$setHighlightersInRange$7"));
        }
        if (!atStart) {
            return true;
        }
        if (info.isFileLevelAnnotation() && psiFile != null && psiFile.getViewProvider().isPhysical()) {
            codeAnalyzer.addFileLevelHighlight(project, group, info, psiFile);
            changed[0] = true;
            return true;
        }
        if (UpdateHighlightersUtil.isWarningCoveredByError(info, overlappingIntervals, severityRegistrar)) {
            return true;
        }
        if (info.getStartOffset() >= range.getStartOffset() && info.getEndOffset() <= range.getEndOffset() && psiFile != null) {
            UpdateHighlightersUtil.createOrReuseHighlighterFor(info, colorsScheme, document, group, psiFile, markup, infosToRemove, ranges2markersCache, severityRegistrar);
            changed[0] = true;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$setHighlightersOutsideRange$4(@NotNull Document document, int startOffset, int endOffset, DaemonCodeAnalyzerEx codeAnalyzer, @NotNull Project project, int group, @NotNull PsiFile psiFile, boolean[] changed, SeverityRegistrar severityRegistrar, @NotNull ProperTextRange priorityRange, @Nullable EditorColorsScheme colorsScheme, MarkupModel markup, HighlightersRecycler infosToRemove, Map ranges2markersCache, int offset, HighlightInfo info, boolean atStart, Collection overlappingIntervals) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "lambda$setHighlightersOutsideRange$4"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "lambda$setHighlightersOutsideRange$4"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "lambda$setHighlightersOutsideRange$4"));
        }
        if (priorityRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priorityRange", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "lambda$setHighlightersOutsideRange$4"));
        }
        if (!atStart) {
            return true;
        }
        if (!(info.isFromInjection() || info.getEndOffset() >= document.getTextLength() || info.getEndOffset() > startOffset && info.getStartOffset() < endOffset)) {
            return true;
        }
        if (info.isFileLevelAnnotation()) {
            codeAnalyzer.addFileLevelHighlight(project, group, info, psiFile);
            changed[0] = true;
            return true;
        }
        if (UpdateHighlightersUtil.isWarningCoveredByError(info, overlappingIntervals, severityRegistrar)) {
            return true;
        }
        if (info.getStartOffset() < priorityRange.getStartOffset() || info.getEndOffset() > priorityRange.getEndOffset()) {
            UpdateHighlightersUtil.createOrReuseHighlighterFor(info, colorsScheme, document, group, psiFile, (MarkupModelEx)markup, infosToRemove, ranges2markersCache, severityRegistrar);
            changed[0] = true;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$setHighlightersOutsideRange$2(int group, @NotNull Document document, int startOffset, int endOffset, Set infoSet, @NotNull ProperTextRange priorityRange, HighlightersRecycler infosToRemove, HighlightInfo info) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "lambda$setHighlightersOutsideRange$2"));
        }
        if (priorityRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priorityRange", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil", "lambda$setHighlightersOutsideRange$2"));
        }
        if (info.getGroup() == group) {
            boolean toRemove;
            RangeHighlighterEx highlighter = info.highlighter;
            int hiStart = highlighter.getStartOffset();
            int hiEnd = highlighter.getEndOffset();
            if (!(info.isFromInjection() || hiEnd >= document.getTextLength() || hiEnd > startOffset && hiStart < endOffset)) {
                return true;
            }
            boolean bl = toRemove = infoSet.contains(info) || !priorityRange.containsRange(hiStart, hiEnd) && (hiEnd != document.getTextLength() || priorityRange.getEndOffset() != document.getTextLength());
            if (toRemove) {
                infosToRemove.recycleHighlighter(highlighter);
                info.highlighter = null;
            }
        }
        return true;
    }
}

