/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlInspectionGroupNames;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.ide.highlighter.XmlLikeFileType;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.XmlLexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CheckValidXmlInScriptBodyInspectionBase
extends XmlSuppressableInspectionTool {
    @NonNls
    protected static final String AMP_ENTITY_REFERENCE = "&amp;";
    @NonNls
    protected static final String LT_ENTITY_REFERENCE = "&lt;";
    private Lexer myXmlLexer;

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/xml/util/CheckValidXmlInScriptBodyInspectionBase", "buildVisitor"));
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void visitXmlTag(XmlTag tag) {
                PsiFile psiFile;
                FileType fileType;
                if (HtmlUtil.isHtmlTag(tag)) {
                    return;
                }
                if (!"script".equals(tag.getName()) && (!(tag instanceof HtmlTag) || !"script".equalsIgnoreCase(tag.getName())) || !((fileType = (psiFile = tag.getContainingFile()).getFileType()) instanceof XmlLikeFileType)) return;
                Class<CheckValidXmlInScriptBodyInspectionBase> clazz = CheckValidXmlInScriptBodyInspectionBase.class;
                synchronized (CheckValidXmlInScriptBodyInspectionBase.class) {
                    XmlTagValue tagValue;
                    String tagBodyText;
                    if (CheckValidXmlInScriptBodyInspectionBase.this.myXmlLexer == null) {
                        CheckValidXmlInScriptBodyInspectionBase.this.myXmlLexer = new XmlLexer();
                    }
                    if ((tagBodyText = (tagValue = tag.getValue()).getText()).isEmpty()) return;
                    CheckValidXmlInScriptBodyInspectionBase.this.myXmlLexer.start(tagBodyText);
                    while (CheckValidXmlInScriptBodyInspectionBase.this.myXmlLexer.getTokenType() != null) {
                        IElementType tokenType = CheckValidXmlInScriptBodyInspectionBase.this.myXmlLexer.getTokenType();
                        if (tokenType == XmlTokenType.XML_CDATA_START) {
                            while (tokenType != null && tokenType != XmlTokenType.XML_CDATA_END) {
                                CheckValidXmlInScriptBodyInspectionBase.this.myXmlLexer.advance();
                                tokenType = CheckValidXmlInScriptBodyInspectionBase.this.myXmlLexer.getTokenType();
                            }
                            if (tokenType == null) return;
                        }
                        if (tokenType == XmlTokenType.XML_BAD_CHARACTER && "&".equals(TreeUtil.getTokenText(CheckValidXmlInScriptBodyInspectionBase.this.myXmlLexer)) || tokenType == XmlTokenType.XML_START_TAG_START) {
                            int valueStart = tagValue.getTextRange().getStartOffset();
                            int offset = valueStart + CheckValidXmlInScriptBodyInspectionBase.this.myXmlLexer.getTokenStart();
                            PsiElement psiElement = psiFile.findElementAt(offset);
                            TextRange elementRange = psiElement.getTextRange();
                            int offsetInElement = offset - elementRange.getStartOffset();
                            holder.registerProblem(psiElement, XmlBundle.message("unescaped.xml.character", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, CheckValidXmlInScriptBodyInspectionBase.this.createFix(psiElement, offsetInElement));
                            int endOfElementInScriptTag = elementRange.getEndOffset() - valueStart;
                            while (CheckValidXmlInScriptBodyInspectionBase.this.myXmlLexer.getTokenEnd() < endOfElementInScriptTag) {
                                CheckValidXmlInScriptBodyInspectionBase.this.myXmlLexer.advance();
                                if (CheckValidXmlInScriptBodyInspectionBase.this.myXmlLexer.getTokenType() != null) continue;
                            }
                        }
                        CheckValidXmlInScriptBodyInspectionBase.this.myXmlLexer.advance();
                    }
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckValidXmlInScriptBodyInspectionBase", "buildVisitor"));
        }
        return xmlElementVisitor;
    }

    protected LocalQuickFix createFix(PsiElement psiElement, int offsetInElement) {
        return null;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = XmlInspectionGroupNames.HTML_INSPECTIONS;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckValidXmlInScriptBodyInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message("html.inspections.check.valid.script.tag", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckValidXmlInScriptBodyInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    @NonNls
    public String getShortName() {
        if ("CheckValidXmlInScriptTagBody" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckValidXmlInScriptBodyInspectionBase", "getShortName"));
        }
        return "CheckValidXmlInScriptTagBody";
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckValidXmlInScriptBodyInspectionBase", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }
}

