/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class OverloadedVarargsMethodInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("overloaded.vararg.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/OverloadedVarargsMethodInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiMethod element = (PsiMethod)infos[0];
        if (element.isConstructor()) {
            String string = InspectionGadgetsBundle.message("overloaded.vararg.constructor.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/OverloadedVarargsMethodInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("overloaded.vararg.method.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/OverloadedVarargsMethodInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverloadedVarargMethodVisitor();
    }

    private static class OverloadedVarargMethodVisitor
    extends BaseInspectionVisitor {
        private OverloadedVarargMethodVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            PsiMethod[] sameNameMethods;
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/naming/OverloadedVarargsMethodInspection$OverloadedVarargMethodVisitor", "visitMethod"));
            }
            if (!method.isVarArgs()) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String methodName = method.getName();
            for (PsiMethod sameNameMethod : sameNameMethods = aClass.findMethodsByName(methodName, true)) {
                PsiSubstitutor substitutor;
                PsiClass superClass = sameNameMethod.getContainingClass();
                PsiSubstitutor psiSubstitutor = substitutor = superClass != null ? TypeConversionUtil.getSuperClassSubstitutor(superClass, aClass, PsiSubstitutor.EMPTY) : PsiSubstitutor.EMPTY;
                if (MethodSignatureUtil.areSignaturesEqual(sameNameMethod.getSignature(substitutor), method.getSignature(PsiSubstitutor.EMPTY))) continue;
                this.registerMethodError(method, method);
                return;
            }
        }
    }
}

