/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.CoreHKey;
import com.intellij.codeInspection.bytecodeAnalysis.ELattice;
import com.intellij.codeInspection.bytecodeAnalysis.HComponent;
import com.intellij.codeInspection.bytecodeAnalysis.HEquation;
import com.intellij.codeInspection.bytecodeAnalysis.HFinal;
import com.intellij.codeInspection.bytecodeAnalysis.HKey;
import com.intellij.codeInspection.bytecodeAnalysis.HPending;
import com.intellij.codeInspection.bytecodeAnalysis.HResult;
import com.intellij.codeInspection.bytecodeAnalysis.HResultUtil;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

final class Solver {
    private final ELattice<Value> lattice;
    private final HashMap<HKey, HashSet<HKey>> dependencies = new HashMap();
    private final HashMap<HKey, HPending> pending = new HashMap();
    private final HashMap<HKey, Value> solved = new HashMap();
    private final Stack<HKey> moving = new Stack();
    private final HResultUtil resultUtil;
    private final HashMap<CoreHKey, HEquation> equations = new HashMap();
    private final Value unstableValue;

    Solver(ELattice<Value> lattice, Value unstableValue) {
        this.lattice = lattice;
        this.unstableValue = unstableValue;
        this.resultUtil = new HResultUtil(lattice);
    }

    void addEquation(HEquation equation) {
        HKey key = equation.key;
        CoreHKey coreKey = new CoreHKey(key.key, key.dirKey);
        HEquation previousEquation = this.equations.get(coreKey);
        if (previousEquation == null) {
            this.equations.put(coreKey, equation);
        } else {
            HKey joinKey = new HKey(coreKey.key, coreKey.dirKey, equation.key.stable && previousEquation.key.stable, true);
            HResult joinResult = this.resultUtil.join(equation.result, previousEquation.result);
            HEquation joinEquation = new HEquation(joinKey, joinResult);
            this.equations.put(coreKey, joinEquation);
        }
    }

    void queueEquation(HEquation equation) {
        HResult rhs = equation.result;
        if (rhs instanceof HFinal) {
            this.solved.put(equation.key, ((HFinal)rhs).value);
            this.moving.push(equation.key);
        } else if (rhs instanceof HPending) {
            HPending pendResult = ((HPending)rhs).copy();
            HResult norm = this.normalize(pendResult.delta);
            if (norm instanceof HFinal) {
                this.solved.put(equation.key, ((HFinal)norm).value);
                this.moving.push(equation.key);
            } else {
                HPending pendResult1 = ((HPending)rhs).copy();
                for (HComponent component : pendResult1.delta) {
                    for (HKey trigger : component.ids) {
                        HashSet<HKey> set = this.dependencies.get(trigger);
                        if (set == null) {
                            set = new HashSet();
                            this.dependencies.put(trigger, set);
                        }
                        set.add(equation.key);
                    }
                    this.pending.put(equation.key, pendResult1);
                }
            }
        }
    }

    Value negate(Value value) {
        switch (value) {
            case True: {
                return Value.False;
            }
            case False: {
                return Value.True;
            }
        }
        return value;
    }

    Map<HKey, Value> solve() {
        for (HEquation hEquation : this.equations.values()) {
            this.queueEquation(hEquation);
        }
        while (!this.moving.empty()) {
            Value[] valueArray;
            HKey[] hKeyArray;
            HKey id = this.moving.pop();
            Value value = this.solved.get(id);
            if (id.stable) {
                HKey[] hKeyArray2 = new HKey[2];
                hKeyArray2[0] = id;
                hKeyArray = hKeyArray2;
                hKeyArray2[1] = id.invertStability();
            } else {
                HKey[] hKeyArray3 = new HKey[2];
                hKeyArray3[0] = id.invertStability();
                hKeyArray = hKeyArray3;
                hKeyArray3[1] = id;
            }
            HKey[] initialPIds = hKeyArray;
            if (id.stable) {
                Value[] valueArray2 = new Value[2];
                valueArray2[0] = value;
                valueArray = valueArray2;
                valueArray2[1] = value;
            } else {
                Value[] valueArray3 = new Value[2];
                valueArray3[0] = value;
                valueArray = valueArray3;
                valueArray3[1] = this.unstableValue;
            }
            Value[] initialPVals = valueArray;
            HKey[] pIds = new HKey[]{initialPIds[0], initialPIds[1], initialPIds[0].negate(), initialPIds[1].negate()};
            Value[] pVals = new Value[]{initialPVals[0], initialPVals[1], this.negate(initialPVals[0]), this.negate(initialPVals[1])};
            for (int i2 = 0; i2 < pIds.length; ++i2) {
                HKey pId = pIds[i2];
                Value pVal = pVals[i2];
                HashSet<HKey> dIds = this.dependencies.get(pId);
                if (dIds == null) continue;
                for (HKey dId : dIds) {
                    HPending pend = this.pending.remove(dId);
                    if (pend == null) continue;
                    HResult pend1 = this.substitute(pend, pId, pVal);
                    if (pend1 instanceof HFinal) {
                        HFinal fi = (HFinal)pend1;
                        this.solved.put(dId, fi.value);
                        this.moving.push(dId);
                        continue;
                    }
                    this.pending.put(dId, (HPending)pend1);
                }
            }
        }
        this.pending.clear();
        return this.solved;
    }

    HResult substitute(@NotNull HPending pending, @NotNull HKey id, @NotNull Value value) {
        HComponent[] sum;
        if (pending == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pending", "com/intellij/codeInspection/bytecodeAnalysis/Solver", "substitute"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/codeInspection/bytecodeAnalysis/Solver", "substitute"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/bytecodeAnalysis/Solver", "substitute"));
        }
        for (HComponent intIdComponent : sum = pending.delta) {
            if (!intIdComponent.remove(id)) continue;
            intIdComponent.value = this.lattice.meet(intIdComponent.value, value);
        }
        return this.normalize(sum);
    }

    @NotNull
    HResult normalize(@NotNull HComponent[] sum) {
        if (sum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sum", "com/intellij/codeInspection/bytecodeAnalysis/Solver", "normalize"));
        }
        Value acc = (Value)((Object)this.lattice.bot);
        boolean computableNow = true;
        for (HComponent prod : sum) {
            if (prod.isEmpty() || prod.value == this.lattice.bot) {
                acc = this.lattice.join(acc, prod.value);
                continue;
            }
            computableNow = false;
        }
        HResult hResult = acc == this.lattice.top || computableNow ? new HFinal(acc) : new HPending(sum);
        if (hResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/Solver", "normalize"));
        }
        return hResult;
    }
}

