/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.tree.events.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomChangeSet;
import com.intellij.pom.tree.events.ChangeInfo;
import com.intellij.pom.tree.events.TreeChange;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import com.intellij.pom.tree.events.impl.TreeChangeImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.CharTable;
import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TreeChangeEventImpl
implements TreeChangeEvent {
    private static final Logger LOG = Logger.getInstance("#com.intellij.pom.tree.events.impl.TreeChangeEventImpl");
    private final Map<ASTNode, TreeChange> myChangedElements;
    private List<ASTNode> myChangedInOrder;
    private final List<Set<ASTNode>> myOfEqualDepth;
    private final PomModelAspect myAspect;
    private final FileElement myFileElement;

    public TreeChangeEventImpl(@NotNull PomModelAspect aspect, @NotNull FileElement treeElement) {
        if (aspect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aspect", "com/intellij/pom/tree/events/impl/TreeChangeEventImpl", "<init>"));
        }
        if (treeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeElement", "com/intellij/pom/tree/events/impl/TreeChangeEventImpl", "<init>"));
        }
        this.myChangedElements = new THashMap();
        this.myOfEqualDepth = new ArrayList<Set<ASTNode>>(10);
        this.myAspect = aspect;
        this.myFileElement = treeElement;
    }

    @Override
    @NotNull
    public FileElement getRootElement() {
        FileElement fileElement = this.myFileElement;
        if (fileElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/pom/tree/events/impl/TreeChangeEventImpl", "getRootElement"));
        }
        return fileElement;
    }

    @Override
    @NotNull
    public ASTNode[] getChangedElements() {
        if (this.myChangedInOrder == null) {
            this.myChangedInOrder = new ArrayList<ASTNode>(this.myChangedElements.keySet());
            Collections.sort(this.myChangedInOrder, new Comparator<ASTNode>(){
                final Map<ASTNode, int[]> routeMap;
                final TObjectIntHashMap<ASTNode> nodeIndex;
                {
                    this.routeMap = new THashMap(TreeChangeEventImpl.this.myChangedElements.size());
                    this.nodeIndex = new TObjectIntHashMap(TreeChangeEventImpl.this.myChangedElements.size());
                }

                @Override
                public int compare(ASTNode o1, ASTNode o2) {
                    int[] route2;
                    int[] route = this.routeMap.get(o1);
                    if (route == null) {
                        route = TreeChangeEventImpl.getRoute(o1, (TObjectIntHashMap<ASTNode>)this.nodeIndex);
                        this.routeMap.put(o1, route);
                    }
                    if ((route2 = this.routeMap.get(o2)) == null) {
                        route2 = TreeChangeEventImpl.getRoute(o2, (TObjectIntHashMap<ASTNode>)this.nodeIndex);
                        this.routeMap.put(o2, route2);
                    }
                    return TreeChangeEventImpl.compareRoutes(route, route2);
                }
            });
        }
        ASTNode[] aSTNodeArray = this.myChangedInOrder.toArray(new ASTNode[this.myChangedInOrder.size()]);
        if (aSTNodeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/pom/tree/events/impl/TreeChangeEventImpl", "getChangedElements"));
        }
        return aSTNodeArray;
    }

    @Override
    public TreeChange getChangesByElement(@NotNull ASTNode element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/pom/tree/events/impl/TreeChangeEventImpl", "getChangesByElement"));
        }
        LOG.assertTrue(TreeChangeEventImpl.isAncestor(element, this.myFileElement), element);
        return this.myChangedElements.get(element);
    }

    private static boolean isAncestor(ASTNode thisElement, FileElement fileElement) {
        TreeElement element = (TreeElement)thisElement;
        while (element.getTreeParent() != null) {
            element = element.getTreeParent();
        }
        return element == fileElement;
    }

    @Override
    public void addElementaryChange(@NotNull ASTNode element, @NotNull ChangeInfo change) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/pom/tree/events/impl/TreeChangeEventImpl", "addElementaryChange"));
        }
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/pom/tree/events/impl/TreeChangeEventImpl", "addElementaryChange"));
        }
        LOG.assertTrue(TreeChangeEventImpl.isAncestor(element, this.myFileElement), element);
        ASTNode parent = element.getTreeParent();
        if (parent == null) {
            return;
        }
        ASTNode prevParent = element;
        int depth = 0;
        for (ASTNode currentParent = parent; currentParent != null; currentParent = currentParent.getTreeParent()) {
            if (this.myChangedElements.containsKey(currentParent)) {
                boolean currentParentHasChange;
                TreeChange changesByElement = this.getChangesByElement(currentParent);
                boolean bl = currentParentHasChange = changesByElement.getChangeByChild(prevParent) != null;
                if (currentParentHasChange && prevParent != element) {
                    return;
                }
                if (prevParent != element) {
                    ChangeInfoImpl newChange = ChangeInfoImpl.create((short)3, prevParent);
                    if (change.getChangeType() != 1) {
                        newChange.processElementaryChange(change, element);
                    }
                    change = newChange;
                }
                this.processElementaryChange(currentParent, prevParent, change, -1);
                return;
            }
            ++depth;
            prevParent = currentParent;
        }
        this.compactChanges(parent, depth - 1);
        this.processElementaryChange(parent, element, change, depth - 1);
    }

    private static int getDepth(ASTNode element) {
        int depth = 0;
        while ((element = element.getTreeParent()) != null) {
            ++depth;
        }
        return depth;
    }

    @Override
    public void clear() {
        this.myChangedInOrder = null;
        this.myChangedElements.clear();
        this.myOfEqualDepth.clear();
    }

    private void processElementaryChange(ASTNode parent, ASTNode element, ChangeInfo change, int depth) {
        TreeChange treeChange = this.myChangedElements.get(parent);
        if (treeChange == null) {
            treeChange = new TreeChangeImpl(parent);
            this.myChangedElements.put(parent, treeChange);
            int index = depth >= 0 ? depth : TreeChangeEventImpl.getDepth(parent);
            this.addToEqualsDepthList(index, parent);
        }
        treeChange.addChange(element, change);
        if (change.getChangeType() == 1) {
            element.putUserData(CharTable.CHAR_TABLE_KEY, this.myFileElement.getCharTable());
        }
        if (treeChange.isEmpty()) {
            this.removeAssociatedChanges(parent, depth);
        }
    }

    private void addToEqualsDepthList(int depth, ASTNode parent) {
        Set<ASTNode> treeElements;
        Set<ASTNode> set = treeElements = depth < this.myOfEqualDepth.size() ? this.myOfEqualDepth.get(depth) : null;
        if (treeElements == null) {
            treeElements = new HashSet<ASTNode>();
            while (depth > this.myOfEqualDepth.size()) {
                this.myOfEqualDepth.add(new HashSet());
            }
            this.myOfEqualDepth.add(depth, treeElements);
        }
        treeElements.add(parent);
    }

    private void compactChanges(ASTNode parent, int depth) {
        int currentDepth = this.myOfEqualDepth.size();
        while (--currentDepth > depth) {
            Set<ASTNode> treeElements = this.myOfEqualDepth.get(currentDepth);
            if (treeElements == null) continue;
            Iterator<ASTNode> iterator = treeElements.iterator();
            while (iterator.hasNext()) {
                TreeElement treeElement;
                boolean isUnderCompacted = false;
                for (ASTNode currentParent = treeElement = (TreeElement)iterator.next(); currentParent != null; currentParent = currentParent.getTreeParent()) {
                    if (currentParent != parent) continue;
                    isUnderCompacted = true;
                    break;
                }
                if (!isUnderCompacted) continue;
                ChangeInfoImpl compactedChange = ChangeInfoImpl.create((short)3, treeElement);
                compactedChange.compactChange(this.getChangesByElement(treeElement));
                iterator.remove();
                this.removeAssociatedChanges(treeElement, currentDepth);
                CompositeElement treeParent = treeElement.getTreeParent();
                TreeChange changesByElement = this.getChangesByElement(treeParent);
                if (changesByElement != null) {
                    ChangeInfoImpl changeByChild = (ChangeInfoImpl)changesByElement.getChangeByChild(treeElement);
                    if (changeByChild != null) {
                        changeByChild.setOldLength(compactedChange.getOldLength());
                        continue;
                    }
                    changesByElement.addChange(treeElement, compactedChange);
                    continue;
                }
                this.processElementaryChange(treeParent, treeElement, compactedChange, currentDepth - 1);
            }
        }
    }

    private void removeAssociatedChanges(ASTNode treeElement, int depth) {
        if (this.myChangedElements.remove(treeElement) != null) {
            if (depth < 0) {
                depth = TreeChangeEventImpl.getDepth(treeElement);
            }
            if (depth < this.myOfEqualDepth.size()) {
                this.myOfEqualDepth.get(depth < 0 ? TreeChangeEventImpl.getDepth(treeElement) : depth).remove(treeElement);
            }
        }
    }

    private static int[] getRoute(ASTNode node, TObjectIntHashMap<ASTNode> index) {
        ASTNode nodeTreeParent;
        ArrayList<ASTNode> parents = new ArrayList<ASTNode>(20);
        while (node != null && (nodeTreeParent = node.getTreeParent()) != null) {
            if (!index.contains((Object)node)) {
                ASTNode current = nodeTreeParent.getFirstChildNode();
                int rootIndex = 0;
                while (current != null) {
                    index.put((Object)current, rootIndex);
                    current = current.getTreeNext();
                    ++rootIndex;
                }
            }
            parents.add(node);
            node = nodeTreeParent;
        }
        int[] root = new int[parents.size()];
        for (int i2 = 0; i2 < root.length; ++i2) {
            ASTNode parent = (ASTNode)parents.get(root.length - i2 - 1);
            root[i2] = index.get((Object)parent);
        }
        return root;
    }

    private static int compareRoutes(int[] root1, int[] root2) {
        int depth = Math.min(root1.length, root2.length);
        for (int i2 = 0; i2 < depth; ++i2) {
            if (root1[i2] == root2[i2]) continue;
            if (root1[i2] > root2[i2]) {
                return 1;
            }
            if (root2[i2] <= root1[i2]) continue;
            return -1;
        }
        if (root1.length == root2.length) {
            return 0;
        }
        if (root1.length < root2.length) {
            return 1;
        }
        return -1;
    }

    @Override
    @NotNull
    public PomModelAspect getAspect() {
        PomModelAspect pomModelAspect = this.myAspect;
        if (pomModelAspect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/pom/tree/events/impl/TreeChangeEventImpl", "getAspect"));
        }
        return pomModelAspect;
    }

    @Override
    public void merge(@NotNull PomChangeSet blocked) {
        ASTNode changed;
        if (blocked == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blocked", "com/intellij/pom/tree/events/impl/TreeChangeEventImpl", "merge"));
        }
        if (!(blocked instanceof TreeChangeEventImpl)) {
            return;
        }
        TreeChangeEventImpl blockedTreeChange = (TreeChangeEventImpl)blocked;
        HashMap<ASTNode, TreeChange> changedElements = new HashMap<ASTNode, TreeChange>(blockedTreeChange.myChangedElements);
        Iterator iterator = changedElements.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ASTNode changed2 = (ASTNode)entry.getKey();
            LOG.assertTrue(TreeChangeEventImpl.isAncestor(changed2, this.myFileElement), changed2);
            TreeChange treeChange = this.myChangedElements.get(changed2);
            if (treeChange == null) continue;
            iterator.remove();
            treeChange.add((TreeChange)entry.getValue());
        }
        int depth = 0;
        Iterator iterator2 = changedElements.entrySet().iterator();
        block1: while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            changed = (ASTNode)entry.getKey();
            TreeElement prevParent = (TreeElement)changed;
            for (CompositeElement currentParent = (CompositeElement)changed.getTreeParent(); currentParent != null; currentParent = currentParent.getTreeParent()) {
                if (this.myChangedElements.containsKey(currentParent)) {
                    ChangeInfoImpl newChange = ChangeInfoImpl.create((short)3, prevParent);
                    int newLength = ((TreeElement)changed).getNotCachedLength();
                    int oldLength = ((TreeChange)entry.getValue()).getOldLength();
                    newChange.setOldLength(prevParent.getNotCachedLength() - newLength + oldLength);
                    this.processElementaryChange(currentParent, prevParent, newChange, -1);
                    iterator2.remove();
                    continue block1;
                }
                ++depth;
                prevParent = currentParent;
            }
        }
        for (Map.Entry entry : changedElements.entrySet()) {
            changed = (ASTNode)entry.getKey();
            this.myChangedElements.put(changed, (TreeChange)entry.getValue());
            this.addToEqualsDepthList(depth, changed);
            this.compactChanges(changed, depth);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<ASTNode, TreeChange> entry : this.myChangedElements.entrySet()) {
            buffer.append(entry.getKey().getElementType().toString());
            buffer.append(": ");
            buffer.append(entry.getValue().toString());
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

