/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExportsStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiExportsStatementStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiExportsStatementImpl
extends JavaStubPsiElement<PsiExportsStatementStub>
implements PsiExportsStatement {
    public PsiExportsStatementImpl(@NotNull PsiExportsStatementStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/source/PsiExportsStatementImpl", "<init>"));
        }
        super(stub, JavaStubElementTypes.EXPORTS_STATEMENT);
    }

    public PsiExportsStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/PsiExportsStatementImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @Nullable
    public PsiJavaCodeReferenceElement getPackageReference() {
        return PsiTreeUtil.getChildOfType(this, PsiJavaCodeReferenceElement.class);
    }

    @Override
    @Nullable
    public String getPackageName() {
        PsiExportsStatementStub stub = (PsiExportsStatementStub)this.getGreenStub();
        if (stub != null) {
            return StringUtil.nullize(stub.getPackageName());
        }
        PsiJavaCodeReferenceElement ref = this.getPackageReference();
        return ref != null ? PsiNameHelper.getQualifiedClassName(ref.getText(), true) : null;
    }

    @Override
    @NotNull
    public Iterable<PsiJavaModuleReferenceElement> getModuleReferences() {
        JBIterable<PsiJavaModuleReferenceElement> jBIterable = SyntaxTraverser.psiTraverser().children(this).filter(PsiJavaModuleReferenceElement.class);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiExportsStatementImpl", "getModuleReferences"));
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public List<String> getModuleNames() {
        PsiExportsStatementStub stub = (PsiExportsStatementStub)this.getGreenStub();
        if (stub != null) {
            List<String> list = stub.getTargets();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiExportsStatementImpl", "getModuleNames"));
            }
            return list;
        }
        List<String> targets = ContainerUtil.newSmartList();
        for (PsiJavaModuleReferenceElement refElement : this.getModuleReferences()) {
            targets.add(refElement.getReferenceText());
        }
        List<String> list = targets;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiExportsStatementImpl", "getModuleNames"));
        }
        return list;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiExportsStatementImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitExportsStatement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiExportsStatement";
    }
}

