/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.xml.XmlTextImpl;
import com.intellij.psi.impl.source.xml.behavior.DefaultXmlPsiPolicy;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class XmlTagValueImpl
implements XmlTagValue {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.xml.XmlTagValueImpl");
    private final XmlTag myTag;
    private final XmlTagChild[] myElements;
    private volatile XmlText[] myTextElements;
    private volatile String myText;
    private volatile String myTrimmedText;

    public XmlTagValueImpl(@NotNull XmlTagChild[] bodyElements, @NotNull XmlTag tag) {
        if (bodyElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodyElements", "com/intellij/psi/impl/source/xml/XmlTagValueImpl", "<init>"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/impl/source/xml/XmlTagValueImpl", "<init>"));
        }
        this.myTag = tag;
        this.myElements = bodyElements;
    }

    @Override
    @NotNull
    public XmlTagChild[] getChildren() {
        if (this.myElements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagValueImpl", "getChildren"));
        }
        return this.myElements;
    }

    @Override
    @NotNull
    public XmlText[] getTextElements() {
        XmlText[] textElements = this.myTextElements;
        if (textElements != null) {
            if (textElements == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagValueImpl", "getTextElements"));
            }
            return textElements;
        }
        textElements = (XmlText[])Arrays.stream(this.myElements).filter(element -> element instanceof XmlText).map(element -> (XmlText)element).toArray(XmlText[]::new);
        XmlText[] xmlTextArray = this.myTextElements = textElements.length == 0 ? XmlText.EMPTY_ARRAY : textElements;
        if (xmlTextArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagValueImpl", "getTextElements"));
        }
        return xmlTextArray;
    }

    @Override
    @NotNull
    public String getText() {
        String text = this.myText;
        if (text != null) {
            String string = text;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagValueImpl", "getText"));
            }
            return string;
        }
        StringBuilder consolidatedText = new StringBuilder();
        for (XmlTagChild element : this.myElements) {
            consolidatedText.append(element.getText());
        }
        this.myText = consolidatedText.toString();
        if (this.myText == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagValueImpl", "getText"));
        }
        return this.myText;
    }

    @Override
    @NotNull
    public TextRange getTextRange() {
        if (this.myElements.length == 0) {
            ASTNode child = XmlChildRole.START_TAG_END_FINDER.findChild((ASTNode)((Object)this.myTag));
            if (child != null) {
                TextRange textRange = new TextRange(child.getStartOffset() + 1, child.getStartOffset() + 1);
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagValueImpl", "getTextRange"));
                }
                return textRange;
            }
            TextRange textRange = new TextRange(this.myTag.getTextRange().getEndOffset(), this.myTag.getTextRange().getEndOffset());
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagValueImpl", "getTextRange"));
            }
            return textRange;
        }
        TextRange textRange = new TextRange(this.myElements[0].getTextRange().getStartOffset(), this.myElements[this.myElements.length - 1].getTextRange().getEndOffset());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagValueImpl", "getTextRange"));
        }
        return textRange;
    }

    @Override
    @NotNull
    public String getTrimmedText() {
        XmlText[] textElements;
        String trimmedText = this.myTrimmedText;
        if (trimmedText != null) {
            String string = trimmedText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagValueImpl", "getTrimmedText"));
            }
            return string;
        }
        StringBuilder consolidatedText = new StringBuilder();
        for (XmlText textElement : textElements = this.getTextElements()) {
            consolidatedText.append(textElement.getValue());
        }
        this.myTrimmedText = consolidatedText.toString().trim();
        if (this.myTrimmedText == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagValueImpl", "getTrimmedText"));
        }
        return this.myTrimmedText;
    }

    @Override
    public void setText(String value) {
        this.setText(value, false);
    }

    @Override
    public void setEscapedText(String value) {
        this.setText(value, true);
    }

    private void setText(String value, boolean defaultPolicy) {
        try {
            XmlText text = null;
            if (value != null) {
                XmlText[] texts = this.getTextElements();
                text = texts.length == 0 ? (XmlText)this.myTag.add(XmlElementFactory.getInstance(this.myTag.getProject()).createDisplayText("x")) : texts[0];
                if (StringUtil.isEmpty(value)) {
                    text.delete();
                } else if (defaultPolicy && text instanceof XmlTextImpl) {
                    ((XmlTextImpl)text).doSetValue(value, new DefaultXmlPsiPolicy());
                } else {
                    text.setValue(value);
                }
            }
            if (this.myElements.length > 0) {
                for (XmlTagChild child : this.myElements) {
                    if (child == text) continue;
                    child.delete();
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
    }

    @Override
    public boolean hasCDATA() {
        for (XmlText xmlText : this.getTextElements()) {
            PsiElement[] children;
            for (PsiElement child : children = xmlText.getChildren()) {
                if (child.getNode().getElementType() != XmlElementType.XML_CDATA) continue;
                return true;
            }
        }
        return false;
    }

    public static XmlTagValue createXmlTagValue(XmlTag tag) {
        final ArrayList bodyElements = new ArrayList();
        tag.processElements(new PsiElementProcessor(){
            boolean insideBody;

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/xml/XmlTagValueImpl$1", "execute"));
                }
                ASTNode treeElement = element.getNode();
                if (this.insideBody) {
                    if (treeElement != null && treeElement.getElementType() == XmlTokenType.XML_END_TAG_START) {
                        return false;
                    }
                    if (!(element instanceof XmlTagChild)) {
                        return true;
                    }
                    bodyElements.add((XmlTagChild)element);
                } else if (treeElement != null && treeElement.getElementType() == XmlTokenType.XML_TAG_END) {
                    this.insideBody = true;
                }
                return true;
            }
        }, tag);
        XmlTagChild[] tagChildren = ContainerUtil.toArray(bodyElements, new XmlTagChild[bodyElements.size()]);
        return new XmlTagValueImpl(tagChildren, tag);
    }
}

