/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class EnumAsNameInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("EnumAsIdentifier" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/jdk/EnumAsNameInspectionBase", "getID"));
        }
        return "EnumAsIdentifier";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("use.enum.as.identifier.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/jdk/EnumAsNameInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("use.enum.as.identifier.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/jdk/EnumAsNameInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EnumAsNameVisitor();
    }

    private static class EnumAsNameVisitor
    extends BaseInspectionVisitor {
        private EnumAsNameVisitor() {
        }

        @Override
        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/jdk/EnumAsNameInspectionBase$EnumAsNameVisitor", "visitVariable"));
            }
            super.visitVariable(variable);
            String variableName = variable.getName();
            if (!"enum".equals(variableName)) {
                return;
            }
            this.registerVariableError(variable, new Object[0]);
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/jdk/EnumAsNameInspectionBase$EnumAsNameVisitor", "visitMethod"));
            }
            super.visitMethod(method);
            String name = method.getName();
            if (!"enum".equals(name)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/jdk/EnumAsNameInspectionBase$EnumAsNameVisitor", "visitClass"));
            }
            String name = aClass.getName();
            if (!"enum".equals(name)) {
                return;
            }
            PsiTypeParameterList params = aClass.getTypeParameterList();
            if (params != null) {
                params.accept(this);
            }
            this.registerClassError(aClass, new Object[0]);
        }

        @Override
        public void visitTypeParameter(PsiTypeParameter parameter) {
            super.visitTypeParameter(parameter);
            String name = parameter.getName();
            if (!"enum".equals(name)) {
                return;
            }
            this.registerTypeParameterError(parameter, new Object[0]);
        }
    }
}

