/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.ELattice;
import com.intellij.codeInspection.bytecodeAnalysis.Final;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.Product;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;

class ResultUtil {
    private final ELattice<Value> lattice;
    final Value top;

    ResultUtil(ELattice<Value> lattice) {
        this.lattice = lattice;
        this.top = (Value)((Object)lattice.top);
    }

    Result join(Result r1, Result r2) throws AnalyzerException {
        if (r1 instanceof Final && ((Final)r1).value == this.top) {
            return r1;
        }
        if (r2 instanceof Final && ((Final)r2).value == this.top) {
            return r2;
        }
        if (r1 instanceof Final && r2 instanceof Final) {
            return new Final(this.lattice.join(((Final)r1).value, ((Final)r2).value));
        }
        if (r1 instanceof Final && r2 instanceof Pending) {
            Final f1 = (Final)r1;
            Pending pending = (Pending)r2;
            HashSet<Product> sum1 = new HashSet<Product>(pending.sum);
            sum1.add(new Product(f1.value, Collections.emptySet()));
            return new Pending(sum1);
        }
        if (r1 instanceof Pending && r2 instanceof Final) {
            Final f2 = (Final)r2;
            Pending pending = (Pending)r1;
            HashSet<Product> sum1 = new HashSet<Product>(pending.sum);
            sum1.add(new Product(f2.value, Collections.emptySet()));
            return new Pending(sum1);
        }
        Pending pending1 = (Pending)r1;
        Pending pending2 = (Pending)r2;
        HashSet<Product> sum = new HashSet<Product>();
        sum.addAll(pending1.sum);
        sum.addAll(pending2.sum);
        ResultUtil.checkLimit(sum);
        return new Pending(sum);
    }

    private static void checkLimit(Set<Product> sum) throws AnalyzerException {
        int size = sum.stream().mapToInt(prod -> prod.ids.size()).sum();
        if (size > 30) {
            throw new AnalyzerException(null, "Equation size is too big");
        }
    }
}

