/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class UnsignedShortArrayList
implements Cloneable {
    private char[] myData;
    private int mySize;

    public UnsignedShortArrayList(int initialCapacity) {
        this.myData = new char[initialCapacity];
    }

    public UnsignedShortArrayList() {
        this(10);
    }

    public void trimToSize() {
        if (this.mySize < this.myData.length) {
            this.myData = ArrayUtil.realloc(this.myData, this.mySize);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.myData.length;
        if (minCapacity > oldCapacity) {
            char[] oldData = this.myData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.myData = new char[newCapacity];
            System.arraycopy(oldData, 0, this.myData, 0, this.mySize);
        }
    }

    public void fill(int fromIndex, int toIndex, int value) {
        UnsignedShortArrayList.assertShort(value);
        if (toIndex > this.mySize) {
            this.ensureCapacity(toIndex);
            this.mySize = toIndex;
        }
        Arrays.fill(this.myData, fromIndex, toIndex, (char)value);
    }

    public int size() {
        return this.mySize;
    }

    public boolean isEmpty() {
        return this.mySize == 0;
    }

    public boolean contains(int element) {
        UnsignedShortArrayList.assertShort(element);
        return this.indexOf(element) >= 0;
    }

    public int indexOf(int element) {
        UnsignedShortArrayList.assertShort(element);
        return this.indexOf(element, 0, this.mySize);
    }

    public int indexOf(int element, int startIndex, int endIndex) {
        UnsignedShortArrayList.assertShort(element);
        if (startIndex < 0 || endIndex < startIndex || endIndex > this.mySize) {
            throw new IndexOutOfBoundsException("startIndex: " + startIndex + "; endIndex: " + endIndex + "; mySize: " + this.mySize);
        }
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            if (element != this.myData[i2]) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOf(int element) {
        UnsignedShortArrayList.assertShort(element);
        for (int i2 = this.mySize - 1; i2 >= 0; --i2) {
            if (element != this.myData[i2]) continue;
            return i2;
        }
        return -1;
    }

    public Object clone() {
        try {
            UnsignedShortArrayList v = (UnsignedShortArrayList)super.clone();
            v.myData = (char[])this.myData.clone();
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @NotNull
    public int[] toArray() {
        int[] nArray = this.toArray(0, this.mySize);
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/UnsignedShortArrayList", "toArray"));
        }
        return nArray;
    }

    @NotNull
    public int[] toArray(@NotNull int[] a) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/util/containers/UnsignedShortArrayList", "toArray"));
        }
        if (a.length < this.mySize) {
            a = new int[this.mySize];
        }
        for (int i2 = 0; i2 < this.mySize; ++i2) {
            int c;
            a[i2] = c = this.myData[i2];
        }
        if (a == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/UnsignedShortArrayList", "toArray"));
        }
        return a;
    }

    @NotNull
    public int[] toArray(int startIndex, int length) {
        int[] result = new int[length];
        for (int i2 = startIndex; i2 < length; ++i2) {
            int c;
            result[i2 - startIndex] = c = this.myData[i2];
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/UnsignedShortArrayList", "toArray"));
        }
        return result;
    }

    public int get(int index) {
        this.checkRange(index);
        return this.myData[index];
    }

    public int getQuick(int index) {
        return this.myData[index];
    }

    public int set(int index, int element) {
        this.checkRange(index);
        char oldValue = this.myData[index];
        this.setQuick(index, element);
        return oldValue;
    }

    public void setQuick(int index, int element) {
        UnsignedShortArrayList.assertShort(element);
        this.myData[index] = (char)element;
    }

    private static void assertShort(int element) {
        assert (element >= 0 && element < 65536) : element;
    }

    public void add(int element) {
        this.ensureCapacity(this.mySize + 1);
        this.setQuick(this.mySize++, element);
    }

    public void add(int index, int element) {
        if (index > this.mySize || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
        this.ensureCapacity(this.mySize + 1);
        System.arraycopy(this.myData, index, this.myData, index + 1, this.mySize - index);
        this.setQuick(index, element);
        ++this.mySize;
    }

    public int remove(int index) {
        this.checkRange(index);
        char oldValue = this.myData[index];
        int numMoved = this.mySize - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.myData, index + 1, this.myData, index, numMoved);
        }
        --this.mySize;
        return oldValue;
    }

    public void clear() {
        this.mySize = 0;
    }

    public void removeRange(int fromIndex, int toIndex) {
        int numMoved = this.mySize - toIndex;
        System.arraycopy(this.myData, toIndex, this.myData, fromIndex, numMoved);
        this.mySize -= toIndex - fromIndex;
    }

    public void copyRange(int fromIndex, int length, int toIndex) {
        if (length < 0 || fromIndex < 0 || fromIndex + length > this.mySize || toIndex < 0 || toIndex + length > this.mySize) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + "; length: " + length + "; toIndex: " + toIndex + "; mySize: " + this.mySize);
        }
        System.arraycopy(this.myData, fromIndex, this.myData, toIndex, length);
    }

    private void checkRange(int index) {
        if (index >= this.mySize || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

