/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.StateMerger;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class StateQueue {
    private final PriorityQueue<DfaInstructionState> myQueue = new PriorityQueue();
    private final Set<Pair<Instruction, DfaMemoryState>> mySet = ContainerUtil.newHashSet();

    StateQueue() {
    }

    void offer(DfaInstructionState state) {
        if (this.mySet.add(Pair.create(state.getInstruction(), state.getMemoryState()))) {
            this.myQueue.offer(state);
        }
    }

    boolean isEmpty() {
        return this.myQueue.isEmpty();
    }

    boolean processAll(@NotNull Processor<? super DfaInstructionState> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/dataFlow/StateQueue", "processAll"));
        }
        for (DfaInstructionState state : this.myQueue) {
            if (processor.process(state)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    List<DfaInstructionState> getNextInstructionStates(Set<Instruction> joinInstructions) {
        DfaInstructionState state = this.myQueue.poll();
        Instruction instruction = state.getInstruction();
        this.mySet.remove(Pair.create(instruction, state.getMemoryState()));
        DfaInstructionState next = this.myQueue.peek();
        if (next == null || next.compareTo(state) != 0) {
            List<DfaInstructionState> list = Collections.singletonList(state);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StateQueue", "getNextInstructionStates"));
            }
            return list;
        }
        ArrayList<DfaMemoryStateImpl> memoryStates = ContainerUtil.newArrayList();
        memoryStates.add((DfaMemoryStateImpl)state.getMemoryState());
        while (!this.myQueue.isEmpty() && this.myQueue.peek().compareTo(state) == 0) {
            DfaMemoryState anotherState = this.myQueue.poll().getMemoryState();
            this.mySet.remove(Pair.create(instruction, anotherState));
            memoryStates.add((DfaMemoryStateImpl)anotherState);
        }
        if (memoryStates.size() > 1 && joinInstructions.contains(instruction)) {
            MultiMap<Object, DfaMemoryStateImpl> groups = MultiMap.create();
            for (DfaMemoryStateImpl dfaMemoryStateImpl : memoryStates) {
                groups.putValue(dfaMemoryStateImpl.getSuperficialKey(), dfaMemoryStateImpl);
            }
            memoryStates = ContainerUtil.newArrayList();
            for (Map.Entry entry : groups.entrySet()) {
                memoryStates.addAll(StateQueue.mergeGroup((List)entry.getValue()));
            }
        }
        List<DfaInstructionState> list = ContainerUtil.map(memoryStates, state1 -> new DfaInstructionState(instruction, (DfaMemoryState)state1));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StateQueue", "getNextInstructionStates"));
        }
        return list;
    }

    private static List<DfaMemoryStateImpl> mergeGroup(List<DfaMemoryStateImpl> group) {
        if (group.size() < 2) {
            return group;
        }
        StateMerger merger = new StateMerger();
        while (true) {
            List<DfaMemoryStateImpl> nextStates;
            if ((nextStates = merger.mergeByFacts(group)) == null) {
                nextStates = merger.mergeByNullability(group);
            }
            if (nextStates == null) {
                nextStates = merger.mergeByUnknowns(group);
            }
            if (nextStates == null) break;
            group = nextStates;
        }
        return group;
    }
}

