/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18api;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.java18api.Java8CollectionsApiInspection;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java8ReplaceMapGetInspection
extends BaseJavaBatchLocalInspectionTool {
    private boolean mySuggestMapGetOrDefault = false;
    public boolean mySuggestMapComputeIfAbsent = true;

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel(this);
        panel.addCheckbox("Suggest conversion to Map.computeIfAbsent", "mySuggestMapComputeIfAbsent");
        return panel;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/java18api/Java8ReplaceMapGetInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher(holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/Java8ReplaceMapGetInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitIfStatement(PsiIfStatement statement) {
                if (statement.getElseBranch() != null) {
                    return;
                }
                PsiExpression condition = statement.getCondition();
                PsiReferenceExpression value = Java8ReplaceMapGetInspection.getReferenceComparedWithNull(condition);
                if (value == null) {
                    return;
                }
                PsiElement previous = PsiTreeUtil.skipSiblingsBackward(statement, PsiWhiteSpace.class, PsiComment.class);
                PsiMethodCallExpression getCall = Java8ReplaceMapGetInspection.tryExtractMapGetCall(value, previous);
                if (getCall == null) {
                    return;
                }
                PsiExpression[] getArguments = getCall.getArgumentList().getExpressions();
                if (getArguments.length != 1) {
                    return;
                }
                PsiStatement thenBranch = ControlFlowUtils.stripBraces(statement.getThenBranch());
                PsiAssignmentExpression assignment = ExpressionUtils.getAssignment(thenBranch);
                EquivalenceChecker equivalence = EquivalenceChecker.getCanonicalPsiEquivalence();
                if (assignment != null) {
                    if (!Java8ReplaceMapGetInspection.this.mySuggestMapGetOrDefault) {
                        return;
                    }
                    if (ExpressionUtils.isSimpleExpression(assignment.getRExpression()) && equivalence.expressionsAreEquivalent(assignment.getLExpression(), value)) {
                        holder.registerProblem((PsiElement)condition, QuickFixBundle.message("java.8.replace.map.get.inspection.description", new Object[0]), new ReplaceGetNullCheck("getOrDefault"));
                    }
                } else if (thenBranch instanceof PsiBlockStatement) {
                    if (!Java8ReplaceMapGetInspection.this.mySuggestMapComputeIfAbsent) {
                        return;
                    }
                    PsiExpression key = getArguments[0];
                    PsiStatement[] statements = ((PsiBlockStatement)thenBranch).getCodeBlock().getStatements();
                    if (statements.length != 2) {
                        return;
                    }
                    assignment = ExpressionUtils.getAssignment(statements[0]);
                    if (assignment == null) {
                        return;
                    }
                    PsiExpression lambdaCandidate = assignment.getRExpression();
                    if (lambdaCandidate == null || !equivalence.expressionsAreEquivalent(assignment.getLExpression(), value) || !(statements[1] instanceof PsiExpressionStatement)) {
                        return;
                    }
                    PsiExpression expression = ((PsiExpressionStatement)statements[1]).getExpression();
                    if (!(expression instanceof PsiMethodCallExpression)) {
                        return;
                    }
                    PsiMethodCallExpression putCall = (PsiMethodCallExpression)expression;
                    if (!Java8CollectionsApiInspection.isJavaUtilMapMethodWithName(putCall, "put")) {
                        return;
                    }
                    PsiExpression[] putArguments = putCall.getArgumentList().getExpressions();
                    if (!(putArguments.length == 2 && equivalence.expressionsAreEquivalent(putCall.getMethodExpression().getQualifierExpression(), getCall.getMethodExpression().getQualifierExpression()) && equivalence.expressionsAreEquivalent(key, putArguments[0]) && equivalence.expressionsAreEquivalent(value, putArguments[1]))) {
                        return;
                    }
                    if (!ExceptionUtil.getThrownCheckedExceptions(lambdaCandidate).isEmpty()) {
                        return;
                    }
                    if (!PsiTreeUtil.processElements(lambdaCandidate, e -> {
                        if (!(e instanceof PsiReferenceExpression)) {
                            return true;
                        }
                        PsiElement element = ((PsiReferenceExpression)e).resolve();
                        if (!(element instanceof PsiVariable)) {
                            return true;
                        }
                        return HighlightControlFlowUtil.isEffectivelyFinal((PsiVariable)element, lambdaCandidate, null);
                    })) {
                        return;
                    }
                    holder.registerProblem((PsiElement)condition, QuickFixBundle.message("java.8.replace.map.get.inspection.description", new Object[0]), new ReplaceGetNullCheck("computeIfAbsent"));
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/Java8ReplaceMapGetInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @Nullable
    private static PsiReferenceExpression getReferenceComparedWithNull(PsiExpression condition) {
        if (!(condition instanceof PsiBinaryExpression)) {
            return null;
        }
        PsiBinaryExpression binOp = (PsiBinaryExpression)condition;
        if (!binOp.getOperationTokenType().equals(JavaTokenType.EQEQ)) {
            return null;
        }
        PsiExpression value = Java8CollectionsApiInspection.getValueComparedWithNull(binOp);
        if (!(value instanceof PsiReferenceExpression)) {
            return null;
        }
        return (PsiReferenceExpression)value;
    }

    @Nullable
    @Contract(value="_, null -> null")
    static PsiMethodCallExpression tryExtractMapGetCall(PsiReferenceExpression target, PsiElement element) {
        PsiExpression rValue;
        PsiExpression lValue;
        PsiLocalVariable var;
        PsiExpression initializer;
        PsiElement lastDeclaration;
        PsiDeclarationStatement declaration;
        PsiElement[] elements;
        if (element instanceof PsiDeclarationStatement && (elements = (declaration = (PsiDeclarationStatement)element).getDeclaredElements()).length > 0 && (lastDeclaration = elements[elements.length - 1]) instanceof PsiLocalVariable && target.isReferenceTo(lastDeclaration) && (initializer = PsiUtil.skipParenthesizedExprDown((var = (PsiLocalVariable)lastDeclaration).getInitializer())) instanceof PsiMethodCallExpression && Java8CollectionsApiInspection.isJavaUtilMapMethodWithName((PsiMethodCallExpression)initializer, "get")) {
            return (PsiMethodCallExpression)initializer;
        }
        PsiAssignmentExpression assignment = ExpressionUtils.getAssignment(element);
        if (assignment != null && (lValue = assignment.getLExpression()) instanceof PsiReferenceExpression && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(target, lValue) && (rValue = PsiUtil.skipParenthesizedExprDown(assignment.getRExpression())) instanceof PsiMethodCallExpression && Java8CollectionsApiInspection.isJavaUtilMapMethodWithName((PsiMethodCallExpression)rValue, "get")) {
            return (PsiMethodCallExpression)rValue;
        }
        return null;
    }

    private static class ReplaceGetNullCheck
    implements LocalQuickFix {
        private final String myMethodName;

        ReplaceGetNullCheck(String methodName) {
            this.myMethodName = methodName;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = QuickFixBundle.message("java.8.collections.api.inspection.fix.text", this.myMethodName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/Java8ReplaceMapGetInspection$ReplaceGetNullCheck", "getName"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message("java.8.replace.map.get.inspection.fix.family.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/Java8ReplaceMapGetInspection$ReplaceGetNullCheck", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/java18api/Java8ReplaceMapGetInspection$ReplaceGetNullCheck", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/java18api/Java8ReplaceMapGetInspection$ReplaceGetNullCheck", "applyFix"));
            }
            PsiElement element = descriptor.getStartElement();
            PsiIfStatement ifStatement = PsiTreeUtil.getParentOfType(element, PsiIfStatement.class);
            if (ifStatement == null) {
                return;
            }
            PsiReferenceExpression value = Java8ReplaceMapGetInspection.getReferenceComparedWithNull(ifStatement.getCondition());
            if (value == null) {
                return;
            }
            PsiElement statement = PsiTreeUtil.skipSiblingsBackward(ifStatement, PsiWhiteSpace.class, PsiComment.class);
            PsiMethodCallExpression getCall = Java8ReplaceMapGetInspection.tryExtractMapGetCall(value, statement);
            if (getCall == null || !Java8CollectionsApiInspection.isJavaUtilMapMethodWithName(getCall, "get")) {
                return;
            }
            PsiElement nameElement = getCall.getMethodExpression().getReferenceNameElement();
            if (nameElement == null) {
                return;
            }
            PsiExpression[] args = getCall.getArgumentList().getExpressions();
            if (args.length != 1) {
                return;
            }
            PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
            List<PsiComment> comments = ContainerUtil.map(PsiTreeUtil.findChildrenOfType(ifStatement, PsiComment.class), comment -> (PsiComment)comment.copy());
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
            if (thenBranch instanceof PsiExpressionStatement) {
                PsiExpression expression = ((PsiExpressionStatement)thenBranch).getExpression();
                if (!(expression instanceof PsiAssignmentExpression)) {
                    return;
                }
                PsiExpression defaultValue = ((PsiAssignmentExpression)expression).getRExpression();
                if (!ExpressionUtils.isSimpleExpression(defaultValue)) {
                    return;
                }
                if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                    return;
                }
                nameElement.replace(factory.createIdentifier("getOrDefault"));
                getCall.getArgumentList().add(defaultValue);
            } else if (thenBranch instanceof PsiBlockStatement) {
                PsiStatement[] statements = ((PsiBlockStatement)thenBranch).getCodeBlock().getStatements();
                if (statements.length != 2) {
                    return;
                }
                PsiAssignmentExpression assignment = ExpressionUtils.getAssignment(statements[0]);
                if (assignment == null) {
                    return;
                }
                PsiExpression lambdaCandidate = assignment.getRExpression();
                if (lambdaCandidate == null) {
                    return;
                }
                if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                    return;
                }
                nameElement.replace(factory.createIdentifier("computeIfAbsent"));
                String varName = JavaCodeStyleManager.getInstance(project).suggestUniqueVariableName("k", (PsiElement)lambdaCandidate, true);
                PsiExpression lambda2 = factory.createExpressionFromText(varName + " -> " + lambdaCandidate.getText(), lambdaCandidate);
                getCall.getArgumentList().add(lambda2);
            } else {
                return;
            }
            ifStatement.delete();
            CodeStyleManager.getInstance(project).reformat(statement);
            comments.forEach(comment -> statement.getParent().addBefore((PsiElement)comment, statement));
        }
    }
}

