/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.lexer.LexerPosition;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ImmutableUserMap;
import com.intellij.util.containers.Queue;
import org.jetbrains.annotations.NotNull;

public abstract class LookAheadLexer
extends LexerBase {
    private int myLastOffset;
    private int myLastState;
    private final Lexer myBaseLexer;
    private int myTokenStart;
    private final Queue<IElementType> myTypeCache;
    private final Queue<Integer> myEndOffsetCache;

    public LookAheadLexer(@NotNull Lexer baseLexer, int capacity) {
        if (baseLexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseLexer", "com/intellij/lexer/LookAheadLexer", "<init>"));
        }
        this.myBaseLexer = baseLexer;
        this.myTypeCache = new Queue(capacity);
        this.myEndOffsetCache = new Queue(capacity);
    }

    public LookAheadLexer(@NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseLexer", "com/intellij/lexer/LookAheadLexer", "<init>"));
        }
        this(baseLexer, 64);
    }

    protected void addToken(IElementType type) {
        this.addToken(this.myBaseLexer.getTokenEnd(), type);
    }

    protected void addToken(int endOffset, IElementType type) {
        this.myTypeCache.addLast(type);
        this.myEndOffsetCache.addLast(endOffset);
    }

    protected void lookAhead(@NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseLexer", "com/intellij/lexer/LookAheadLexer", "lookAhead"));
        }
        this.advanceLexer(baseLexer);
    }

    @Override
    public void advance() {
        if (!this.myTypeCache.isEmpty()) {
            this.myTypeCache.pullFirst();
            this.myTokenStart = this.myEndOffsetCache.pullFirst();
        }
        if (this.myTypeCache.isEmpty()) {
            this.doLookAhead();
        }
    }

    private void doLookAhead() {
        this.myLastOffset = this.myTokenStart;
        this.myLastState = this.myBaseLexer.getState();
        this.lookAhead(this.myBaseLexer);
        assert (!this.myTypeCache.isEmpty());
    }

    @Override
    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBaseLexer.getBufferSequence();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lexer/LookAheadLexer", "getBufferSequence"));
        }
        return charSequence;
    }

    @Override
    public int getBufferEnd() {
        return this.myBaseLexer.getBufferEnd();
    }

    protected int getCacheSize() {
        return this.myTypeCache.size();
    }

    protected void resetCacheSize(int size) {
        while (this.myTypeCache.size() > size) {
            this.myTypeCache.removeLast();
            this.myEndOffsetCache.removeLast();
        }
    }

    public IElementType replaceCachedType(int index, IElementType token) {
        return this.myTypeCache.set(index, token);
    }

    @Override
    public int getState() {
        int offset = this.myTokenStart - this.myLastOffset;
        return this.myLastState | offset << 16;
    }

    @Override
    public int getTokenEnd() {
        return this.myEndOffsetCache.peekFirst();
    }

    @Override
    public int getTokenStart() {
        return this.myTokenStart;
    }

    @Override
    @NotNull
    public LookAheadLexerPosition getCurrentPosition() {
        LookAheadLexerPosition lookAheadLexerPosition = new LookAheadLexerPosition(this, ImmutableUserMap.EMPTY);
        if (lookAheadLexerPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lexer/LookAheadLexer", "getCurrentPosition"));
        }
        return lookAheadLexerPosition;
    }

    @Override
    public final void restore(@NotNull LexerPosition _position) {
        if (_position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_position", "com/intellij/lexer/LookAheadLexer", "restore"));
        }
        this.restore((LookAheadLexerPosition)_position);
    }

    protected void restore(LookAheadLexerPosition position) {
        this.start(this.myBaseLexer.getBufferSequence(), position.lastOffset, this.myBaseLexer.getBufferEnd(), position.lastState);
        for (int i2 = 0; i2 < position.advanceCount; ++i2) {
            this.advance();
        }
    }

    @Override
    public IElementType getTokenType() {
        return this.myTypeCache.peekFirst();
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/lexer/LookAheadLexer", "start"));
        }
        this.myBaseLexer.start(buffer, startOffset, endOffset, initialState & 0xFFFF);
        this.myTokenStart = startOffset;
        this.myTypeCache.clear();
        this.myEndOffsetCache.clear();
        this.doLookAhead();
    }

    protected final void advanceLexer(Lexer lexer) {
        this.advanceAs(lexer, lexer.getTokenType());
    }

    protected final void advanceAs(Lexer lexer, IElementType type) {
        this.addToken(type);
        lexer.advance();
    }

    protected static class LookAheadLexerPosition
    implements LexerPosition {
        final int lastOffset;
        final int lastState;
        final int tokenStart;
        final int advanceCount;
        final ImmutableUserMap customMap;

        public LookAheadLexerPosition(LookAheadLexer lookAheadLexer, ImmutableUserMap map) {
            this.customMap = map;
            this.lastOffset = lookAheadLexer.myLastOffset;
            this.lastState = lookAheadLexer.myLastState;
            this.tokenStart = lookAheadLexer.myTokenStart;
            this.advanceCount = lookAheadLexer.myTypeCache.size() - 1;
        }

        public ImmutableUserMap getCustomMap() {
            return this.customMap;
        }

        @Override
        public int getOffset() {
            return this.tokenStart;
        }

        @Override
        public int getState() {
            return this.lastState;
        }
    }
}

