/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.reflect.ConstructorAccessor;

public class ReflectionUtil {
    private static final Logger LOG;
    private static final Method acquireConstructorAccessorMethod;
    private static final Method getConstructorAccessorMethod;
    private static final Function<Class, Iterable<Class>> CLASS_STRUCTURE;

    private ReflectionUtil() {
    }

    @Nullable
    public static Type resolveVariable(@NotNull TypeVariable variable, @NotNull Class classType) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/util/ReflectionUtil", "resolveVariable"));
        }
        if (classType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "com/intellij/util/ReflectionUtil", "resolveVariable"));
        }
        return ReflectionUtil.resolveVariable(variable, classType, true);
    }

    @Nullable
    public static Type resolveVariable(@NotNull TypeVariable variable, @NotNull Class classType, boolean resolveInInterfacesOnly) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/util/ReflectionUtil", "resolveVariable"));
        }
        if (classType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "com/intellij/util/ReflectionUtil", "resolveVariable"));
        }
        Class<?> aClass = ReflectionUtil.getRawType(classType);
        int index = ArrayUtilRt.find(aClass.getTypeParameters(), variable);
        if (index >= 0) {
            return variable;
        }
        Class<?>[] classes = aClass.getInterfaces();
        Type[] genericInterfaces = aClass.getGenericInterfaces();
        for (int i2 = 0; i2 <= classes.length; ++i2) {
            Type type;
            Class<?> anInterface;
            if (i2 < classes.length) {
                anInterface = classes[i2];
            } else {
                anInterface = aClass.getSuperclass();
                if (resolveInInterfacesOnly || anInterface == null) continue;
            }
            Type resolved = ReflectionUtil.resolveVariable(variable, anInterface);
            if (resolved instanceof Class || resolved instanceof ParameterizedType) {
                return resolved;
            }
            if (!(resolved instanceof TypeVariable)) continue;
            TypeVariable typeVariable = (TypeVariable)resolved;
            index = ArrayUtilRt.find(anInterface.getTypeParameters(), typeVariable);
            if (index < 0) {
                LOG.error("Cannot resolve type variable:\ntypeVariable = " + typeVariable + "\ngenericDeclaration = " + ReflectionUtil.declarationToString(typeVariable.getGenericDeclaration()) + "\nsearching in " + ReflectionUtil.declarationToString(anInterface));
            }
            Type type2 = type = i2 < genericInterfaces.length ? genericInterfaces[i2] : aClass.getGenericSuperclass();
            if (type instanceof Class) {
                return Object.class;
            }
            if (type instanceof ParameterizedType) {
                return ReflectionUtil.getActualTypeArguments((ParameterizedType)type)[index];
            }
            throw new AssertionError((Object)("Invalid type: " + type));
        }
        return null;
    }

    @NotNull
    public static String declarationToString(@NotNull GenericDeclaration anInterface) {
        if (anInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anInterface", "com/intellij/util/ReflectionUtil", "declarationToString"));
        }
        String string = anInterface.toString() + Arrays.asList(anInterface.getTypeParameters()) + " loaded by " + ((Class)anInterface).getClassLoader();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "declarationToString"));
        }
        return string;
    }

    @NotNull
    public static Class<?> getRawType(@NotNull Type type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/ReflectionUtil", "getRawType"));
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "getRawType"));
            }
            return clazz;
        }
        if (type instanceof ParameterizedType) {
            Class<?> clazz = ReflectionUtil.getRawType(((ParameterizedType)type).getRawType());
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "getRawType"));
            }
            return clazz;
        }
        if (type instanceof GenericArrayType) {
            Class<?> clazz = Array.newInstance(ReflectionUtil.getRawType(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "getRawType"));
            }
            return clazz;
        }
        assert (false) : type;
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "getRawType"));
        }
        return null;
    }

    @NotNull
    public static Type[] getActualTypeArguments(@NotNull ParameterizedType parameterizedType) {
        if (parameterizedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterizedType", "com/intellij/util/ReflectionUtil", "getActualTypeArguments"));
        }
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        if (typeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "getActualTypeArguments"));
        }
        return typeArray;
    }

    @Nullable
    public static Class<?> substituteGenericType(@NotNull Type genericType, @NotNull Type classType) {
        if (genericType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericType", "com/intellij/util/ReflectionUtil", "substituteGenericType"));
        }
        if (classType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "com/intellij/util/ReflectionUtil", "substituteGenericType"));
        }
        if (genericType instanceof TypeVariable) {
            int index;
            Class<?> aClass = ReflectionUtil.getRawType(classType);
            Type type = ReflectionUtil.resolveVariable((TypeVariable)genericType, aClass);
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof TypeVariable && classType instanceof ParameterizedType && (index = ArrayUtilRt.find(aClass.getTypeParameters(), type)) >= 0) {
                return ReflectionUtil.getRawType(ReflectionUtil.getActualTypeArguments((ParameterizedType)classType)[index]);
            }
        } else {
            return ReflectionUtil.getRawType(genericType);
        }
        return null;
    }

    @NotNull
    public static List<Field> collectFields(@NotNull Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/util/ReflectionUtil", "collectFields"));
        }
        ArrayList<Field> result = new ArrayList<Field>();
        ReflectionUtil.collectFields(clazz, result);
        ArrayList<Field> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "collectFields"));
        }
        return arrayList;
    }

    @NotNull
    public static Field findField(@NotNull Class clazz, final @Nullable Class type, final @NotNull String name) throws NoSuchFieldException {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/util/ReflectionUtil", "findField"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ReflectionUtil", "findField"));
        }
        Field result = ReflectionUtil.processFields(clazz, new Condition<Field>(){

            @Override
            public boolean value(Field field) {
                return name.equals(field.getName()) && (type == null || field.getType().equals(type));
            }
        });
        if (result != null) {
            Field field = result;
            if (field == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "findField"));
            }
            return field;
        }
        throw new NoSuchFieldException("Class: " + clazz + " name: " + name + " type: " + type);
    }

    @NotNull
    public static Field findAssignableField(@NotNull Class<?> clazz, final @Nullable(value="null means any type") Class<?> fieldType, final @NotNull String fieldName) throws NoSuchFieldException {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/util/ReflectionUtil", "findAssignableField"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/util/ReflectionUtil", "findAssignableField"));
        }
        Field result = ReflectionUtil.processFields(clazz, new Condition<Field>(){

            @Override
            public boolean value(Field field) {
                return fieldName.equals(field.getName()) && (fieldType == null || fieldType.isAssignableFrom(field.getType()));
            }
        });
        if (result != null) {
            Field field = result;
            if (field == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "findAssignableField"));
            }
            return field;
        }
        throw new NoSuchFieldException("Class: " + clazz + " fieldName: " + fieldName + " fieldType: " + fieldType);
    }

    private static void collectFields(@NotNull Class clazz, @NotNull List<Field> result) {
        Class<?>[] interfaces;
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/util/ReflectionUtil", "collectFields"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/ReflectionUtil", "collectFields"));
        }
        List<Field> fields = ReflectionUtil.getClassDeclaredFields(clazz);
        result.addAll(fields);
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            ReflectionUtil.collectFields(superClass, result);
        }
        for (Class<?> each : interfaces = clazz.getInterfaces()) {
            ReflectionUtil.collectFields(each, result);
        }
    }

    private static Field processFields(@NotNull Class clazz, @NotNull Condition<Field> checker) {
        Class<?>[] interfaces;
        Field result;
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/util/ReflectionUtil", "processFields"));
        }
        if (checker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checker", "com/intellij/util/ReflectionUtil", "processFields"));
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!checker.value(field)) continue;
            field.setAccessible(true);
            return field;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && (result = ReflectionUtil.processFields(superClass, checker)) != null) {
            return result;
        }
        for (Class<?> each : interfaces = clazz.getInterfaces()) {
            Field result2 = ReflectionUtil.processFields(each, checker);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    public static void resetField(@NotNull Class clazz, @Nullable(value="null means of any type") Class type, @NotNull String name) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/util/ReflectionUtil", "resetField"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ReflectionUtil", "resetField"));
        }
        try {
            ReflectionUtil.resetField(null, ReflectionUtil.findField(clazz, type, name));
        }
        catch (NoSuchFieldException e) {
            LOG.info(e);
        }
    }

    public static void resetField(@NotNull Object object, @Nullable(value="null means any type") Class type, @NotNull String name) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/ReflectionUtil", "resetField"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ReflectionUtil", "resetField"));
        }
        try {
            ReflectionUtil.resetField(object, ReflectionUtil.findField(object.getClass(), type, name));
        }
        catch (NoSuchFieldException e) {
            LOG.info(e);
        }
    }

    public static void resetField(@NotNull Object object, @NotNull String name) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/ReflectionUtil", "resetField"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ReflectionUtil", "resetField"));
        }
        try {
            ReflectionUtil.resetField(object, ReflectionUtil.findField(object.getClass(), null, name));
        }
        catch (NoSuchFieldException e) {
            LOG.info(e);
        }
    }

    public static void resetField(@Nullable Object object, @NotNull Field field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/util/ReflectionUtil", "resetField"));
        }
        field.setAccessible(true);
        Class<?> type = field.getType();
        try {
            if (type.isPrimitive()) {
                if (Boolean.TYPE.equals(type)) {
                    field.set(object, Boolean.FALSE);
                } else if (Integer.TYPE.equals(type)) {
                    field.set(object, 0);
                } else if (Double.TYPE.equals(type)) {
                    field.set(object, 0.0);
                } else if (Float.TYPE.equals(type)) {
                    field.set(object, Float.valueOf(0.0f));
                }
            } else {
                field.set(object, null);
            }
        }
        catch (IllegalAccessException e) {
            LOG.info(e);
        }
    }

    public static void resetStaticField(@NotNull Class aClass, @NotNull @NonNls String name) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "resetStaticField"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ReflectionUtil", "resetStaticField"));
        }
        ReflectionUtil.resetField(aClass, null, name);
    }

    @Nullable
    public static Method findMethod(@NotNull Collection<Method> methods, @NonNls @NotNull String name, Class ... parameters) {
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "com/intellij/util/ReflectionUtil", "findMethod"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ReflectionUtil", "findMethod"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/util/ReflectionUtil", "findMethod"));
        }
        for (Method method : methods) {
            if (!name.equals(method.getName()) || !Arrays.equals(parameters, method.getParameterTypes())) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    @Nullable
    public static Method getMethod(@NotNull Class aClass, @NonNls @NotNull String name, Class ... parameters) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "getMethod"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ReflectionUtil", "getMethod"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/util/ReflectionUtil", "getMethod"));
        }
        return ReflectionUtil.findMethod(ReflectionUtil.getClassPublicMethods(aClass, false), name, parameters);
    }

    @Nullable
    public static Method getDeclaredMethod(@NotNull Class aClass, @NonNls @NotNull String name, Class ... parameters) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "getDeclaredMethod"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ReflectionUtil", "getDeclaredMethod"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/util/ReflectionUtil", "getDeclaredMethod"));
        }
        return ReflectionUtil.findMethod(ReflectionUtil.getClassDeclaredMethods(aClass, false), name, parameters);
    }

    @Nullable
    public static Field getDeclaredField(@NotNull Class aClass, final @NonNls @NotNull String name) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "getDeclaredField"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ReflectionUtil", "getDeclaredField"));
        }
        return ReflectionUtil.processFields(aClass, new Condition<Field>(){

            @Override
            public boolean value(Field field) {
                return name.equals(field.getName());
            }
        });
    }

    @NotNull
    public static List<Method> getClassPublicMethods(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "getClassPublicMethods"));
        }
        List<Method> list = ReflectionUtil.getClassPublicMethods(aClass, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "getClassPublicMethods"));
        }
        return list;
    }

    @NotNull
    public static List<Method> getClassPublicMethods(@NotNull Class aClass, boolean includeSynthetic) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "getClassPublicMethods"));
        }
        Method[] methods = aClass.getMethods();
        List<Method> list = includeSynthetic ? Arrays.asList(methods) : ReflectionUtil.filterRealMethods(methods);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "getClassPublicMethods"));
        }
        return list;
    }

    @NotNull
    public static List<Method> getClassDeclaredMethods(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "getClassDeclaredMethods"));
        }
        List<Method> list = ReflectionUtil.getClassDeclaredMethods(aClass, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "getClassDeclaredMethods"));
        }
        return list;
    }

    @NotNull
    public static List<Method> getClassDeclaredMethods(@NotNull Class aClass, boolean includeSynthetic) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "getClassDeclaredMethods"));
        }
        Method[] methods = aClass.getDeclaredMethods();
        List<Method> list = includeSynthetic ? Arrays.asList(methods) : ReflectionUtil.filterRealMethods(methods);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "getClassDeclaredMethods"));
        }
        return list;
    }

    @NotNull
    public static List<Field> getClassDeclaredFields(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "getClassDeclaredFields"));
        }
        Field[] fields = aClass.getDeclaredFields();
        List<Field> list = Arrays.asList(fields);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "getClassDeclaredFields"));
        }
        return list;
    }

    @NotNull
    private static List<Method> filterRealMethods(@NotNull Method[] methods) {
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "com/intellij/util/ReflectionUtil", "filterRealMethods"));
        }
        ArrayList<Method> result = ContainerUtil.newArrayList();
        for (Method method : methods) {
            if (method.isSynthetic()) continue;
            result.add(method);
        }
        ArrayList<Method> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "filterRealMethods"));
        }
        return arrayList;
    }

    @Nullable
    public static Class getMethodDeclaringClass(@NotNull Class<?> instanceClass, @NonNls @NotNull String methodName, Class ... parameters) {
        if (instanceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceClass", "com/intellij/util/ReflectionUtil", "getMethodDeclaringClass"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/util/ReflectionUtil", "getMethodDeclaringClass"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/util/ReflectionUtil", "getMethodDeclaringClass"));
        }
        Method method = ReflectionUtil.getMethod(instanceClass, methodName, parameters);
        return method == null ? null : method.getDeclaringClass();
    }

    public static <T> T getField(@NotNull Class objectClass, @Nullable Object object, @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName) {
        if (objectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectClass", "com/intellij/util/ReflectionUtil", "getField"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/util/ReflectionUtil", "getField"));
        }
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            Object t = field.get(object);
            return (T)t;
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.debug(e);
            return null;
        }
    }

    public static <T> T getStaticFieldValue(@NotNull Class objectClass, @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName) {
        if (objectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectClass", "com/intellij/util/ReflectionUtil", "getStaticFieldValue"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/util/ReflectionUtil", "getStaticFieldValue"));
        }
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new IllegalArgumentException("Field " + objectClass + "." + fieldName + " is not static");
            }
            Object t = field.get(null);
            return (T)t;
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.debug(e);
            return null;
        }
    }

    public static <T> boolean setField(@NotNull Class objectClass, Object object, @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName, T value) {
        if (objectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectClass", "com/intellij/util/ReflectionUtil", "setField"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/util/ReflectionUtil", "setField"));
        }
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            field.set(object, value);
            return true;
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return false;
        }
        catch (IllegalAccessException e) {
            LOG.debug(e);
            return false;
        }
    }

    public static Type resolveVariableInHierarchy(@NotNull TypeVariable variable, @NotNull Class aClass) {
        Type type;
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/util/ReflectionUtil", "resolveVariableInHierarchy"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "resolveVariableInHierarchy"));
        }
        Class current = aClass;
        while ((type = ReflectionUtil.resolveVariable(variable, current, false)) == null) {
            if ((current = current.getSuperclass()) != null) continue;
            return null;
        }
        if (type instanceof TypeVariable) {
            return ReflectionUtil.resolveVariableInHierarchy((TypeVariable)type, aClass);
        }
        return type;
    }

    @NotNull
    public static <T> Constructor<T> getDefaultConstructor(@NotNull Class<T> aClass) {
        Constructor<T> constructor;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "getDefaultConstructor"));
        }
        try {
            Constructor<T> constructor2 = aClass.getConstructor(new Class[0]);
            constructor2.setAccessible(true);
            constructor = constructor2;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No default constructor in " + aClass, e);
        }
        if (constructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "getDefaultConstructor"));
        }
        return constructor;
    }

    public static ConstructorAccessor getConstructorAccessor(@NotNull Constructor constructor) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/util/ReflectionUtil", "getConstructorAccessor"));
        }
        if (acquireConstructorAccessorMethod == null || getConstructorAccessorMethod == null) {
            throw new IllegalStateException();
        }
        constructor.setAccessible(true);
        try {
            acquireConstructorAccessorMethod.invoke((Object)constructor, new Object[0]);
            return (ConstructorAccessor)getConstructorAccessorMethod.invoke((Object)constructor, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T createInstanceViaConstructorAccessor(@NotNull ConstructorAccessor constructorAccessor, Object ... arguments) {
        if (constructorAccessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorAccessor", "com/intellij/util/ReflectionUtil", "createInstanceViaConstructorAccessor"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/util/ReflectionUtil", "createInstanceViaConstructorAccessor"));
        }
        try {
            Object t = constructorAccessor.newInstance(arguments);
            return (T)t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T createInstanceViaConstructorAccessor(@NotNull ConstructorAccessor constructorAccessor) {
        if (constructorAccessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorAccessor", "com/intellij/util/ReflectionUtil", "createInstanceViaConstructorAccessor"));
        }
        try {
            Object t = constructorAccessor.newInstance(ArrayUtil.EMPTY_OBJECT_ARRAY);
            return (T)t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static <T> T newInstance(@NotNull Class<T> aClass) {
        Constructor<T> constructor;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "newInstance"));
        }
        try {
            constructor = aClass.getDeclaredConstructor(new Class[0]);
            try {
                constructor.setAccessible(true);
            }
            catch (SecurityException e) {
                T t = aClass.newInstance();
                if (t == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "newInstance"));
                }
                return t;
            }
        }
        catch (Exception e) {
            for (Annotation annotation : aClass.getAnnotations()) {
                String name = annotation.annotationType().getName();
                if (!name.equals("kotlin.Metadata") && !name.equals("kotlin.jvm.internal.KotlinClass")) continue;
                Constructor<?>[] constructors = aClass.getDeclaredConstructors();
                Exception exception = e;
                block10: for (Constructor<?> constructor1 : constructors) {
                    Object obj;
                    try {
                        Object t;
                        Class<?>[] parameterTypes;
                        try {
                            constructor1.setAccessible(true);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        for (Class<?> type : parameterTypes = constructor1.getParameterTypes()) {
                            if (type.getName().equals("kotlin.jvm.internal.DefaultConstructorMarker")) continue block10;
                        }
                        obj = t = constructor1.newInstance(new Object[parameterTypes.length]);
                    }
                    catch (Exception e1) {
                        exception = e1;
                    }
                    if (obj == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "newInstance"));
                    }
                    return (T)obj;
                }
                throw new RuntimeException(exception);
            }
            throw new RuntimeException(e);
        }
        T t = constructor.newInstance(new Object[0]);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "newInstance"));
        }
        return t;
    }

    @NotNull
    public static <T> T createInstance(@NotNull Constructor<T> constructor, Object ... args) {
        T t;
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/util/ReflectionUtil", "createInstance"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/util/ReflectionUtil", "createInstance"));
        }
        try {
            t = constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "createInstance"));
        }
        return t;
    }

    @Nullable
    public static Class getGrandCallerClass() {
        int stackFrameCount = 3;
        Class callerClass = ReflectionUtil.findCallerClass(stackFrameCount);
        while (callerClass != null && callerClass.getClassLoader() == null) {
            callerClass = ReflectionUtil.findCallerClass(++stackFrameCount);
        }
        if (callerClass == null) {
            callerClass = ReflectionUtil.findCallerClass(2);
        }
        return callerClass;
    }

    public static void copyFields(@NotNull Field[] fields, @NotNull Object from, @NotNull Object to) {
        if (fields == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fields", "com/intellij/util/ReflectionUtil", "copyFields"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/util/ReflectionUtil", "copyFields"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/util/ReflectionUtil", "copyFields"));
        }
        ReflectionUtil.copyFields(fields, from, to, null);
    }

    public static boolean copyFields(@NotNull Field[] fields, @NotNull Object from, @NotNull Object to, @Nullable DifferenceFilter diffFilter) {
        if (fields == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fields", "com/intellij/util/ReflectionUtil", "copyFields"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/util/ReflectionUtil", "copyFields"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/util/ReflectionUtil", "copyFields"));
        }
        HashSet<Field> sourceFields = ContainerUtil.newHashSet(from.getClass().getFields());
        boolean valuesChanged = false;
        for (Field field : fields) {
            if (!sourceFields.contains(field) || !ReflectionUtil.isPublic(field) || ReflectionUtil.isFinal(field)) continue;
            try {
                if (diffFilter != null && !diffFilter.isAccept(field)) continue;
                ReflectionUtil.copyFieldValue(from, to, field);
                valuesChanged = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return valuesChanged;
    }

    public static void copyFieldValue(@NotNull Object from, @NotNull Object to, @NotNull Field field) throws IllegalAccessException {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/util/ReflectionUtil", "copyFieldValue"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/util/ReflectionUtil", "copyFieldValue"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/util/ReflectionUtil", "copyFieldValue"));
        }
        Class<?> fieldType = field.getType();
        if (!(fieldType.isPrimitive() || fieldType.equals(String.class) || fieldType.isEnum())) {
            throw new RuntimeException("Field '" + field.getName() + "' not copied: unsupported type: " + field.getType());
        }
        field.set(to, field.get(from));
    }

    private static boolean isPublic(Field field) {
        return (field.getModifiers() & 1) != 0;
    }

    private static boolean isFinal(Field field) {
        return (field.getModifiers() & 0x10) != 0;
    }

    @NotNull
    public static Class forName(@NotNull String fqn) {
        Class<?> clazz;
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "com/intellij/util/ReflectionUtil", "forName"));
        }
        try {
            clazz = Class.forName(fqn);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "forName"));
        }
        return clazz;
    }

    @Nullable
    public static Class findCallerClass(int framesToSkip) {
        try {
            Class[] stack = MySecurityManager.INSTANCE.getStack();
            int indexFromTop = 1 + framesToSkip;
            return stack.length > indexFromTop ? stack[indexFromTop] : null;
        }
        catch (Exception e) {
            LOG.warn(e);
            return null;
        }
    }

    public static boolean isAssignable(@NotNull Class<?> ancestor, @NotNull Class<?> descendant) {
        if (ancestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestor", "com/intellij/util/ReflectionUtil", "isAssignable"));
        }
        if (descendant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descendant", "com/intellij/util/ReflectionUtil", "isAssignable"));
        }
        return ancestor == descendant || ancestor.isAssignableFrom(descendant);
    }

    @NotNull
    public static JBTreeTraverser<Class> classTraverser(@Nullable Class root) {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)((JBTreeTraverser)new JBTreeTraverser<Class>(CLASS_STRUCTURE).unique()).withRoot(root);
        if (jBTreeTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "classTraverser"));
        }
        return jBTreeTraverser;
    }

    static {
        Method getMethod;
        Method acquireMethod;
        LOG = Logger.getInstance("#com.intellij.util.ReflectionUtil");
        try {
            acquireMethod = ReflectionUtil.getDeclaredMethod(Constructor.class, "acquireConstructorAccessor", new Class[0]);
            getMethod = ReflectionUtil.getDeclaredMethod(Constructor.class, "getConstructorAccessor", new Class[0]);
        }
        catch (Throwable ignore) {
            getMethod = null;
            acquireMethod = null;
        }
        acquireConstructorAccessorMethod = acquireMethod;
        getConstructorAccessorMethod = getMethod;
        CLASS_STRUCTURE = new Function<Class, Iterable<Class>>(){

            @Override
            public Iterable<Class> fun(Class aClass) {
                return JBIterable.of(aClass.getSuperclass()).append(aClass.getInterfaces());
            }
        };
    }

    private static class MySecurityManager
    extends SecurityManager {
        private static final MySecurityManager INSTANCE = new MySecurityManager();

        private MySecurityManager() {
        }

        public Class[] getStack() {
            return this.getClassContext();
        }
    }
}

