/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OptionalGetWithoutIsPresentInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("optional.get.without.is.present.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/OptionalGetWithoutIsPresentInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String string = InspectionGadgetsBundle.message("optional.get.without.is.present.problem.descriptor", aClass.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/OptionalGetWithoutIsPresentInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OptionalGetWithoutIsPresentVisitor();
    }

    private static class OptionalGetWithoutIsPresentVisitor
    extends BaseInspectionVisitor {
        private OptionalGetWithoutIsPresentVisitor() {
        }

        @Override
        public void visitMethod(PsiMethod method) {
            this.check(method.getBody());
        }

        @Override
        public void visitClassInitializer(PsiClassInitializer initializer) {
            this.check(initializer.getBody());
        }

        @Override
        public void visitField(PsiField field) {
            this.check(field.getInitializer());
        }

        private void check(PsiElement element) {
            if (!OptionalGetWithoutIsPresentVisitor.containsOptionalGetCall(element)) {
                return;
            }
            StandardDataFlowRunner dfaRunner = new StandardDataFlowRunner(false, true, this.isOnTheFly());
            dfaRunner.analyzeMethod(element, new InstructionVisitor(){

                @Override
                public DfaInstructionState[] visitAssign(AssignInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
                    DfaVariableValue var;
                    PsiModifierListOwner psi;
                    DfaValue dfaSource = memState.pop();
                    DfaValue dfaDest = memState.pop();
                    if (!(!(dfaDest instanceof DfaVariableValue) || (psi = (var = (DfaVariableValue)dfaDest).getPsiVariable()) instanceof PsiField && psi.hasModifierProperty("volatile"))) {
                        memState.setVarValue(var, dfaSource);
                    }
                    memState.push(dfaDest);
                    return 1.nextInstruction(instruction, runner, memState);
                }

                @Override
                public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
                    PsiClass aClass;
                    DfaInstructionState[] states = super.visitMethodCall(instruction, runner, memState);
                    PsiMethod targetMethod = instruction.getTargetMethod();
                    if (targetMethod != null && TypeUtils.isOptional(aClass = targetMethod.getContainingClass())) {
                        PsiMethodCallExpression methodCallExpression;
                        String name = targetMethod.getName();
                        if (name.equals("isPresent")) {
                            memState.pop();
                            memState.push(runner.getFactory().getConstFactory().getFalse());
                        } else if ((name.equals("get") || name.equals("getAsDouble") || name.equals("getAsInt") || name.equals("getAsLong")) && (methodCallExpression = (PsiMethodCallExpression)instruction.getCallExpression()) != null) {
                            this.registerMethodCallError(methodCallExpression, new Object[]{aClass});
                        }
                    }
                    return states;
                }
            });
        }

        private static boolean containsOptionalGetCall(PsiElement element) {
            if (element == null) {
                return false;
            }
            OptionalGetCallChecker checker = new OptionalGetCallChecker();
            element.acceptChildren(checker);
            return checker.containsOptionalGetCall();
        }

        private static class OptionalGetCallChecker
        extends JavaRecursiveElementWalkingVisitor {
            private boolean result = false;

            private OptionalGetCallChecker() {
            }

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                if (this.result) {
                    return;
                }
                super.visitMethodCallExpression(expression);
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                String name = methodExpression.getReferenceName();
                if (!("get".equals(name) || "getAsDouble".equals(name) || "getAsInt".equals(name) || "getAsLong".equals(name))) {
                    return;
                }
                PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
                if (qualifier == null) {
                    return;
                }
                PsiType type = qualifier.getType();
                if (!TypeUtils.isOptional(type)) {
                    return;
                }
                this.result = true;
            }

            public boolean containsOptionalGetCall() {
                return this.result;
            }
        }
    }
}

