/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.NamedFoldingDescriptor;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ParameterNameFoldingManager {
    private static final List<Couple<String>> COMMONLY_USED_PARAMETER_PAIR = ContainerUtil.newArrayList(new Couple[]{Couple.of("begin", "end"), Couple.of("start", "end"), Couple.of("first", "last"), Couple.of("first", "second"), Couple.of("from", "to"), Couple.of("key", "value"), Couple.of("min", "max")});
    @NotNull
    private final List<FoldingDescriptor> myDescriptors;

    ParameterNameFoldingManager(@NotNull PsiCallExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/codeInsight/folding/impl/ParameterNameFoldingManager", "<init>"));
        }
        PsiExpression[] callArguments = ParameterNameFoldingManager.getArguments(callExpression);
        JavaResolveResult resolveResult = callExpression.resolveMethodGenerics();
        JavaCodeFoldingSettings settings = JavaCodeFoldingSettings.getInstance();
        List<Object> descriptors = Collections.emptyList();
        if (callArguments.length >= settings.getInlineLiteralParameterMinArgumentsToFold() && ParameterNameFoldingManager.hasLiteralExpression(callArguments) && resolveResult.getElement() instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolveResult.getElement();
            PsiParameter[] parameters = method.getParameterList().getParameters();
            descriptors = ParameterNameFoldingManager.buildDescriptorsForLiteralArguments(callArguments, parameters, resolveResult);
        }
        this.myDescriptors = descriptors;
    }

    static boolean isLiteralExpression(@Nullable PsiElement callArgument) {
        if (callArgument instanceof PsiLiteralExpression) {
            return true;
        }
        if (callArgument instanceof PsiPrefixExpression) {
            PsiPrefixExpression expr = (PsiPrefixExpression)callArgument;
            IElementType tokenType = expr.getOperationTokenType();
            return (JavaTokenType.MINUS.equals(tokenType) || JavaTokenType.PLUS.equals(tokenType)) && expr.getOperand() instanceof PsiLiteralExpression;
        }
        return false;
    }

    @NotNull
    private static PsiExpression[] getArguments(@NotNull PsiCallExpression call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInsight/folding/impl/ParameterNameFoldingManager", "getArguments"));
        }
        PsiExpressionList callArgumentsList = call.getArgumentList();
        PsiExpression[] psiExpressionArray = callArgumentsList == null ? PsiExpression.EMPTY_ARRAY : callArgumentsList.getExpressions();
        if (psiExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/folding/impl/ParameterNameFoldingManager", "getArguments"));
        }
        return psiExpressionArray;
    }

    @NotNull
    List<FoldingDescriptor> getDescriptors() {
        List<FoldingDescriptor> list = this.myDescriptors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/folding/impl/ParameterNameFoldingManager", "getDescriptors"));
        }
        return list;
    }

    @NotNull
    private static List<FoldingDescriptor> buildDescriptorsForLiteralArguments(@NotNull PsiExpression[] callArguments, @NotNull PsiParameter[] parameters, @NotNull JavaResolveResult resolveResult) {
        if (callArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callArguments", "com/intellij/codeInsight/folding/impl/ParameterNameFoldingManager", "buildDescriptorsForLiteralArguments"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/folding/impl/ParameterNameFoldingManager", "buildDescriptorsForLiteralArguments"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/codeInsight/folding/impl/ParameterNameFoldingManager", "buildDescriptorsForLiteralArguments"));
        }
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
        int i = 0;
        while (i < callArguments.length && i < parameters.length) {
            if (i + 1 < callArguments.length && ParameterNameFoldingManager.isCommonlyNamedParameterPair(i, i + 1, parameters)) {
                i += 2;
                continue;
            }
            if (!(parameters[i].getType() instanceof PsiEllipsisType) && ParameterNameFoldingManager.shouldInlineParameterName(i, callArguments, parameters, resolveResult)) {
                descriptors.add(ParameterNameFoldingManager.createFoldingDescriptor(callArguments[i], parameters[i]));
            }
            ++i;
        }
        ArrayList<FoldingDescriptor> arrayList = descriptors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/folding/impl/ParameterNameFoldingManager", "buildDescriptorsForLiteralArguments"));
        }
        return arrayList;
    }

    @NotNull
    private static NamedFoldingDescriptor createFoldingDescriptor(@NotNull PsiExpression callArgument, @NotNull PsiParameter methodParam) {
        if (callArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callArgument", "com/intellij/codeInsight/folding/impl/ParameterNameFoldingManager", "createFoldingDescriptor"));
        }
        if (methodParam == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodParam", "com/intellij/codeInsight/folding/impl/ParameterNameFoldingManager", "createFoldingDescriptor"));
        }
        PsiElement lParenOrCommaOrWhitespaceOrComment = callArgument.getPrevSibling();
        TextRange range = lParenOrCommaOrWhitespaceOrComment.getTextRange();
        String placeholderText = StringUtil.last(lParenOrCommaOrWhitespaceOrComment.getText(), 1, false) + methodParam.getName() + ": ";
        NamedFoldingDescriptor namedFoldingDescriptor = new NamedFoldingDescriptor(callArgument, range.getEndOffset() - 1, range.getEndOffset(), null, placeholderText);
        if (namedFoldingDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/folding/impl/ParameterNameFoldingManager", "createFoldingDescriptor"));
        }
        return namedFoldingDescriptor;
    }

    private static boolean isCommonlyNamedParameterPair(int first, int second, PsiParameter[] parameters) {
        if (first >= parameters.length || second >= parameters.length) {
            return false;
        }
        String firstParamName = parameters[first].getName();
        String secondParamName = parameters[second].getName();
        if (firstParamName == null || secondParamName == null) {
            return false;
        }
        for (Couple<String> knownPair : COMMONLY_USED_PARAMETER_PAIR) {
            if (!StringUtil.containsIgnoreCase(firstParamName, (String)knownPair.first) || !StringUtil.containsIgnoreCase(secondParamName, (String)knownPair.second)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldInlineParameterName(int paramIndex, @NotNull PsiExpression[] callArguments, @NotNull PsiParameter[] parameters, @NotNull JavaResolveResult resolveResult) {
        if (callArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callArguments", "com/intellij/codeInsight/folding/impl/ParameterNameFoldingManager", "shouldInlineParameterName"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/folding/impl/ParameterNameFoldingManager", "shouldInlineParameterName"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/codeInsight/folding/impl/ParameterNameFoldingManager", "shouldInlineParameterName"));
        }
        PsiExpression argument = callArguments[paramIndex];
        if (ParameterNameFoldingManager.isLiteralExpression(argument) && argument.getType() != null) {
            PsiParameter parameter = parameters[paramIndex];
            String paramName = parameter.getName();
            JavaCodeFoldingSettings settings = JavaCodeFoldingSettings.getInstance();
            if (paramName != null && paramName.length() >= settings.getInlineLiteralParameterMinNameLength()) {
                PsiType parameterType = resolveResult.getSubstitutor().substitute(parameter.getType());
                return TypeConversionUtil.isAssignable(parameterType, argument.getType());
            }
        }
        return false;
    }

    private static boolean hasLiteralExpression(@NotNull PsiExpression[] arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/codeInsight/folding/impl/ParameterNameFoldingManager", "hasLiteralExpression"));
        }
        for (PsiExpression argument : arguments) {
            if (!ParameterNameFoldingManager.isLiteralExpression(argument)) continue;
            return true;
        }
        return false;
    }
}

