/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.impl;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ForeignLeafType;
import com.intellij.lang.ITokenTypeRemapper;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.TokenWrapper;
import com.intellij.lang.WhitespaceSkippedCallback;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.text.BlockSupportImpl;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.tree.ICustomParsingType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.ILeafElementType;
import com.intellij.psi.tree.ILightLazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CharTable;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.TripleFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.LimitedPool;
import com.intellij.util.containers.Stack;
import com.intellij.util.diff.DiffTreeChangeBuilder;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.util.diff.ShallowNodeComparator;
import com.intellij.util.text.CharArrayUtil;
import java.lang.reflect.Field;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiBuilderImpl
extends UserDataHolderBase
implements PsiBuilder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.lang.impl.PsiBuilderImpl");
    public static final Key<TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState>> CUSTOM_COMPARATOR = Key.create("CUSTOM_COMPARATOR");
    private static final Key<LazyParseableTokensCache> LAZY_PARSEABLE_TOKENS = Key.create("LAZY_PARSEABLE_TOKENS");
    private static TokenSet ourAnyLanguageWhitespaceTokens = TokenSet.EMPTY;
    private final Project myProject;
    private PsiFile myFile;
    private int[] myLexStarts;
    private IElementType[] myLexTypes;
    private int myCurrentLexeme;
    private final MyList myProduction;
    private final Lexer myLexer;
    private final TokenSet myWhitespaces;
    private TokenSet myComments;
    private CharTable myCharTable;
    private final CharSequence myText;
    private final CharSequence myLastCommittedText;
    private final char[] myTextArray;
    private boolean myDebugMode;
    private int myLexemeCount;
    private boolean myTokenTypeChecked;
    private ITokenTypeRemapper myRemapper;
    private WhitespaceSkippedCallback myWhitespaceSkippedCallback;
    private final ASTNode myOriginalTree;
    private final MyTreeStructure myParentLightTree;
    private final int myOffset;
    private Map<Key, Object> myUserData;
    private IElementType myCachedTokenType;
    private final LimitedPool<StartMarker> START_MARKERS;
    private final LimitedPool<DoneMarker> DONE_MARKERS;
    private static final ArrayFactory<IElementType> myElementTypeArrayFactory = new ArrayFactory<IElementType>(){

        @NotNull
        public IElementType[] create(int count) {
            IElementType[] iElementTypeArray = count == 0 ? IElementType.EMPTY_ARRAY : new IElementType[count];
            if (iElementTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl$3", "create"));
            }
            return iElementTypeArray;
        }
    };
    @NonNls
    private static final String UNBALANCED_MESSAGE = "Unbalanced tree. Most probably caused by unbalanced markers. Try calling setDebugMode(true) against PsiBuilder passed to identify exact location of the problem";

    public static void registerWhitespaceToken(@NotNull IElementType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/impl/PsiBuilderImpl", "registerWhitespaceToken"));
        }
        ourAnyLanguageWhitespaceTokens = TokenSet.orSet(ourAnyLanguageWhitespaceTokens, TokenSet.create(type));
    }

    public PsiBuilderImpl(@NotNull Project project, PsiFile containingFile, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, CharTable charTable, @NotNull CharSequence text, @Nullable ASTNode originalTree, @Nullable MyTreeStructure parentLightTree) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (parserDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parserDefinition", "com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        this(project, containingFile, parserDefinition.getWhitespaceTokens(), parserDefinition.getCommentTokens(), lexer, charTable, text, originalTree, originalTree == null ? null : originalTree.getText(), parentLightTree, null);
    }

    public PsiBuilderImpl(Project project, PsiFile containingFile, @NotNull TokenSet whiteSpaces, @NotNull TokenSet comments, @NotNull Lexer lexer, CharTable charTable, @NotNull CharSequence text, @Nullable ASTNode originalTree, @Nullable MyTreeStructure parentLightTree) {
        if (whiteSpaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whiteSpaces", "com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (comments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comments", "com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        this(project, containingFile, whiteSpaces, comments, lexer, charTable, text, originalTree, originalTree == null ? null : originalTree.getText(), parentLightTree, null);
    }

    private PsiBuilderImpl(Project project, PsiFile containingFile, @NotNull TokenSet whiteSpaces, @NotNull TokenSet comments, @NotNull Lexer lexer, CharTable charTable, @NotNull CharSequence text, @Nullable ASTNode originalTree, @Nullable CharSequence lastCommittedText, @Nullable MyTreeStructure parentLightTree, @Nullable Object parentCachingNode) {
        if (whiteSpaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whiteSpaces", "com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (comments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comments", "com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        this.myProduction = new MyList();
        this.START_MARKERS = new LimitedPool<StartMarker>(2000, new LimitedPool.ObjectFactory<StartMarker>(){

            @Override
            @NotNull
            public StartMarker create() {
                StartMarker startMarker = new StartMarker();
                if (startMarker == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl$1", "create"));
                }
                return startMarker;
            }

            @Override
            public void cleanup(@NotNull StartMarker startMarker) {
                if (startMarker == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startMarker", "com/intellij/lang/impl/PsiBuilderImpl$1", "cleanup"));
                }
                startMarker.clean();
            }
        });
        this.DONE_MARKERS = new LimitedPool<DoneMarker>(2000, new LimitedPool.ObjectFactory<DoneMarker>(){

            @Override
            @NotNull
            public DoneMarker create() {
                DoneMarker doneMarker = new DoneMarker();
                if (doneMarker == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl$2", "create"));
                }
                return doneMarker;
            }

            @Override
            public void cleanup(@NotNull DoneMarker doneMarker) {
                if (doneMarker == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doneMarker", "com/intellij/lang/impl/PsiBuilderImpl$2", "cleanup"));
                }
                doneMarker.clean();
            }
        });
        this.myProject = project;
        this.myFile = containingFile;
        this.myText = text;
        this.myTextArray = CharArrayUtil.fromSequenceWithoutCopying(text);
        this.myLexer = lexer;
        this.myWhitespaces = whiteSpaces;
        this.myComments = comments;
        this.myCharTable = charTable;
        this.myOriginalTree = originalTree;
        this.myLastCommittedText = lastCommittedText;
        if (originalTree == null != (lastCommittedText == null)) {
            throw new IllegalArgumentException("originalTree and lastCommittedText must be null/notnull together but got: originalTree=" + originalTree + "; lastCommittedText=" + (lastCommittedText == null ? null : "'" + StringUtil.first(lastCommittedText, 80, true) + "'"));
        }
        this.myParentLightTree = parentLightTree;
        this.myOffset = parentCachingNode instanceof LazyParseableToken ? ((LazyParseableToken)parentCachingNode).getStartOffset() : 0;
        this.cacheLexemes(parentCachingNode);
    }

    public PsiBuilderImpl(@NotNull Project project, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @NotNull ASTNode chameleon, @NotNull CharSequence text) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (parserDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parserDefinition", "com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (chameleon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chameleon", "com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        this(project, SharedImplUtil.getContainingFile(chameleon), parserDefinition.getWhitespaceTokens(), parserDefinition.getCommentTokens(), lexer, SharedImplUtil.findCharTableByTree(chameleon), text, Pair.getFirst(chameleon.getUserData(BlockSupport.TREE_TO_BE_REPARSED)), Pair.getSecond(chameleon.getUserData(BlockSupport.TREE_TO_BE_REPARSED)), null, chameleon);
    }

    public PsiBuilderImpl(@NotNull Project project, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @NotNull LighterLazyParseableNode chameleon, @NotNull CharSequence text) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (parserDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parserDefinition", "com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (chameleon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chameleon", "com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        this(project, chameleon.getContainingFile(), parserDefinition.getWhitespaceTokens(), parserDefinition.getCommentTokens(), lexer, chameleon.getCharTable(), text, null, null, ((LazyParseableToken)chameleon).myParentStructure, chameleon);
    }

    private void cacheLexemes(@Nullable Object parentCachingNode) {
        int[] lexStarts = null;
        IElementType[] lexTypes = null;
        int lexemeCount = -1;
        boolean doLexingOptimizationCorrectionCheck = false;
        if (parentCachingNode instanceof LazyParseableToken) {
            LazyParseableToken parentToken = (LazyParseableToken)parentCachingNode;
            int tokenCount = parentToken.myEndIndex - parentToken.myStartIndex;
            if (tokenCount != 1) {
                lexStarts = new int[tokenCount + 1];
                System.arraycopy(parentToken.myBuilder.myLexStarts, parentToken.myStartIndex, lexStarts, 0, tokenCount);
                int diff = parentToken.myBuilder.myLexStarts[parentToken.myStartIndex];
                int i = 0;
                while (i < tokenCount) {
                    int n = i++;
                    lexStarts[n] = lexStarts[n] - diff;
                }
                lexStarts[tokenCount] = this.myText.length();
                lexTypes = new IElementType[tokenCount];
                System.arraycopy(parentToken.myBuilder.myLexTypes, parentToken.myStartIndex, lexTypes, 0, tokenCount);
                lexemeCount = tokenCount;
            }
            ProgressIndicatorProvider.checkCanceled();
            if (!doLexingOptimizationCorrectionCheck && lexemeCount != -1) {
                this.myLexStarts = lexStarts;
                this.myLexTypes = lexTypes;
                this.myLexemeCount = lexemeCount;
                return;
            }
        } else if (parentCachingNode instanceof LazyParseableElement) {
            LazyParseableElement parentElement = (LazyParseableElement)parentCachingNode;
            LazyParseableTokensCache cachedTokens = parentElement.getUserData(LAZY_PARSEABLE_TOKENS);
            parentElement.putUserData(LAZY_PARSEABLE_TOKENS, null);
            if (!doLexingOptimizationCorrectionCheck && cachedTokens != null) {
                this.myLexStarts = cachedTokens.myLexStarts;
                this.myLexTypes = cachedTokens.myLexTypes;
                this.myLexemeCount = this.myLexTypes.length;
                return;
            }
        }
        int approxLexCount = Math.max(10, this.myText.length() / 5);
        this.myLexStarts = new int[approxLexCount];
        this.myLexTypes = new IElementType[approxLexCount];
        this.myLexer.start(this.myText);
        int i = 0;
        int offset = 0;
        while (true) {
            int tokenStart;
            ProgressIndicatorProvider.checkCanceled();
            IElementType type = this.myLexer.getTokenType();
            if (type == null) break;
            if (i >= this.myLexTypes.length - 1) {
                this.resizeLexemes(i * 3 / 2);
            }
            if ((tokenStart = this.myLexer.getTokenStart()) < offset) {
                StringBuilder sb = new StringBuilder();
                IElementType tokenType = this.myLexer.getTokenType();
                sb.append("Token sequence broken").append("\n  this: '").append(this.myLexer.getTokenText()).append("' (").append(tokenType).append(':').append(tokenType != null ? tokenType.getLanguage() : null).append(") ").append(tokenStart).append(":").append(this.myLexer.getTokenEnd());
                if (i > 0) {
                    int prevStart = this.myLexStarts[i - 1];
                    sb.append("\n  prev: '").append(this.myText.subSequence(prevStart, offset)).append("' (").append(this.myLexTypes[i - 1]).append(':').append(this.myLexTypes[i - 1].getLanguage()).append(") ").append(prevStart).append(":").append(offset);
                }
                int quoteStart = Math.max(tokenStart - 256, 0);
                int quoteEnd = Math.min(tokenStart + 256, this.myText.length());
                sb.append("\n  quote: [").append(quoteStart).append(':').append(quoteEnd).append("] '").append(this.myText.subSequence(quoteStart, quoteEnd)).append('\'');
                LOG.error(sb);
            }
            this.myLexStarts[i] = offset = tokenStart;
            this.myLexTypes[i] = type;
            ++i;
            this.myLexer.advance();
        }
        this.myLexStarts[i] = this.myText.length();
        this.myLexemeCount = i;
        this.clearCachedTokenType();
        if (doLexingOptimizationCorrectionCheck && lexemeCount != -1) {
            assert (lexemeCount == this.myLexemeCount);
            for (int j = 0; j < lexemeCount; ++j) {
                if (this.myLexStarts[j] != lexStarts[j] || this.myLexTypes[j] != lexTypes[j]) assert (false);
            }
            assert (this.myLexStarts[lexemeCount] == lexStarts[lexemeCount]);
        }
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public void enforceCommentTokens(@NotNull TokenSet tokens) {
        if (tokens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokens", "com/intellij/lang/impl/PsiBuilderImpl", "enforceCommentTokens"));
        }
        this.myComments = tokens;
    }

    @Override
    @Nullable
    public LighterASTNode getLatestDoneMarker() {
        for (int index = this.myProduction.size() - 1; index >= 0; --index) {
            ProductionMarker marker = (ProductionMarker)this.myProduction.get(index);
            if (!(marker instanceof DoneMarker)) continue;
            return ((DoneMarker)marker).myStart;
        }
        return null;
    }

    @NotNull
    private PsiBuilder.Marker precede(StartMarker marker) {
        int idx = this.myProduction.lastIndexOf(marker);
        if (idx < 0) {
            LOG.error("Cannot precede dropped or rolled-back marker");
        }
        StartMarker pre = this.createMarker(marker.myLexemeIndex);
        this.myProduction.add(idx, pre);
        StartMarker startMarker = pre;
        if (startMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl", "precede"));
        }
        return startMarker;
    }

    @Override
    public CharSequence getOriginalText() {
        return this.myText;
    }

    @Override
    @Nullable
    public IElementType getTokenType() {
        IElementType cached = this.myCachedTokenType;
        if (cached == null) {
            this.myCachedTokenType = cached = this.calcTokenType();
        }
        return cached;
    }

    private void clearCachedTokenType() {
        this.myCachedTokenType = null;
    }

    private IElementType remapCurrentToken() {
        if (this.myCachedTokenType != null) {
            return this.myCachedTokenType;
        }
        if (this.myRemapper != null) {
            this.remapCurrentToken(this.myRemapper.filter(this.myLexTypes[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme + 1], this.myLexer.getBufferSequence()));
        }
        return this.myLexTypes[this.myCurrentLexeme];
    }

    private IElementType calcTokenType() {
        if (this.eof()) {
            return null;
        }
        if (this.myRemapper != null) {
            this.skipWhitespace();
        }
        return this.myLexTypes[this.myCurrentLexeme];
    }

    @Override
    public void setTokenTypeRemapper(ITokenTypeRemapper remapper) {
        this.myRemapper = remapper;
        this.myTokenTypeChecked = false;
        this.clearCachedTokenType();
    }

    @Override
    public void remapCurrentToken(IElementType type) {
        this.myLexTypes[this.myCurrentLexeme] = type;
        this.clearCachedTokenType();
    }

    @Override
    @Nullable
    public IElementType lookAhead(int steps) {
        if (this.eof()) {
            return null;
        }
        int cur = this.myCurrentLexeme;
        while (steps > 0) {
            ++cur;
            while (cur < this.myLexemeCount && this.whitespaceOrComment(this.myLexTypes[cur])) {
                ++cur;
            }
            --steps;
        }
        return cur < this.myLexemeCount ? this.myLexTypes[cur] : null;
    }

    @Override
    public IElementType rawLookup(int steps) {
        int cur = this.myCurrentLexeme + steps;
        return cur < this.myLexemeCount && cur >= 0 ? this.myLexTypes[cur] : null;
    }

    @Override
    public int rawTokenTypeStart(int steps) {
        int cur = this.myCurrentLexeme + steps;
        if (cur < 0) {
            return -1;
        }
        if (cur >= this.myLexemeCount) {
            return this.getOriginalText().length();
        }
        return this.myLexStarts[cur];
    }

    @Override
    public int rawTokenIndex() {
        return this.myCurrentLexeme;
    }

    public int rawTokenOffset(int tokenIndex) {
        return this.myLexStarts[tokenIndex];
    }

    @Override
    public void setWhitespaceSkippedCallback(@Nullable WhitespaceSkippedCallback callback) {
        this.myWhitespaceSkippedCallback = callback;
    }

    @Override
    public void advanceLexer() {
        ProgressIndicatorProvider.checkCanceled();
        if (this.eof()) {
            return;
        }
        if (!this.myTokenTypeChecked) {
            LOG.error("Probably a bug: eating token without its type checking");
        }
        this.myTokenTypeChecked = false;
        ++this.myCurrentLexeme;
        this.clearCachedTokenType();
    }

    private void skipWhitespace() {
        while (this.myCurrentLexeme < this.myLexemeCount && this.whitespaceOrComment(this.remapCurrentToken())) {
            this.onSkip(this.myLexTypes[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme], this.myCurrentLexeme + 1 < this.myLexemeCount ? this.myLexStarts[this.myCurrentLexeme + 1] : this.myText.length());
            ++this.myCurrentLexeme;
            this.clearCachedTokenType();
        }
    }

    private void onSkip(IElementType type, int start, int end) {
        if (this.myWhitespaceSkippedCallback != null) {
            this.myWhitespaceSkippedCallback.onSkip(type, start, end);
        }
    }

    @Override
    public int getCurrentOffset() {
        if (this.eof()) {
            return this.getOriginalText().length();
        }
        return this.myLexStarts[this.myCurrentLexeme];
    }

    @Override
    @Nullable
    public String getTokenText() {
        if (this.eof()) {
            return null;
        }
        IElementType type = this.getTokenType();
        if (type instanceof TokenWrapper) {
            return ((TokenWrapper)type).getValue();
        }
        return this.myText.subSequence(this.myLexStarts[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme + 1]).toString();
    }

    private void resizeLexemes(int newSize) {
        this.myLexStarts = ArrayUtil.realloc(this.myLexStarts, newSize + 1);
        this.myLexTypes = ArrayUtil.realloc(this.myLexTypes, newSize, myElementTypeArrayFactory);
        this.clearCachedTokenType();
    }

    public boolean whitespaceOrComment(IElementType token) {
        return this.myWhitespaces.contains(token) || this.myComments.contains(token);
    }

    @Override
    @NotNull
    public PsiBuilder.Marker mark() {
        if (!this.myProduction.isEmpty()) {
            this.skipWhitespace();
        }
        StartMarker marker = this.createMarker(this.myCurrentLexeme);
        this.myProduction.add(marker);
        StartMarker startMarker = marker;
        if (startMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl", "mark"));
        }
        return startMarker;
    }

    @NotNull
    private StartMarker createMarker(int lexemeIndex) {
        StartMarker marker = this.START_MARKERS.alloc();
        marker.myLexemeIndex = lexemeIndex;
        marker.myBuilder = this;
        if (this.myDebugMode) {
            marker.myDebugAllocationPosition = new Throwable("Created at the following trace.");
        }
        StartMarker startMarker = marker;
        if (startMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl", "createMarker"));
        }
        return startMarker;
    }

    @Override
    public final boolean eof() {
        if (!this.myTokenTypeChecked) {
            this.myTokenTypeChecked = true;
            this.skipWhitespace();
        }
        return this.myCurrentLexeme >= this.myLexemeCount;
    }

    private void rollbackTo(@NotNull PsiBuilder.Marker marker) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/lang/impl/PsiBuilderImpl", "rollbackTo"));
        }
        this.myCurrentLexeme = ((StartMarker)marker).myLexemeIndex;
        this.myTokenTypeChecked = true;
        int idx = this.myProduction.lastIndexOf(marker);
        if (idx < 0) {
            LOG.error("The marker must be added before rolled back to.");
        }
        this.myProduction.removeRange(idx, this.myProduction.size());
        this.START_MARKERS.recycle((StartMarker)marker);
        this.clearCachedTokenType();
    }

    public boolean hasErrorsAfter(@NotNull PsiBuilder.Marker marker) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/lang/impl/PsiBuilderImpl", "hasErrorsAfter"));
        }
        assert (marker instanceof StartMarker);
        int idx = this.myProduction.lastIndexOf(marker);
        if (idx < 0) {
            LOG.error("The marker must be added before checked for errors.");
        }
        for (int i = idx + 1; i < this.myProduction.size(); ++i) {
            ProductionMarker m = (ProductionMarker)this.myProduction.get(i);
            if (!(m instanceof ErrorItem) && !(m instanceof DoneWithErrorMarker)) continue;
            return true;
        }
        return false;
    }

    public void drop(@NotNull PsiBuilder.Marker marker) {
        boolean removed;
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/lang/impl/PsiBuilderImpl", "drop"));
        }
        DoneMarker doneMarker = ((StartMarker)marker).myDoneMarker;
        if (doneMarker != null) {
            this.myProduction.remove(this.myProduction.lastIndexOf(doneMarker));
            this.DONE_MARKERS.recycle(doneMarker);
        }
        boolean bl = removed = this.myProduction.remove(this.myProduction.lastIndexOf(marker)) == marker;
        if (!removed) {
            LOG.error("The marker must be added before it is dropped.");
        }
        this.START_MARKERS.recycle((StartMarker)marker);
    }

    public void error(@NotNull PsiBuilder.Marker marker, String message) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/lang/impl/PsiBuilderImpl", "error"));
        }
        this.doValidityChecks(marker, null);
        DoneWithErrorMarker doneMarker = new DoneWithErrorMarker((StartMarker)marker, this.myCurrentLexeme, message);
        boolean tieToTheLeft = this.isEmpty(((StartMarker)marker).myLexemeIndex, this.myCurrentLexeme);
        if (tieToTheLeft) {
            ((StartMarker)marker).myEdgeTokenBinder = WhitespacesBinders.DEFAULT_RIGHT_BINDER;
        }
        ((StartMarker)marker).myDoneMarker = doneMarker;
        this.myProduction.add(doneMarker);
    }

    private void errorBefore(@NotNull PsiBuilder.Marker marker, String message, @NotNull PsiBuilder.Marker before) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/lang/impl/PsiBuilderImpl", "errorBefore"));
        }
        if (before == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "before", "com/intellij/lang/impl/PsiBuilderImpl", "errorBefore"));
        }
        this.doValidityChecks(marker, before);
        int beforeIndex = this.myProduction.lastIndexOf(before);
        DoneWithErrorMarker doneMarker = new DoneWithErrorMarker((StartMarker)marker, ((StartMarker)before).myLexemeIndex, message);
        boolean tieToTheLeft = this.isEmpty(((StartMarker)marker).myLexemeIndex, ((StartMarker)before).myLexemeIndex);
        if (tieToTheLeft) {
            ((StartMarker)marker).myEdgeTokenBinder = WhitespacesBinders.DEFAULT_RIGHT_BINDER;
        }
        ((StartMarker)marker).myDoneMarker = doneMarker;
        this.myProduction.add(beforeIndex, doneMarker);
    }

    public void done(@NotNull PsiBuilder.Marker marker) {
        boolean tieToTheLeft;
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/lang/impl/PsiBuilderImpl", "done"));
        }
        this.doValidityChecks(marker, null);
        DoneMarker doneMarker = this.DONE_MARKERS.alloc();
        doneMarker.myStart = (StartMarker)marker;
        doneMarker.myLexemeIndex = this.myCurrentLexeme;
        boolean bl = tieToTheLeft = doneMarker.myStart.myType.isLeftBound() && this.isEmpty(((StartMarker)marker).myLexemeIndex, this.myCurrentLexeme);
        if (tieToTheLeft) {
            ((StartMarker)marker).myEdgeTokenBinder = WhitespacesBinders.DEFAULT_RIGHT_BINDER;
        }
        ((StartMarker)marker).myDoneMarker = doneMarker;
        this.myProduction.add(doneMarker);
    }

    public void doneBefore(@NotNull PsiBuilder.Marker marker, @NotNull PsiBuilder.Marker before) {
        boolean tieToTheLeft;
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/lang/impl/PsiBuilderImpl", "doneBefore"));
        }
        if (before == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "before", "com/intellij/lang/impl/PsiBuilderImpl", "doneBefore"));
        }
        this.doValidityChecks(marker, before);
        int beforeIndex = this.myProduction.lastIndexOf(before);
        DoneMarker doneMarker = this.DONE_MARKERS.alloc();
        doneMarker.myLexemeIndex = ((StartMarker)before).myLexemeIndex;
        doneMarker.myStart = (StartMarker)marker;
        boolean bl = tieToTheLeft = doneMarker.myStart.myType.isLeftBound() && this.isEmpty(((StartMarker)marker).myLexemeIndex, ((StartMarker)before).myLexemeIndex);
        if (tieToTheLeft) {
            ((StartMarker)marker).myEdgeTokenBinder = WhitespacesBinders.DEFAULT_RIGHT_BINDER;
        }
        ((StartMarker)marker).myDoneMarker = doneMarker;
        this.myProduction.add(beforeIndex, doneMarker);
    }

    private boolean isEmpty(int startIdx, int endIdx) {
        for (int i = startIdx; i < endIdx; ++i) {
            IElementType token = this.myLexTypes[i];
            if (this.whitespaceOrComment(token)) continue;
            return false;
        }
        return true;
    }

    public void collapse(@NotNull PsiBuilder.Marker marker) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/lang/impl/PsiBuilderImpl", "collapse"));
        }
        this.done(marker);
        ((StartMarker)marker).myDoneMarker.myCollapse = true;
    }

    private void doValidityChecks(@NotNull PsiBuilder.Marker marker, @Nullable PsiBuilder.Marker before) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/lang/impl/PsiBuilderImpl", "doValidityChecks"));
        }
        DoneMarker doneMarker = ((StartMarker)marker).myDoneMarker;
        if (doneMarker != null) {
            LOG.error("Marker already done.");
        }
        if (!this.myDebugMode) {
            return;
        }
        int idx = this.myProduction.lastIndexOf(marker);
        if (idx < 0) {
            LOG.error("Marker has never been added.");
        }
        int endIdx = this.myProduction.size();
        if (before != null) {
            endIdx = this.myProduction.lastIndexOf(before);
            if (endIdx < 0) {
                LOG.error("'Before' marker has never been added.");
            }
            if (idx > endIdx) {
                LOG.error("'Before' marker precedes this one.");
            }
        }
        for (int i = endIdx - 1; i > idx; --i) {
            StartMarker otherMarker;
            Object item = this.myProduction.get(i);
            if (!(item instanceof StartMarker) || (otherMarker = (StartMarker)item).myDoneMarker != null) continue;
            Throwable debugAllocOther = otherMarker.myDebugAllocationPosition;
            Throwable debugAllocThis = ((StartMarker)marker).myDebugAllocationPosition;
            if (debugAllocOther != null) {
                Throwable currentTrace = new Throwable();
                ExceptionUtil.makeStackTraceRelative(debugAllocThis, currentTrace).printStackTrace(System.err);
                ExceptionUtil.makeStackTraceRelative(debugAllocOther, currentTrace).printStackTrace(System.err);
            }
            LOG.error("Another not done marker added after this one. Must be done before this.");
        }
    }

    @Override
    public void error(String messageText) {
        ProductionMarker lastMarker = (ProductionMarker)this.myProduction.get(this.myProduction.size() - 1);
        if (lastMarker instanceof ErrorItem && lastMarker.myLexemeIndex == this.myCurrentLexeme) {
            return;
        }
        this.myProduction.add(new ErrorItem(this, messageText, this.myCurrentLexeme));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ASTNode getTreeBuilt() {
        ASTNode aSTNode = this.buildTree();
        ASTNode aSTNode2 = aSTNode;
        if (aSTNode2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl", "getTreeBuilt"));
        }
        return aSTNode2;
        finally {
            for (ProductionMarker marker : this.myProduction) {
                if (marker instanceof StartMarker) {
                    this.START_MARKERS.recycle((StartMarker)marker);
                    continue;
                }
                if (!(marker instanceof DoneMarker)) continue;
                this.DONE_MARKERS.recycle((DoneMarker)marker);
            }
        }
    }

    @NotNull
    private ASTNode buildTree() {
        boolean isTooDeep;
        StartMarker rootMarker = this.prepareLightTree();
        boolean bl = isTooDeep = this.myFile != null && BlockSupport.isTooDeep(this.myFile.getOriginalFile());
        if (this.myOriginalTree != null && !isTooDeep) {
            DiffLog diffLog = this.merge(this.myOriginalTree, rootMarker, this.myLastCommittedText);
            throw new BlockSupport.ReparsedSuccessfullyException(diffLog);
        }
        TreeElement rootNode = this.createRootAST(rootMarker);
        this.bind(rootMarker, (CompositeElement)rootNode);
        if (isTooDeep && !(rootNode instanceof FileElement)) {
            TreeElement childNode = rootNode.getFirstChildNode();
            childNode.putUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED, Boolean.TRUE);
        }
        assert (rootNode.getTextLength() == this.myText.length()) : rootNode.getElementType();
        TreeElement treeElement = rootNode;
        if (treeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl", "buildTree"));
        }
        return treeElement;
    }

    @Override
    @NotNull
    public FlyweightCapableTreeStructure<LighterASTNode> getLightTree() {
        StartMarker rootMarker = this.prepareLightTree();
        MyTreeStructure myTreeStructure = new MyTreeStructure(rootMarker, this.myParentLightTree);
        if (myTreeStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl", "getLightTree"));
        }
        return myTreeStructure;
    }

    @NotNull
    private TreeElement createRootAST(@NotNull StartMarker rootMarker) {
        CompositeElement rootNode;
        if (rootMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootMarker", "com/intellij/lang/impl/PsiBuilderImpl", "createRootAST"));
        }
        IElementType type = rootMarker.getTokenType();
        CompositeElement compositeElement = rootNode = type instanceof ILazyParseableElementType ? ASTFactory.lazy((ILazyParseableElementType)type, null) : PsiBuilderImpl.createComposite(rootMarker);
        if (this.myCharTable == null) {
            CharTable charTable = this.myCharTable = rootNode instanceof FileElement ? ((FileElement)rootNode).getCharTable() : new CharTableImpl();
        }
        if (!(rootNode instanceof FileElement)) {
            rootNode.putUserData(CharTable.CHAR_TABLE_KEY, this.myCharTable);
        }
        CompositeElement compositeElement2 = rootNode;
        if (compositeElement2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl", "createRootAST"));
        }
        return compositeElement2;
    }

    @NotNull
    private DiffLog merge(@NotNull ASTNode oldRoot, @NotNull StartMarker newRoot, @NotNull CharSequence lastCommittedText) {
        if (oldRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRoot", "com/intellij/lang/impl/PsiBuilderImpl", "merge"));
        }
        if (newRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRoot", "com/intellij/lang/impl/PsiBuilderImpl", "merge"));
        }
        if (lastCommittedText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastCommittedText", "com/intellij/lang/impl/PsiBuilderImpl", "merge"));
        }
        DiffLog diffLog = new DiffLog();
        ConvertFromTokensToASTBuilder builder = new ConvertFromTokensToASTBuilder(newRoot, diffLog);
        MyTreeStructure treeStructure = new MyTreeStructure(newRoot, null);
        MyComparator comparator = new MyComparator(this.getUserDataUnprotected(CUSTOM_COMPARATOR), treeStructure);
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        BlockSupportImpl.diffTrees(oldRoot, builder, comparator, treeStructure, indicator == null ? new EmptyProgressIndicator() : indicator, lastCommittedText);
        DiffLog diffLog2 = diffLog;
        if (diffLog2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl", "merge"));
        }
        return diffLog2;
    }

    @NotNull
    private StartMarker prepareLightTree() {
        StartMarker rootMarker;
        if (this.myProduction.isEmpty()) {
            LOG.error("Parser produced no markers. Text:\n" + this.myText);
        }
        if ((rootMarker = (StartMarker)this.myProduction.get(0)).myFirstChild != null) {
            StartMarker startMarker = rootMarker;
            if (startMarker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl", "prepareLightTree"));
            }
            return startMarker;
        }
        this.myTokenTypeChecked = true;
        this.balanceWhiteSpaces();
        rootMarker.myNext = null;
        rootMarker.myParent = rootMarker.myFirstChild = (rootMarker.myLastChild = null);
        StartMarker curNode = rootMarker;
        Stack<StartMarker> nodes = ContainerUtil.newStack();
        nodes.push(rootMarker);
        int lastErrorIndex = -1;
        int maxDepth = 0;
        int curDepth = 0;
        for (int i = 1; i < this.myProduction.size(); ++i) {
            int curToken;
            ProductionMarker item = (ProductionMarker)this.myProduction.get(i);
            if (curNode == null) {
                LOG.error("Unexpected end of the production");
            }
            item.myParent = curNode;
            if (item instanceof StartMarker) {
                StartMarker marker = (StartMarker)item;
                marker.myNext = null;
                marker.myFirstChild = (marker.myLastChild = null);
                curNode.addChild(marker);
                nodes.push(curNode);
                curNode = marker;
                if (++curDepth <= maxDepth) continue;
                maxDepth = curDepth;
                continue;
            }
            if (item instanceof DoneMarker) {
                this.assertMarkersBalanced(((DoneMarker)item).myStart == curNode, item);
                curNode = (StartMarker)nodes.pop();
                --curDepth;
                continue;
            }
            if (!(item instanceof ErrorItem) || (curToken = item.myLexemeIndex) == lastErrorIndex) continue;
            lastErrorIndex = curToken;
            curNode.addChild(item);
        }
        if (this.myCurrentLexeme < this.myLexemeCount) {
            List<IElementType> missed = ContainerUtil.newArrayList(this.myLexTypes, this.myCurrentLexeme, this.myLexemeCount);
            LOG.error("Tokens " + missed + " were not inserted into the tree. " + (this.myFile != null ? this.myFile.getLanguage() + ", " : "") + "Text:\n" + this.myText);
        }
        if (((StartMarker)rootMarker).myDoneMarker.myLexemeIndex < this.myLexemeCount) {
            List<IElementType> missed = ContainerUtil.newArrayList(this.myLexTypes, ((StartMarker)rootMarker).myDoneMarker.myLexemeIndex, this.myLexemeCount);
            LOG.error("Tokens " + missed + " are outside of root element \"" + rootMarker.myType + "\". Text:\n" + this.myText);
        }
        if (this.myLexStarts.length <= this.myCurrentLexeme + 1) {
            this.resizeLexemes(this.myCurrentLexeme + 1);
        }
        this.myLexStarts[this.myCurrentLexeme] = this.myText.length();
        this.myLexStarts[this.myCurrentLexeme + 1] = 0;
        this.myLexTypes[this.myCurrentLexeme] = null;
        this.assertMarkersBalanced(curNode == rootMarker, curNode);
        this.checkTreeDepth(maxDepth, rootMarker.getTokenType() instanceof IFileElementType);
        this.clearCachedTokenType();
        StartMarker startMarker = rootMarker;
        if (startMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl", "prepareLightTree"));
        }
        return startMarker;
    }

    private void assertMarkersBalanced(boolean condition, @Nullable ProductionMarker marker) {
        if (condition) {
            return;
        }
        int index = marker != null ? marker.getStartIndex() + 1 : this.myLexStarts.length;
        String context = index < this.myLexStarts.length ? this.myText.subSequence(Math.max(0, this.myLexStarts[index] - 1000), this.myLexStarts[index]) : "<none>";
        String language = this.myFile != null ? this.myFile.getLanguage() + ", " : "";
        LOG.error("Unbalanced tree. Most probably caused by unbalanced markers. Try calling setDebugMode(true) against PsiBuilder passed to identify exact location of the problem\nlanguage: " + language + "\ncontext: '" + context + "'");
    }

    private void balanceWhiteSpaces() {
        RelativeTokenTypesView wsTokens = new RelativeTokenTypesView();
        RelativeTokenTextView tokenTextGetter = new RelativeTokenTextView();
        int lastIndex = 0;
        int size = this.myProduction.size() - 1;
        for (int i = 1; i < size; ++i) {
            int wsEndIndex;
            int wsStartIndex;
            boolean recursive;
            ProductionMarker item = (ProductionMarker)this.myProduction.get(i);
            if (item instanceof StartMarker) {
                this.assertMarkersBalanced(((StartMarker)item).myDoneMarker != null, item);
            }
            int prevProductionLexIndex = (recursive = item.myEdgeTokenBinder instanceof WhitespacesAndCommentsBinder.RecursiveBinder) ? 0 : ((ProductionMarker)this.myProduction.get((int)(i - 1))).myLexemeIndex;
            for (wsStartIndex = Math.max(item.myLexemeIndex, lastIndex); wsStartIndex > prevProductionLexIndex && this.whitespaceOrComment(this.myLexTypes[wsStartIndex - 1]); --wsStartIndex) {
            }
            for (wsEndIndex = item.myLexemeIndex; wsEndIndex < this.myLexemeCount && this.whitespaceOrComment(this.myLexTypes[wsEndIndex]); ++wsEndIndex) {
            }
            if (wsStartIndex != wsEndIndex) {
                wsTokens.configure(wsStartIndex, wsEndIndex);
                tokenTextGetter.configure(wsStartIndex);
                boolean atEnd = wsStartIndex == 0 || wsEndIndex == this.myLexemeCount;
                item.myLexemeIndex = wsStartIndex + item.myEdgeTokenBinder.getEdgePosition(wsTokens, atEnd, tokenTextGetter);
                if (recursive) {
                    for (int k = i - 1; k > 1; --k) {
                        ProductionMarker prev = (ProductionMarker)this.myProduction.get(k);
                        if (prev.myLexemeIndex >= item.myLexemeIndex) {
                            prev.myLexemeIndex = item.myLexemeIndex;
                            continue;
                        }
                        break;
                    }
                }
            } else if (item.myLexemeIndex < wsStartIndex) {
                item.myLexemeIndex = wsStartIndex;
            }
            lastIndex = item.myLexemeIndex;
        }
    }

    private void checkTreeDepth(int maxDepth, boolean isFileRoot) {
        if (this.myFile == null) {
            return;
        }
        PsiFile file = this.myFile.getOriginalFile();
        Boolean flag = file.getUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED);
        if (maxDepth > BlockSupport.INCREMENTAL_REPARSE_DEPTH_LIMIT) {
            if (!Boolean.TRUE.equals(flag)) {
                file.putUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED, Boolean.TRUE);
            }
        } else if (isFileRoot && flag != null) {
            file.putUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED, null);
        }
    }

    private void bind(@NotNull StartMarker rootMarker, @NotNull CompositeElement rootNode) {
        if (rootMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootMarker", "com/intellij/lang/impl/PsiBuilderImpl", "bind"));
        }
        if (rootNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootNode", "com/intellij/lang/impl/PsiBuilderImpl", "bind"));
        }
        StartMarker curMarker = rootMarker;
        CompositeElement curNode = rootNode;
        int lexIndex = rootMarker.myLexemeIndex;
        ProductionMarker item = rootMarker.myFirstChild != null ? rootMarker.myFirstChild : rootMarker.myDoneMarker;
        while (true) {
            lexIndex = this.insertLeaves(lexIndex, item.myLexemeIndex, curNode);
            if (item == rootMarker.myDoneMarker) break;
            if (item instanceof StartMarker) {
                StartMarker marker = (StartMarker)item;
                if (!marker.myDoneMarker.myCollapse) {
                    curMarker = marker;
                    CompositeElement childNode = PsiBuilderImpl.createComposite(marker);
                    curNode.rawAddChildrenWithoutNotifications(childNode);
                    curNode = childNode;
                    item = marker.myFirstChild != null ? marker.myFirstChild : marker.myDoneMarker;
                    continue;
                }
                lexIndex = this.collapseLeaves(curNode, marker);
            } else if (item instanceof ErrorItem) {
                CompositeElement errorElement = Factory.createErrorElement(((ErrorItem)item).myMessage);
                curNode.rawAddChildrenWithoutNotifications(errorElement);
            } else if (item instanceof DoneMarker) {
                curMarker = (StartMarker)((DoneMarker)((DoneMarker)item)).myStart.myParent;
                curNode = curNode.getTreeParent();
                item = ((DoneMarker)item).myStart;
            }
            item = item.myNext != null ? item.myNext : curMarker.myDoneMarker;
        }
    }

    private int insertLeaves(int curToken, int lastIdx, CompositeElement curNode) {
        lastIdx = Math.min(lastIdx, this.myLexemeCount);
        while (curToken < lastIdx) {
            ProgressIndicatorProvider.checkCanceled();
            int start = this.myLexStarts[curToken];
            int end = this.myLexStarts[curToken + 1];
            if (start < end || this.myLexTypes[curToken] instanceof ILeafElementType) {
                IElementType type = this.myLexTypes[curToken];
                TreeElement leaf = this.createLeaf(type, start, end);
                curNode.rawAddChildrenWithoutNotifications(leaf);
            }
            ++curToken;
        }
        return curToken;
    }

    private int collapseLeaves(@NotNull CompositeElement ast, @NotNull StartMarker startMarker) {
        if (ast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ast", "com/intellij/lang/impl/PsiBuilderImpl", "collapseLeaves"));
        }
        if (startMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startMarker", "com/intellij/lang/impl/PsiBuilderImpl", "collapseLeaves"));
        }
        int start = this.myLexStarts[startMarker.myLexemeIndex];
        int end = this.myLexStarts[((StartMarker)startMarker).myDoneMarker.myLexemeIndex];
        IElementType markerType = startMarker.myType;
        TreeElement leaf = this.createLeaf(markerType, start, end);
        if (markerType instanceof ILazyParseableElementType && ((ILazyParseableElementType)markerType).reuseCollapsedTokens() && startMarker.myLexemeIndex < ((StartMarker)startMarker).myDoneMarker.myLexemeIndex) {
            int length = ((StartMarker)startMarker).myDoneMarker.myLexemeIndex - startMarker.myLexemeIndex;
            int[] relativeStarts = new int[length + 1];
            IElementType[] types = new IElementType[length];
            for (int i = startMarker.myLexemeIndex; i < ((StartMarker)startMarker).myDoneMarker.myLexemeIndex; ++i) {
                relativeStarts[i - startMarker.myLexemeIndex] = this.myLexStarts[i] - start;
                types[i - startMarker.myLexemeIndex] = this.myLexTypes[i];
            }
            relativeStarts[length] = end - start;
            leaf.putUserData(LAZY_PARSEABLE_TOKENS, new LazyParseableTokensCache(relativeStarts, types));
        }
        ast.rawAddChildrenWithoutNotifications(leaf);
        return ((StartMarker)startMarker).myDoneMarker.myLexemeIndex;
    }

    @NotNull
    private static CompositeElement createComposite(@NotNull StartMarker marker) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/lang/impl/PsiBuilderImpl", "createComposite"));
        }
        IElementType type = marker.myType;
        if (type == TokenType.ERROR_ELEMENT) {
            String message = marker.myDoneMarker instanceof DoneWithErrorMarker ? ((DoneWithErrorMarker)marker.myDoneMarker).myMessage : null;
            CompositeElement compositeElement = Factory.createErrorElement(message);
            if (compositeElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl", "createComposite"));
            }
            return compositeElement;
        }
        if (type == null) {
            throw new RuntimeException(UNBALANCED_MESSAGE);
        }
        CompositeElement compositeElement = ASTFactory.composite(type);
        if (compositeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl", "createComposite"));
        }
        return compositeElement;
    }

    @Nullable
    public static String getErrorMessage(@NotNull LighterASTNode node) {
        StartMarker marker;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/impl/PsiBuilderImpl", "getErrorMessage"));
        }
        if (node instanceof ErrorItem) {
            return ((ErrorItem)node).myMessage;
        }
        if (node instanceof StartMarker && (marker = (StartMarker)node).myType == TokenType.ERROR_ELEMENT && marker.myDoneMarker instanceof DoneWithErrorMarker) {
            return ((DoneWithErrorMarker)marker.myDoneMarker).myMessage;
        }
        return null;
    }

    @Override
    public void setDebugMode(boolean dbgMode) {
        this.myDebugMode = dbgMode;
    }

    @NotNull
    public Lexer getLexer() {
        Lexer lexer = this.myLexer;
        if (lexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl", "getLexer"));
        }
        return lexer;
    }

    @NotNull
    private TreeElement createLeaf(@NotNull IElementType type, int start, int end) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/impl/PsiBuilderImpl", "createLeaf"));
        }
        CharSequence text = this.myCharTable.intern(this.myText, start, end);
        if (this.myWhitespaces.contains(type)) {
            PsiWhiteSpaceImpl psiWhiteSpaceImpl = new PsiWhiteSpaceImpl(text);
            if (psiWhiteSpaceImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl", "createLeaf"));
            }
            return psiWhiteSpaceImpl;
        }
        if (type instanceof ICustomParsingType) {
            TreeElement treeElement = (TreeElement)((ICustomParsingType)((Object)type)).parse(text, this.myCharTable);
            if (treeElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl", "createLeaf"));
            }
            return treeElement;
        }
        if (type instanceof ILazyParseableElementType) {
            LazyParseableElement lazyParseableElement = ASTFactory.lazy((ILazyParseableElementType)type, text);
            if (lazyParseableElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl", "createLeaf"));
            }
            return lazyParseableElement;
        }
        LeafElement leafElement = ASTFactory.leaf(type, text);
        if (leafElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl", "createLeaf"));
        }
        return leafElement;
    }

    @Override
    public <T> T getUserDataUnprotected(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/impl/PsiBuilderImpl", "getUserDataUnprotected"));
        }
        if (key == FileContextUtil.CONTAINING_FILE_KEY) {
            return (T)this.myFile;
        }
        return (T)(this.myUserData != null ? this.myUserData.get(key) : null);
    }

    @Override
    public <T> void putUserDataUnprotected(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/impl/PsiBuilderImpl", "putUserDataUnprotected"));
        }
        if (key == FileContextUtil.CONTAINING_FILE_KEY) {
            this.myFile = (PsiFile)value;
            return;
        }
        if (this.myUserData == null) {
            this.myUserData = ContainerUtil.newHashMap();
        }
        this.myUserData.put(key, value);
    }

    private static class LazyParseableTokensCache {
        final int[] myLexStarts;
        final IElementType[] myLexTypes;

        public LazyParseableTokensCache(int[] lexStarts, IElementType[] lexTypes) {
            this.myLexStarts = lexStarts;
            this.myLexTypes = lexTypes;
        }
    }

    private static class MyList
    extends ArrayList<ProductionMarker> {
        private static final Field ourElementDataField = ReflectionUtil.getDeclaredField(ArrayList.class, "elementData");
        private Object[] cachedElementData;

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            super.removeRange(fromIndex, toIndex);
        }

        private MyList() {
            super(256);
        }

        @Override
        public int lastIndexOf(Object o) {
            Object[] data = this.cachedElementData;
            if (data == null) {
                return super.lastIndexOf(o);
            }
            for (int i = this.size() - 1; i >= 0; --i) {
                if (data[i] != o) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void ensureCapacity(int minCapacity) {
            if (this.cachedElementData == null || minCapacity >= this.cachedElementData.length) {
                super.ensureCapacity(minCapacity);
                this.initCachedField();
            }
        }

        private void initCachedField() {
            if (ourElementDataField == null) {
                return;
            }
            try {
                this.cachedElementData = (Object[])ourElementDataField.get(this);
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
    }

    private static class ASTConverter
    implements Convertor<Node, ASTNode> {
        @NotNull
        private final StartMarker myRoot;

        private ASTConverter(@NotNull StartMarker root) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/lang/impl/PsiBuilderImpl$ASTConverter", "<init>"));
            }
            this.myRoot = root;
        }

        @Override
        public ASTNode convert(Node n) {
            if (n instanceof Token) {
                Token token = (Token)n;
                return token.myBuilder.createLeaf(token.getTokenType(), token.myTokenStart, token.myTokenEnd);
            }
            if (n instanceof ErrorItem) {
                return Factory.createErrorElement(((ErrorItem)n).myMessage);
            }
            StartMarker startMarker = (StartMarker)n;
            CompositeElement composite = n == this.myRoot ? (CompositeElement)this.myRoot.myBuilder.createRootAST(this.myRoot) : PsiBuilderImpl.createComposite(startMarker);
            startMarker.myBuilder.bind(startMarker, composite);
            return composite;
        }
    }

    private static class MyTreeStructure
    implements FlyweightCapableTreeStructure<LighterASTNode> {
        private final LimitedPool<Token> myPool;
        private final LimitedPool<LazyParseableToken> myLazyPool;
        private final StartMarker myRoot;
        private int count;
        private LighterASTNode[] nodes;

        public MyTreeStructure(@NotNull StartMarker root, @Nullable MyTreeStructure parentTree) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "<init>"));
            }
            if (parentTree == null) {
                this.myPool = new LimitedPool<Token>(1000, new LimitedPool.ObjectFactory<Token>(){

                    @Override
                    public void cleanup(@NotNull Token token) {
                        if (token == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure$1", "cleanup"));
                        }
                        token.clean();
                    }

                    @Override
                    @NotNull
                    public Token create() {
                        TokenNode tokenNode = new TokenNode();
                        if (tokenNode == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure$1", "create"));
                        }
                        return tokenNode;
                    }
                });
                this.myLazyPool = new LimitedPool<LazyParseableToken>(200, new LimitedPool.ObjectFactory<LazyParseableToken>(){

                    @Override
                    public void cleanup(@NotNull LazyParseableToken token) {
                        if (token == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure$2", "cleanup"));
                        }
                        token.clean();
                    }

                    @Override
                    @NotNull
                    public LazyParseableToken create() {
                        LazyParseableToken lazyParseableToken = new LazyParseableToken();
                        if (lazyParseableToken == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure$2", "create"));
                        }
                        return lazyParseableToken;
                    }
                });
            } else {
                this.myPool = parentTree.myPool;
                this.myLazyPool = parentTree.myLazyPool;
            }
            this.myRoot = root;
        }

        @Override
        @NotNull
        public LighterASTNode getRoot() {
            StartMarker startMarker = this.myRoot;
            if (startMarker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "getRoot"));
            }
            return startMarker;
        }

        @Override
        public LighterASTNode getParent(@NotNull LighterASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "getParent"));
            }
            if (node instanceof ProductionMarker) {
                return ((ProductionMarker)node).myParent;
            }
            throw new UnsupportedOperationException("Unknown node type: " + node);
        }

        @Override
        @NotNull
        public LighterASTNode prepareForGetChildren(@NotNull LighterASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "prepareForGetChildren"));
            }
            LighterASTNode lighterASTNode = node;
            if (lighterASTNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "prepareForGetChildren"));
            }
            return lighterASTNode;
        }

        @Override
        public int getChildren(@NotNull LighterASTNode item, @NotNull Ref<LighterASTNode[]> into) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "getChildren"));
            }
            if (into == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "into", "com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "getChildren"));
            }
            if (item instanceof LazyParseableToken) {
                FlyweightCapableTreeStructure<LighterASTNode> tree = ((LazyParseableToken)item).parseContents();
                LighterASTNode root = tree.getRoot();
                if (root instanceof ProductionMarker) {
                    ((ProductionMarker)root).myParent = ((LazyParseableToken)item).myParentNode;
                }
                return tree.getChildren(tree.prepareForGetChildren(root), into);
            }
            if (item instanceof Token || item instanceof ErrorItem) {
                return 0;
            }
            StartMarker marker = (StartMarker)item;
            this.count = 0;
            ProductionMarker child = marker.myFirstChild;
            int lexIndex = marker.myLexemeIndex;
            while (child != null) {
                lexIndex = this.insertLeaves(lexIndex, child.myLexemeIndex, marker.myBuilder, marker);
                if (child instanceof StartMarker && ((StartMarker)child).myDoneMarker.myCollapse) {
                    int lastIndex = ((StartMarker)((StartMarker)child)).myDoneMarker.myLexemeIndex;
                    this.insertLeaf(child.getTokenType(), marker.myBuilder, child.myLexemeIndex, lastIndex, true, marker);
                } else {
                    this.ensureCapacity();
                    this.nodes[this.count++] = child;
                }
                if (child instanceof StartMarker) {
                    lexIndex = ((StartMarker)((StartMarker)child)).myDoneMarker.myLexemeIndex;
                }
                child = child.myNext;
            }
            this.insertLeaves(lexIndex, ((StartMarker)marker).myDoneMarker.myLexemeIndex, marker.myBuilder, marker);
            into.set(this.nodes == null ? LighterASTNode.EMPTY_ARRAY : this.nodes);
            this.nodes = null;
            return this.count;
        }

        public void disposeChildren(LighterASTNode[] nodes, int count) {
            if (nodes == null) {
                return;
            }
            for (int i = 0; i < count; ++i) {
                LighterASTNode node = nodes[i];
                if (node instanceof LazyParseableToken) {
                    this.myLazyPool.recycle((LazyParseableToken)node);
                    continue;
                }
                if (!(node instanceof Token)) continue;
                this.myPool.recycle((Token)node);
            }
        }

        private void ensureCapacity() {
            LighterASTNode[] old = this.nodes;
            if (old == null) {
                this.nodes = old = new LighterASTNode[10];
            } else if (this.count >= old.length) {
                LighterASTNode[] newStore = new LighterASTNode[this.count * 3 / 2];
                System.arraycopy(old, 0, newStore, 0, this.count);
                this.nodes = newStore;
            }
        }

        private int insertLeaves(int curToken, int lastIdx, PsiBuilderImpl builder, StartMarker parent) {
            lastIdx = Math.min(lastIdx, builder.myLexemeCount);
            while (curToken < lastIdx) {
                this.insertLeaf(builder.myLexTypes[curToken], builder, curToken, curToken + 1, false, parent);
                ++curToken;
            }
            return curToken;
        }

        private void insertLeaf(@NotNull IElementType type, @NotNull PsiBuilderImpl builder, int startLexemeIndex, int endLexemeIndex, boolean forceInsertion, StartMarker parent) {
            Token lexeme;
            int end;
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "insertLeaf"));
            }
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "insertLeaf"));
            }
            int start = builder.myLexStarts[startLexemeIndex];
            if (start > (end = builder.myLexStarts[endLexemeIndex]) || !forceInsertion && start == end && !(type instanceof ILeafElementType)) {
                return;
            }
            if (type instanceof ILightLazyParseableElementType) {
                lexeme = this.myLazyPool.alloc();
                LazyParseableToken lazyParseableToken = (LazyParseableToken)lexeme;
                lazyParseableToken.myParentStructure = this;
                lazyParseableToken.myParentNode = parent;
                lazyParseableToken.myStartIndex = startLexemeIndex;
                lazyParseableToken.myEndIndex = endLexemeIndex;
            } else {
                lexeme = this.myPool.alloc();
            }
            lexeme.myBuilder = builder;
            lexeme.myTokenType = type;
            lexeme.myTokenStart = start;
            lexeme.myTokenEnd = end;
            this.ensureCapacity();
            this.nodes[this.count++] = lexeme;
        }

        @Override
        @NotNull
        public CharSequence toString(@NotNull LighterASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "toString"));
            }
            CharSequence charSequence = this.myRoot.myBuilder.myText.subSequence(node.getStartOffset(), node.getEndOffset());
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "toString"));
            }
            return charSequence;
        }

        @Override
        public int getStartOffset(@NotNull LighterASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "getStartOffset"));
            }
            return node.getStartOffset();
        }

        @Override
        public int getEndOffset(@NotNull LighterASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "getEndOffset"));
            }
            return node.getEndOffset();
        }
    }

    private static class MyComparator
    implements ShallowNodeComparator<ASTNode, LighterASTNode> {
        private final TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState> custom;
        private final MyTreeStructure myTreeStructure;

        private MyComparator(TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState> custom, @NotNull MyTreeStructure treeStructure) {
            if (treeStructure == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeStructure", "com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "<init>"));
            }
            this.custom = custom;
            this.myTreeStructure = treeStructure;
        }

        @Override
        @NotNull
        public ThreeState deepEqual(@NotNull ASTNode oldNode, @NotNull LighterASTNode newNode) {
            ThreeState customResult;
            boolean newIsErrorElement;
            if (oldNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNode", "com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "deepEqual"));
            }
            if (newNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNode", "com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "deepEqual"));
            }
            ProgressIndicatorProvider.checkCanceled();
            boolean oldIsErrorElement = oldNode instanceof PsiErrorElement;
            boolean bl = newIsErrorElement = newNode.getTokenType() == TokenType.ERROR_ELEMENT;
            if (oldIsErrorElement != newIsErrorElement) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "deepEqual"));
                }
                return threeState;
            }
            if (oldIsErrorElement) {
                PsiErrorElement e1 = (PsiErrorElement)((Object)oldNode);
                ThreeState threeState = Comparing.equal(e1.getErrorDescription(), PsiBuilderImpl.getErrorMessage(newNode)) ? ThreeState.UNSURE : ThreeState.NO;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "deepEqual"));
                }
                return threeState;
            }
            if (this.custom != null && (customResult = this.custom.fun(oldNode, newNode, this.myTreeStructure)) != ThreeState.UNSURE) {
                ThreeState threeState = customResult;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "deepEqual"));
                }
                return threeState;
            }
            if (newNode instanceof Token) {
                IElementType type = newNode.getTokenType();
                Token token = (Token)newNode;
                if (oldNode instanceof ForeignLeafPsiElement) {
                    ThreeState threeState = type instanceof ForeignLeafType && ((ForeignLeafType)type).getValue().equals(oldNode.getText()) ? ThreeState.YES : ThreeState.NO;
                    if (threeState == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "deepEqual"));
                    }
                    return threeState;
                }
                if (oldNode instanceof LeafElement) {
                    if (type instanceof ForeignLeafType) {
                        ThreeState threeState = ThreeState.NO;
                        if (threeState == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "deepEqual"));
                        }
                        return threeState;
                    }
                    ThreeState threeState = ((LeafElement)oldNode).textMatches(token.getText()) ? ThreeState.YES : ThreeState.NO;
                    if (threeState == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "deepEqual"));
                    }
                    return threeState;
                }
                if (type instanceof ILightLazyParseableElementType) {
                    ThreeState threeState = ((TreeElement)oldNode).textMatches(token.getText()) ? ThreeState.YES : (TreeUtil.isCollapsedChameleon(oldNode) ? ThreeState.NO : ThreeState.UNSURE);
                    if (threeState == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "deepEqual"));
                    }
                    return threeState;
                }
                if (oldNode.getElementType() instanceof ILazyParseableElementType && type instanceof ILazyParseableElementType || oldNode.getElementType() instanceof ICustomParsingType && type instanceof ICustomParsingType) {
                    ThreeState threeState = ((TreeElement)oldNode).textMatches(token.getText()) ? ThreeState.YES : ThreeState.NO;
                    if (threeState == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "deepEqual"));
                    }
                    return threeState;
                }
            }
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "deepEqual"));
            }
            return threeState;
        }

        @Override
        public boolean typesEqual(@NotNull ASTNode n1, @NotNull LighterASTNode n2) {
            IElementType n2t;
            IElementType n1t;
            if (n1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n1", "com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "typesEqual"));
            }
            if (n2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n2", "com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "typesEqual"));
            }
            if (n1 instanceof PsiWhiteSpaceImpl) {
                return ourAnyLanguageWhitespaceTokens.contains(n2.getTokenType()) || n2 instanceof Token && ((Token)n2).myBuilder.myWhitespaces.contains(n2.getTokenType());
            }
            if (n1 instanceof ForeignLeafPsiElement) {
                n1t = ((ForeignLeafPsiElement)n1).getForeignType();
                n2t = n2.getTokenType();
            } else {
                n1t = MyComparator.dereferenceToken(n1.getElementType());
                n2t = MyComparator.dereferenceToken(n2.getTokenType());
            }
            return Comparing.equal(n1t, n2t);
        }

        private static IElementType dereferenceToken(IElementType probablyWrapper) {
            if (probablyWrapper instanceof TokenWrapper) {
                return MyComparator.dereferenceToken(((TokenWrapper)probablyWrapper).getDelegate());
            }
            return probablyWrapper;
        }

        @Override
        public boolean hashCodesEqual(@NotNull ASTNode n1, @NotNull LighterASTNode n2) {
            PsiErrorElement e1;
            if (n1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n1", "com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "hashCodesEqual"));
            }
            if (n2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n2", "com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "hashCodesEqual"));
            }
            if (n1 instanceof LeafElement && n2 instanceof Token) {
                boolean isForeign1 = n1 instanceof ForeignLeafPsiElement;
                boolean isForeign2 = n2.getTokenType() instanceof ForeignLeafType;
                if (isForeign1 != isForeign2) {
                    return false;
                }
                if (isForeign1) {
                    return n1.getText().equals(((ForeignLeafType)n2.getTokenType()).getValue());
                }
                return ((LeafElement)n1).textMatches(((Token)n2).getText());
            }
            if (n1 instanceof PsiErrorElement && n2.getTokenType() == TokenType.ERROR_ELEMENT && !Comparing.equal((e1 = (PsiErrorElement)((Object)n1)).getErrorDescription(), PsiBuilderImpl.getErrorMessage(n2))) {
                return false;
            }
            return ((TreeElement)n1).hc() == ((Node)n2).hc();
        }
    }

    private final class RelativeTokenTextView
    implements WhitespacesAndCommentsBinder.TokenTextGetter {
        private int myStart;

        private RelativeTokenTextView() {
        }

        private void configure(int start) {
            this.myStart = start;
        }

        @Override
        @NotNull
        public CharSequence get(int i) {
            CharSequence charSequence = PsiBuilderImpl.this.myText.subSequence(PsiBuilderImpl.this.myLexStarts[this.myStart + i], PsiBuilderImpl.this.myLexStarts[this.myStart + i + 1]);
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl$RelativeTokenTextView", "get"));
            }
            return charSequence;
        }
    }

    private final class RelativeTokenTypesView
    extends AbstractList<IElementType> {
        private int myStart;
        private int mySize;

        private RelativeTokenTypesView() {
        }

        private void configure(int start, int end) {
            this.myStart = start;
            this.mySize = end - start;
        }

        @Override
        public IElementType get(int index) {
            return PsiBuilderImpl.this.myLexTypes[this.myStart + index];
        }

        @Override
        public int size() {
            return this.mySize;
        }
    }

    private static class ConvertFromTokensToASTBuilder
    implements DiffTreeChangeBuilder<ASTNode, LighterASTNode> {
        private final DiffTreeChangeBuilder<ASTNode, ASTNode> myDelegate;
        private final ASTConverter myConverter;

        private ConvertFromTokensToASTBuilder(@NotNull StartMarker rootNode, @NotNull DiffTreeChangeBuilder<ASTNode, ASTNode> delegate) {
            if (rootNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootNode", "com/intellij/lang/impl/PsiBuilderImpl$ConvertFromTokensToASTBuilder", "<init>"));
            }
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/lang/impl/PsiBuilderImpl$ConvertFromTokensToASTBuilder", "<init>"));
            }
            this.myDelegate = delegate;
            this.myConverter = new ASTConverter(rootNode);
        }

        @Override
        public void nodeDeleted(@NotNull ASTNode oldParent, @NotNull ASTNode oldNode) {
            if (oldParent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldParent", "com/intellij/lang/impl/PsiBuilderImpl$ConvertFromTokensToASTBuilder", "nodeDeleted"));
            }
            if (oldNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNode", "com/intellij/lang/impl/PsiBuilderImpl$ConvertFromTokensToASTBuilder", "nodeDeleted"));
            }
            this.myDelegate.nodeDeleted(oldParent, oldNode);
        }

        @Override
        public void nodeInserted(@NotNull ASTNode oldParent, @NotNull LighterASTNode newNode, int pos) {
            if (oldParent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldParent", "com/intellij/lang/impl/PsiBuilderImpl$ConvertFromTokensToASTBuilder", "nodeInserted"));
            }
            if (newNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNode", "com/intellij/lang/impl/PsiBuilderImpl$ConvertFromTokensToASTBuilder", "nodeInserted"));
            }
            this.myDelegate.nodeInserted(oldParent, this.myConverter.convert((Node)newNode), pos);
        }

        @Override
        public void nodeReplaced(@NotNull ASTNode oldChild, @NotNull LighterASTNode newChild) {
            if (oldChild == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldChild", "com/intellij/lang/impl/PsiBuilderImpl$ConvertFromTokensToASTBuilder", "nodeReplaced"));
            }
            if (newChild == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newChild", "com/intellij/lang/impl/PsiBuilderImpl$ConvertFromTokensToASTBuilder", "nodeReplaced"));
            }
            ASTNode converted = this.myConverter.convert((Node)newChild);
            this.myDelegate.nodeReplaced(oldChild, converted);
        }
    }

    private static class ErrorItem
    extends ProductionMarker {
        private final PsiBuilderImpl myBuilder;
        private String myMessage;

        public ErrorItem(PsiBuilderImpl builder, String message, int idx) {
            this.myBuilder = builder;
            this.myMessage = message;
            this.myLexemeIndex = idx;
            this.myEdgeTokenBinder = WhitespacesBinders.DEFAULT_RIGHT_BINDER;
        }

        @Override
        public void clean() {
            super.clean();
            this.myMessage = null;
        }

        @Override
        public int hc() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return this.myBuilder.myLexStarts[this.myLexemeIndex] + this.myBuilder.myOffset;
        }

        @Override
        public int getStartOffset() {
            return this.myBuilder.myLexStarts[this.myLexemeIndex] + this.myBuilder.myOffset;
        }

        @Override
        @NotNull
        public IElementType getTokenType() {
            IElementType iElementType = TokenType.ERROR_ELEMENT;
            if (iElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl$ErrorItem", "getTokenType"));
            }
            return iElementType;
        }
    }

    private static class DoneWithErrorMarker
    extends DoneMarker {
        private String myMessage;

        private DoneWithErrorMarker(@NotNull StartMarker marker, int currentLexeme, String message) {
            if (marker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/lang/impl/PsiBuilderImpl$DoneWithErrorMarker", "<init>"));
            }
            super(marker, currentLexeme);
            this.myMessage = message;
        }

        @Override
        public void clean() {
            super.clean();
            this.myMessage = null;
        }
    }

    private static class DoneMarker
    extends ProductionMarker {
        private StartMarker myStart;
        private boolean myCollapse;

        public DoneMarker() {
            this.myEdgeTokenBinder = WhitespacesBinders.DEFAULT_RIGHT_BINDER;
        }

        public DoneMarker(StartMarker marker, int currentLexeme) {
            this();
            this.myLexemeIndex = currentLexeme;
            this.myStart = marker;
        }

        @Override
        public void clean() {
            super.clean();
            this.myStart = null;
            this.myEdgeTokenBinder = WhitespacesBinders.DEFAULT_RIGHT_BINDER;
        }

        @Override
        public int hc() {
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }

        @Override
        @NotNull
        public IElementType getTokenType() {
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }

        @Override
        public int getEndOffset() {
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }

        @Override
        public int getStartOffset() {
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }
    }

    private static class LazyParseableToken
    extends Token
    implements LighterLazyParseableNode {
        private MyTreeStructure myParentStructure;
        private StartMarker myParentNode;
        private FlyweightCapableTreeStructure<LighterASTNode> myParsed;
        private int myStartIndex;
        private int myEndIndex;

        private LazyParseableToken() {
        }

        @Override
        public void clean() {
            super.clean();
            this.myParentStructure = null;
            this.myParentNode = null;
            this.myParsed = null;
        }

        @Override
        public PsiFile getContainingFile() {
            return this.myBuilder.myFile;
        }

        @Override
        public CharTable getCharTable() {
            return this.myBuilder.myCharTable;
        }

        public FlyweightCapableTreeStructure<LighterASTNode> parseContents() {
            if (this.myParsed == null) {
                this.myParsed = ((ILightLazyParseableElementType)((Object)this.getTokenType())).parseContents(this);
            }
            return this.myParsed;
        }

        @Override
        public boolean accept(@NotNull LighterLazyParseableNode.Visitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/impl/PsiBuilderImpl$LazyParseableToken", "accept"));
            }
            for (int i = this.myStartIndex; i < this.myEndIndex; ++i) {
                IElementType type = this.myBuilder.myLexTypes[i];
                if (visitor.visit(type)) continue;
                return false;
            }
            return true;
        }
    }

    private static class TokenNode
    extends Token
    implements LighterASTTokenNode {
        private TokenNode() {
        }

        public String toString() {
            return this.getText().toString();
        }
    }

    private static abstract class Token
    extends Node {
        protected PsiBuilderImpl myBuilder;
        private IElementType myTokenType;
        private int myTokenStart;
        private int myTokenEnd;
        private int myHC = -1;

        private Token() {
        }

        public void clean() {
            this.myBuilder = null;
            this.myHC = -1;
        }

        @Override
        public int hc() {
            if (this.myHC == -1) {
                int hc = 0;
                if (this.myTokenType instanceof TokenWrapper) {
                    String value = ((TokenWrapper)this.myTokenType).getValue();
                    for (int i = 0; i < value.length(); ++i) {
                        hc += value.charAt(i);
                    }
                } else {
                    int start = this.myTokenStart;
                    int end = this.myTokenEnd;
                    CharSequence buf = this.myBuilder.myText;
                    char[] bufArray = this.myBuilder.myTextArray;
                    for (int i = start; i < end; ++i) {
                        hc += bufArray != null ? bufArray[i] : buf.charAt(i);
                    }
                }
                this.myHC = hc;
            }
            return this.myHC;
        }

        @Override
        public int getEndOffset() {
            return this.myTokenEnd + this.myBuilder.myOffset;
        }

        @Override
        public int getStartOffset() {
            return this.myTokenStart + this.myBuilder.myOffset;
        }

        @NotNull
        public CharSequence getText() {
            if (this.myTokenType instanceof TokenWrapper) {
                String string = ((TokenWrapper)this.myTokenType).getValue();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl$Token", "getText"));
                }
                return string;
            }
            CharSequence charSequence = this.myBuilder.myText.subSequence(this.myTokenStart, this.myTokenEnd);
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl$Token", "getText"));
            }
            return charSequence;
        }

        @Override
        @NotNull
        public IElementType getTokenType() {
            IElementType iElementType = this.myTokenType;
            if (iElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl$Token", "getTokenType"));
            }
            return iElementType;
        }
    }

    private static class StartMarker
    extends ProductionMarker
    implements PsiBuilder.Marker {
        private PsiBuilderImpl myBuilder;
        private IElementType myType;
        private DoneMarker myDoneMarker;
        private Throwable myDebugAllocationPosition;
        private ProductionMarker myFirstChild;
        private ProductionMarker myLastChild;
        private int myHC = -1;

        private StartMarker() {
            this.myEdgeTokenBinder = WhitespacesBinders.DEFAULT_LEFT_BINDER;
        }

        @Override
        public void clean() {
            super.clean();
            this.myBuilder = null;
            this.myType = null;
            this.myDoneMarker = null;
            this.myDebugAllocationPosition = null;
            this.myLastChild = null;
            this.myFirstChild = null;
            this.myHC = -1;
            this.myEdgeTokenBinder = WhitespacesBinders.DEFAULT_LEFT_BINDER;
        }

        @Override
        public int hc() {
            if (this.myHC == -1) {
                PsiBuilderImpl builder = this.myBuilder;
                int hc = 0;
                CharSequence buf = builder.myText;
                char[] bufArray = builder.myTextArray;
                ProductionMarker child = this.myFirstChild;
                int lexIdx = this.myLexemeIndex;
                while (child != null) {
                    int lastLeaf = child.myLexemeIndex;
                    for (int i = builder.myLexStarts[lexIdx]; i < builder.myLexStarts[lastLeaf]; ++i) {
                        hc += bufArray != null ? bufArray[i] : buf.charAt(i);
                    }
                    lexIdx = lastLeaf;
                    hc += child.hc();
                    if (child instanceof StartMarker) {
                        lexIdx = ((StartMarker)child).myDoneMarker.myLexemeIndex;
                    }
                    child = child.myNext;
                }
                for (int i = builder.myLexStarts[lexIdx]; i < builder.myLexStarts[this.myDoneMarker.myLexemeIndex]; ++i) {
                    hc += bufArray != null ? bufArray[i] : buf.charAt(i);
                }
                this.myHC = hc;
            }
            return this.myHC;
        }

        @Override
        public int getStartOffset() {
            return this.myBuilder.myLexStarts[this.myLexemeIndex] + this.myBuilder.myOffset;
        }

        @Override
        public int getEndOffset() {
            return this.myBuilder.myLexStarts[this.myDoneMarker.myLexemeIndex] + this.myBuilder.myOffset;
        }

        @Override
        public int getEndIndex() {
            return this.myDoneMarker.myLexemeIndex;
        }

        public void addChild(@NotNull ProductionMarker node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/impl/PsiBuilderImpl$StartMarker", "addChild"));
            }
            if (this.myFirstChild == null) {
                this.myFirstChild = node;
                this.myLastChild = node;
            } else {
                this.myLastChild.myNext = node;
                this.myLastChild = node;
            }
        }

        @Override
        @NotNull
        public PsiBuilder.Marker precede() {
            PsiBuilder.Marker marker = this.myBuilder.precede(this);
            if (marker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderImpl$StartMarker", "precede"));
            }
            return marker;
        }

        @Override
        public void drop() {
            this.myBuilder.drop(this);
        }

        @Override
        public void rollbackTo() {
            this.myBuilder.rollbackTo(this);
        }

        @Override
        public void done(@NotNull IElementType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/impl/PsiBuilderImpl$StartMarker", "done"));
            }
            this.myType = type;
            this.myBuilder.done(this);
        }

        @Override
        public void collapse(@NotNull IElementType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/impl/PsiBuilderImpl$StartMarker", "collapse"));
            }
            this.myType = type;
            this.myBuilder.collapse(this);
        }

        @Override
        public void doneBefore(@NotNull IElementType type, @NotNull PsiBuilder.Marker before) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/impl/PsiBuilderImpl$StartMarker", "doneBefore"));
            }
            if (before == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "before", "com/intellij/lang/impl/PsiBuilderImpl$StartMarker", "doneBefore"));
            }
            this.myType = type;
            this.myBuilder.doneBefore(this, before);
        }

        @Override
        public void doneBefore(@NotNull IElementType type, @NotNull PsiBuilder.Marker before, String errorMessage) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/impl/PsiBuilderImpl$StartMarker", "doneBefore"));
            }
            if (before == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "before", "com/intellij/lang/impl/PsiBuilderImpl$StartMarker", "doneBefore"));
            }
            StartMarker marker = (StartMarker)before;
            this.myBuilder.myProduction.add(this.myBuilder.myProduction.lastIndexOf(marker), new ErrorItem(this.myBuilder, errorMessage, marker.myLexemeIndex));
            this.doneBefore(type, before);
        }

        @Override
        public void error(String message) {
            this.myType = TokenType.ERROR_ELEMENT;
            this.myBuilder.error(this, message);
        }

        @Override
        public void errorBefore(String message, @NotNull PsiBuilder.Marker before) {
            if (before == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "before", "com/intellij/lang/impl/PsiBuilderImpl$StartMarker", "errorBefore"));
            }
            this.myType = TokenType.ERROR_ELEMENT;
            this.myBuilder.errorBefore(this, message, before);
        }

        @Override
        public IElementType getTokenType() {
            return this.myType;
        }

        @Override
        public void remapTokenType(@NotNull IElementType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/impl/PsiBuilderImpl$StartMarker", "remapTokenType"));
            }
            this.myType = type;
        }

        @Override
        public void setCustomEdgeTokenBinders(WhitespacesAndCommentsBinder left, WhitespacesAndCommentsBinder right) {
            if (left != null) {
                this.myEdgeTokenBinder = left;
            }
            if (right != null) {
                if (this.myDoneMarker == null) {
                    throw new IllegalArgumentException("Cannot set right-edge processor for unclosed marker");
                }
                this.myDoneMarker.myEdgeTokenBinder = right;
            }
        }

        public String toString() {
            if (this.myBuilder == null) {
                return "<dropped>";
            }
            boolean isDone = this.myDoneMarker != null;
            CharSequence originalText = this.myBuilder.getOriginalText();
            int startOffset = this.getStartOffset() - this.myBuilder.myOffset;
            int endOffset = isDone ? this.getEndOffset() - this.myBuilder.myOffset : this.myBuilder.getCurrentOffset();
            CharSequence text = originalText.subSequence(startOffset, endOffset);
            return isDone ? text.toString() : text + "...";
        }
    }

    public static abstract class ProductionMarker
    extends Node {
        protected int myLexemeIndex;
        protected WhitespacesAndCommentsBinder myEdgeTokenBinder;
        protected ProductionMarker myParent;
        protected ProductionMarker myNext;

        public void clean() {
            this.myLexemeIndex = 0;
            this.myNext = null;
            this.myParent = null;
        }

        public void remapTokenType(@NotNull IElementType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/impl/PsiBuilderImpl$ProductionMarker", "remapTokenType"));
            }
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }

        public int getStartIndex() {
            return this.myLexemeIndex;
        }

        public int getEndIndex() {
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }
    }

    private static abstract class Node
    implements LighterASTNode {
        private Node() {
        }

        public abstract int hc();
    }
}

