/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class MockDumbService
extends DumbService {
    private final Project myProject;

    public MockDumbService(Project project) {
        this.myProject = project;
    }

    @Override
    public ModificationTracker getModificationTracker() {
        return new SimpleModificationTracker();
    }

    @Override
    public boolean isDumb() {
        return false;
    }

    @Override
    public void runWhenSmart(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/mock/MockDumbService", "runWhenSmart"));
        }
        runnable.run();
    }

    @Override
    public void waitForSmartMode() {
    }

    @Override
    public void queueTask(@NotNull DumbModeTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/mock/MockDumbService", "queueTask"));
        }
        task.performInDumbMode(new EmptyProgressIndicator());
        Disposer.dispose(task);
    }

    @Override
    public void cancelTask(@NotNull DumbModeTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/mock/MockDumbService", "cancelTask"));
        }
    }

    @Override
    public JComponent wrapGently(@NotNull JComponent dumbUnawareContent, @NotNull Disposable parentDisposable) {
        if (dumbUnawareContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dumbUnawareContent", "com/intellij/mock/MockDumbService", "wrapGently"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/mock/MockDumbService", "wrapGently"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void showDumbModeNotification(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/mock/MockDumbService", "showDumbModeNotification"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public void setAlternativeResolveEnabled(boolean enabled) {
    }

    @Override
    public boolean isAlternativeResolveEnabled() {
        return false;
    }

    @Override
    public void smartInvokeLater(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/mock/MockDumbService", "smartInvokeLater"));
        }
        runnable.run();
    }

    @Override
    public void smartInvokeLater(@NotNull Runnable runnable, @NotNull ModalityState modalityState) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/mock/MockDumbService", "smartInvokeLater"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/mock/MockDumbService", "smartInvokeLater"));
        }
        runnable.run();
    }
}

