/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.util.ArrayUtil;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

class UsedColors {
    private static final Key<Object> USED_COLOR = Key.create("USED_COLOR");
    public static final AtomicInteger counter = new AtomicInteger();

    UsedColors() {
    }

    static int getOrAddColorIndex(@NotNull UserDataHolderEx context, @NotNull String name, @NotNull RainbowHighlighter rainbowHighlighter) {
        int colorIndex;
        UsedColor[] newColors;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/UsedColors", "getOrAddColorIndex"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/UsedColors", "getOrAddColorIndex"));
        }
        if (rainbowHighlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rainbowHighlighter", "com/intellij/codeInsight/daemon/UsedColors", "getOrAddColorIndex"));
        }
        int colorsCount = rainbowHighlighter.getColorsCount();
        Object data = context.getUserData(USED_COLOR);
        do {
            UsedColor[] usedColors;
            if (data == null) {
                colorIndex = UsedColors.hashColor(name, colorsCount);
                newColors = new UsedColor(name, colorIndex);
                continue;
            }
            if (data instanceof UsedColor) {
                UsedColor usedColor = (UsedColor)data;
                if (usedColor.name.equals(name)) {
                    colorIndex = usedColor.index;
                    newColors = null;
                    continue;
                }
                int hashedIndex = UsedColors.hashColor(name, colorsCount);
                if (hashedIndex == usedColor.index) {
                    hashedIndex = (hashedIndex + 1) % colorsCount;
                }
                colorIndex = hashedIndex;
                UsedColor newColor = new UsedColor(name, colorIndex);
                newColors = new UsedColor[]{usedColor, newColor};
                continue;
            }
            colorIndex = -1;
            int hashedIndex = UsedColors.hashColor(name, colorsCount);
            int[] index2usage = new int[colorsCount];
            for (UsedColor usedColor : usedColors = (UsedColor[])data) {
                int index;
                int n = index = usedColor.index;
                index2usage[n] = index2usage[n] + 1;
                if (!usedColor.name.equals(name)) continue;
                colorIndex = index;
                break;
            }
            if (colorIndex == -1) {
                int minIndex2;
                int minIndex1 = UsedColors.indexOfMin(index2usage, hashedIndex, colorsCount);
                colorIndex = index2usage[minIndex1] <= index2usage[minIndex2 = UsedColors.indexOfMin(index2usage, 0, hashedIndex)] ? minIndex1 : minIndex2;
                UsedColor newColor = new UsedColor(name, colorIndex);
                newColors = ArrayUtil.append(usedColors, newColor);
                continue;
            }
            newColors = null;
        } while (newColors != null && !context.replace(USED_COLOR, data, newColors));
        return colorIndex;
    }

    private static int hashColor(@NotNull String name, int colorsCount) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/UsedColors", "hashColor"));
        }
        return Math.abs(StringHash.murmur(name, 21930)) % colorsCount;
    }

    private static int indexOfMin(@NotNull int[] values, int start, int end) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/codeInsight/daemon/UsedColors", "indexOfMin"));
        }
        int min = Integer.MAX_VALUE;
        int minIndex = start;
        for (int i = start; i < end; ++i) {
            int value = values[i];
            if (value >= min) continue;
            min = value;
            minIndex = i;
        }
        return minIndex;
    }

    private static class UsedColor {
        @NotNull
        final String name;
        final int index;

        UsedColor(@NotNull String name, int index) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/UsedColors$UsedColor", "<init>"));
            }
            this.name = name;
            this.index = index;
            counter.incrementAndGet();
        }
    }
}

